/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ArrayCopyUtils;

public abstract class BaseTransformFunction
implements TransformFunction {
    protected static final TransformResultMetadata INT_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.INT, true, false);
    protected static final TransformResultMetadata LONG_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.LONG, true, false);
    protected static final TransformResultMetadata FLOAT_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.FLOAT, true, false);
    protected static final TransformResultMetadata DOUBLE_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.DOUBLE, true, false);
    protected static final TransformResultMetadata BOOLEAN_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.BOOLEAN, true, false);
    protected static final TransformResultMetadata TIMESTAMP_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.TIMESTAMP, true, false);
    protected static final TransformResultMetadata STRING_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.STRING, true, false);
    protected static final TransformResultMetadata STRING_MV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.STRING, false, false);
    protected static final TransformResultMetadata JSON_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.JSON, true, false);
    protected static final TransformResultMetadata BYTES_SV_NO_DICTIONARY_METADATA = new TransformResultMetadata(FieldSpec.DataType.BYTES, true, false);
    protected int[] _intValuesSV;
    protected long[] _longValuesSV;
    protected float[] _floatValuesSV;
    protected double[] _doubleValuesSV;
    protected String[] _stringValuesSV;
    protected byte[][] _byteValuesSV;
    protected int[][] _intValuesMV;
    protected long[][] _longValuesMV;
    protected float[][] _floatValuesMV;
    protected double[][] _doubleValuesMV;
    protected String[][] _stringValuesMV;

    @Override
    public Dictionary getDictionary() {
        return null;
    }

    @Override
    public int[] transformToDictIdsSV(ProjectionBlock projectionBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[][] transformToDictIdsMV(ProjectionBlock projectionBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        if (this._intValuesSV == null) {
            this._intValuesSV = new int[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        int length = projectionBlock.getNumDocs();
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[] dictIds = this.transformToDictIdsSV(projectionBlock);
            dictionary.readIntValues(dictIds, length, this._intValuesSV);
        } else {
            switch (this.getResultMetadata().getDataType().getStoredType()) {
                case LONG: {
                    long[] longValues = this.transformToLongValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((long[])longValues, (int[])this._intValuesSV, (int)length);
                    break;
                }
                case FLOAT: {
                    float[] floatValues = this.transformToFloatValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((float[])floatValues, (int[])this._intValuesSV, (int)length);
                    break;
                }
                case DOUBLE: {
                    double[] doubleValues = this.transformToDoubleValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((double[])doubleValues, (int[])this._intValuesSV, (int)length);
                    break;
                }
                case STRING: {
                    String[] stringValues = this.transformToStringValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((String[])stringValues, (int[])this._intValuesSV, (int)length);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return this._intValuesSV;
    }

    @Override
    public long[] transformToLongValuesSV(ProjectionBlock projectionBlock) {
        if (this._longValuesSV == null) {
            this._longValuesSV = new long[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        int length = projectionBlock.getNumDocs();
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[] dictIds = this.transformToDictIdsSV(projectionBlock);
            dictionary.readLongValues(dictIds, length, this._longValuesSV);
        } else {
            switch (this.getResultMetadata().getDataType().getStoredType()) {
                case INT: {
                    int[] intValues = this.transformToIntValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((int[])intValues, (long[])this._longValuesSV, (int)length);
                    break;
                }
                case FLOAT: {
                    float[] floatValues = this.transformToFloatValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((float[])floatValues, (long[])this._longValuesSV, (int)length);
                    break;
                }
                case DOUBLE: {
                    double[] doubleValues = this.transformToDoubleValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((double[])doubleValues, (long[])this._longValuesSV, (int)length);
                    break;
                }
                case STRING: {
                    String[] stringValues = this.transformToStringValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((String[])stringValues, (long[])this._longValuesSV, (int)length);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return this._longValuesSV;
    }

    @Override
    public float[] transformToFloatValuesSV(ProjectionBlock projectionBlock) {
        if (this._floatValuesSV == null) {
            this._floatValuesSV = new float[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        int length = projectionBlock.getNumDocs();
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[] dictIds = this.transformToDictIdsSV(projectionBlock);
            dictionary.readFloatValues(dictIds, length, this._floatValuesSV);
        } else {
            switch (this.getResultMetadata().getDataType().getStoredType()) {
                case INT: {
                    int[] intValues = this.transformToIntValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((int[])intValues, (float[])this._floatValuesSV, (int)length);
                    break;
                }
                case LONG: {
                    long[] longValues = this.transformToLongValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((long[])longValues, (float[])this._floatValuesSV, (int)length);
                    break;
                }
                case DOUBLE: {
                    double[] doubleValues = this.transformToDoubleValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((double[])doubleValues, (float[])this._floatValuesSV, (int)length);
                    break;
                }
                case STRING: {
                    String[] stringValues = this.transformToStringValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((String[])stringValues, (float[])this._floatValuesSV, (int)length);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return this._floatValuesSV;
    }

    @Override
    public double[] transformToDoubleValuesSV(ProjectionBlock projectionBlock) {
        if (this._doubleValuesSV == null) {
            this._doubleValuesSV = new double[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        int length = projectionBlock.getNumDocs();
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[] dictIds = this.transformToDictIdsSV(projectionBlock);
            dictionary.readDoubleValues(dictIds, length, this._doubleValuesSV);
        } else {
            switch (this.getResultMetadata().getDataType().getStoredType()) {
                case INT: {
                    int[] intValues = this.transformToIntValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((int[])intValues, (double[])this._doubleValuesSV, (int)length);
                    break;
                }
                case LONG: {
                    long[] longValues = this.transformToLongValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((long[])longValues, (double[])this._doubleValuesSV, (int)length);
                    break;
                }
                case FLOAT: {
                    float[] floatValues = this.transformToFloatValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((float[])floatValues, (double[])this._doubleValuesSV, (int)length);
                    break;
                }
                case STRING: {
                    String[] stringValues = this.transformToStringValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((String[])stringValues, (double[])this._doubleValuesSV, (int)length);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return this._doubleValuesSV;
    }

    @Override
    public String[] transformToStringValuesSV(ProjectionBlock projectionBlock) {
        if (this._stringValuesSV == null) {
            this._stringValuesSV = new String[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        int length = projectionBlock.getNumDocs();
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[] dictIds = this.transformToDictIdsSV(projectionBlock);
            dictionary.readStringValues(dictIds, length, this._stringValuesSV);
        } else {
            switch (this.getResultMetadata().getDataType().getStoredType()) {
                case INT: {
                    int[] intValues = this.transformToIntValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((int[])intValues, (String[])this._stringValuesSV, (int)length);
                    break;
                }
                case LONG: {
                    long[] longValues = this.transformToLongValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((long[])longValues, (String[])this._stringValuesSV, (int)length);
                    break;
                }
                case FLOAT: {
                    float[] floatValues = this.transformToFloatValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((float[])floatValues, (String[])this._stringValuesSV, (int)length);
                    break;
                }
                case DOUBLE: {
                    double[] doubleValues = this.transformToDoubleValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((double[])doubleValues, (String[])this._stringValuesSV, (int)length);
                    break;
                }
                case BYTES: {
                    byte[][] bytesValues = this.transformToBytesValuesSV(projectionBlock);
                    ArrayCopyUtils.copy((byte[][])bytesValues, (String[])this._stringValuesSV, (int)length);
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return this._stringValuesSV;
    }

    @Override
    public byte[][] transformToBytesValuesSV(ProjectionBlock projectionBlock) {
        if (this._byteValuesSV == null) {
            this._byteValuesSV = new byte[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
        }
        int length = projectionBlock.getNumDocs();
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[] dictIds = this.transformToDictIdsSV(projectionBlock);
            dictionary.readIntValues(dictIds, length, this._intValuesSV);
        } else {
            Preconditions.checkState((this.getResultMetadata().getDataType().getStoredType() == FieldSpec.DataType.STRING ? 1 : 0) != 0);
            String[] stringValues = this.transformToStringValuesSV(projectionBlock);
            ArrayCopyUtils.copy((String[])stringValues, (byte[][])this._byteValuesSV, (int)length);
        }
        return this._byteValuesSV;
    }

    @Override
    public int[][] transformToIntValuesMV(ProjectionBlock projectionBlock) {
        if (this._intValuesMV == null) {
            this._intValuesMV = new int[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
        }
        int length = projectionBlock.getNumDocs();
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[][] dictIdsMV = this.transformToDictIdsMV(projectionBlock);
            for (int i = 0; i < length; ++i) {
                int[] dictIds = dictIdsMV[i];
                int numValues = dictIds.length;
                int[] intValues = new int[numValues];
                dictionary.readIntValues(dictIds, numValues, intValues);
                this._intValuesMV[i] = intValues;
            }
        } else {
            switch (this.getResultMetadata().getDataType().getStoredType()) {
                case LONG: {
                    long[][] longValuesMV = this.transformToLongValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        long[] longValues = longValuesMV[i];
                        int numValues = longValues.length;
                        int[] intValues = new int[numValues];
                        ArrayCopyUtils.copy((long[])longValues, (int[])intValues, (int)numValues);
                        this._intValuesMV[i] = intValues;
                    }
                    break;
                }
                case FLOAT: {
                    float[][] floatValuesMV = this.transformToFloatValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        float[] floatValues = floatValuesMV[i];
                        int numValues = floatValues.length;
                        int[] intValues = new int[numValues];
                        ArrayCopyUtils.copy((float[])floatValues, (int[])intValues, (int)numValues);
                        this._intValuesMV[i] = intValues;
                    }
                    break;
                }
                case DOUBLE: {
                    double[][] doubleValuesMV = this.transformToDoubleValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        double[] doubleValues = doubleValuesMV[i];
                        int numValues = doubleValues.length;
                        int[] intValues = new int[numValues];
                        ArrayCopyUtils.copy((double[])doubleValues, (int[])intValues, (int)numValues);
                        this._intValuesMV[i] = intValues;
                    }
                    break;
                }
                case STRING: {
                    String[][] stringValuesMV = this.transformToStringValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        String[] stringValues = stringValuesMV[i];
                        int numValues = stringValues.length;
                        int[] intValues = new int[numValues];
                        ArrayCopyUtils.copy((String[])stringValues, (int[])intValues, (int)numValues);
                        this._intValuesMV[i] = intValues;
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return this._intValuesMV;
    }

    @Override
    public long[][] transformToLongValuesMV(ProjectionBlock projectionBlock) {
        if (this._longValuesMV == null) {
            this._longValuesMV = new long[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
        }
        int length = projectionBlock.getNumDocs();
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[][] dictIdsMV = this.transformToDictIdsMV(projectionBlock);
            for (int i = 0; i < length; ++i) {
                int[] dictIds = dictIdsMV[i];
                int numValues = dictIds.length;
                long[] longValues = new long[numValues];
                dictionary.readLongValues(dictIds, numValues, longValues);
                this._longValuesMV[i] = longValues;
            }
        } else {
            switch (this.getResultMetadata().getDataType().getStoredType()) {
                case INT: {
                    int[][] intValuesMV = this.transformToIntValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        int[] intValues = intValuesMV[i];
                        int numValues = intValues.length;
                        long[] longValues = new long[numValues];
                        ArrayCopyUtils.copy((int[])intValues, (long[])longValues, (int)numValues);
                        this._longValuesMV[i] = longValues;
                    }
                    break;
                }
                case FLOAT: {
                    float[][] floatValuesMV = this.transformToFloatValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        float[] floatValues = floatValuesMV[i];
                        int numValues = floatValues.length;
                        long[] longValues = new long[numValues];
                        ArrayCopyUtils.copy((float[])floatValues, (long[])longValues, (int)numValues);
                        this._longValuesMV[i] = longValues;
                    }
                    break;
                }
                case DOUBLE: {
                    double[][] doubleValuesMV = this.transformToDoubleValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        double[] doubleValues = doubleValuesMV[i];
                        int numValues = doubleValues.length;
                        long[] longValues = new long[numValues];
                        ArrayCopyUtils.copy((double[])doubleValues, (long[])longValues, (int)numValues);
                        this._longValuesMV[i] = longValues;
                    }
                    break;
                }
                case STRING: {
                    String[][] stringValuesMV = this.transformToStringValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        String[] stringValues = stringValuesMV[i];
                        int numValues = stringValues.length;
                        long[] longValues = new long[numValues];
                        ArrayCopyUtils.copy((String[])stringValues, (long[])longValues, (int)numValues);
                        this._longValuesMV[i] = longValues;
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return this._longValuesMV;
    }

    @Override
    public float[][] transformToFloatValuesMV(ProjectionBlock projectionBlock) {
        if (this._floatValuesMV == null) {
            this._floatValuesMV = new float[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
        }
        int length = projectionBlock.getNumDocs();
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[][] dictIdsMV = this.transformToDictIdsMV(projectionBlock);
            for (int i = 0; i < length; ++i) {
                int[] dictIds = dictIdsMV[i];
                int numValues = dictIds.length;
                float[] floatValues = new float[numValues];
                dictionary.readFloatValues(dictIds, numValues, floatValues);
                this._floatValuesMV[i] = floatValues;
            }
        } else {
            switch (this.getResultMetadata().getDataType().getStoredType()) {
                case INT: {
                    int[][] intValuesMV = this.transformToIntValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        int[] intValues = intValuesMV[i];
                        int numValues = intValues.length;
                        float[] floatValues = new float[numValues];
                        ArrayCopyUtils.copy((int[])intValues, (float[])floatValues, (int)numValues);
                        this._floatValuesMV[i] = floatValues;
                    }
                    break;
                }
                case LONG: {
                    long[][] longValuesMV = this.transformToLongValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        long[] longValues = longValuesMV[i];
                        int numValues = longValues.length;
                        float[] floatValues = new float[numValues];
                        ArrayCopyUtils.copy((long[])longValues, (float[])floatValues, (int)numValues);
                        this._floatValuesMV[i] = floatValues;
                    }
                    break;
                }
                case DOUBLE: {
                    double[][] doubleValuesMV = this.transformToDoubleValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        double[] doubleValues = doubleValuesMV[i];
                        int numValues = doubleValues.length;
                        float[] floatValues = new float[numValues];
                        ArrayCopyUtils.copy((double[])doubleValues, (float[])floatValues, (int)numValues);
                        this._floatValuesMV[i] = floatValues;
                    }
                    break;
                }
                case STRING: {
                    String[][] stringValuesMV = this.transformToStringValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        String[] stringValues = stringValuesMV[i];
                        int numValues = stringValues.length;
                        float[] floatValues = new float[numValues];
                        ArrayCopyUtils.copy((String[])stringValues, (float[])floatValues, (int)numValues);
                        this._floatValuesMV[i] = floatValues;
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return this._floatValuesMV;
    }

    @Override
    public double[][] transformToDoubleValuesMV(ProjectionBlock projectionBlock) {
        if (this._doubleValuesMV == null) {
            this._doubleValuesMV = new double[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
        }
        int length = projectionBlock.getNumDocs();
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[][] dictIdsMV = this.transformToDictIdsMV(projectionBlock);
            for (int i = 0; i < length; ++i) {
                int[] dictIds = dictIdsMV[i];
                int numValues = dictIds.length;
                double[] doubleValues = new double[numValues];
                dictionary.readDoubleValues(dictIds, numValues, doubleValues);
                this._doubleValuesMV[i] = doubleValues;
            }
        } else {
            switch (this.getResultMetadata().getDataType().getStoredType()) {
                case INT: {
                    int[][] intValuesMV = this.transformToIntValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        int[] intValues = intValuesMV[i];
                        int numValues = intValues.length;
                        double[] doubleValues = new double[numValues];
                        ArrayCopyUtils.copy((int[])intValues, (double[])doubleValues, (int)numValues);
                        this._doubleValuesMV[i] = doubleValues;
                    }
                    break;
                }
                case LONG: {
                    long[][] longValuesMV = this.transformToLongValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        long[] longValues = longValuesMV[i];
                        int numValues = longValues.length;
                        double[] doubleValues = new double[numValues];
                        ArrayCopyUtils.copy((long[])longValues, (double[])doubleValues, (int)numValues);
                        this._doubleValuesMV[i] = doubleValues;
                    }
                    break;
                }
                case FLOAT: {
                    float[][] floatValuesMV = this.transformToFloatValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        float[] floatValues = floatValuesMV[i];
                        int numValues = floatValues.length;
                        double[] doubleValues = new double[numValues];
                        ArrayCopyUtils.copy((float[])floatValues, (double[])doubleValues, (int)numValues);
                        this._doubleValuesMV[i] = doubleValues;
                    }
                    break;
                }
                case STRING: {
                    String[][] stringValuesMV = this.transformToStringValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        String[] stringValues = stringValuesMV[i];
                        int numValues = stringValues.length;
                        double[] doubleValues = new double[numValues];
                        ArrayCopyUtils.copy((String[])stringValues, (double[])doubleValues, (int)numValues);
                        this._doubleValuesMV[i] = doubleValues;
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return this._doubleValuesMV;
    }

    @Override
    public String[][] transformToStringValuesMV(ProjectionBlock projectionBlock) {
        if (this._stringValuesMV == null) {
            this._stringValuesMV = new String[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
        }
        int length = projectionBlock.getNumDocs();
        Dictionary dictionary = this.getDictionary();
        if (dictionary != null) {
            int[][] dictIdsMV = this.transformToDictIdsMV(projectionBlock);
            for (int i = 0; i < length; ++i) {
                int[] dictIds = dictIdsMV[i];
                int numValues = dictIds.length;
                String[] stringValues = new String[numValues];
                dictionary.readStringValues(dictIds, numValues, stringValues);
                this._stringValuesMV[i] = stringValues;
            }
        } else {
            switch (this.getResultMetadata().getDataType().getStoredType()) {
                case INT: {
                    int[][] intValuesMV = this.transformToIntValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        int[] intValues = intValuesMV[i];
                        int numValues = intValues.length;
                        String[] stringValues = new String[numValues];
                        ArrayCopyUtils.copy((int[])intValues, (String[])stringValues, (int)numValues);
                        this._stringValuesMV[i] = stringValues;
                    }
                    break;
                }
                case LONG: {
                    long[][] longValuesMV = this.transformToLongValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        long[] longValues = longValuesMV[i];
                        int numValues = longValues.length;
                        String[] stringValues = new String[numValues];
                        ArrayCopyUtils.copy((long[])longValues, (String[])stringValues, (int)numValues);
                        this._stringValuesMV[i] = stringValues;
                    }
                    break;
                }
                case FLOAT: {
                    float[][] floatValuesMV = this.transformToFloatValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        float[] floatValues = floatValuesMV[i];
                        int numValues = floatValues.length;
                        String[] stringValues = new String[numValues];
                        ArrayCopyUtils.copy((float[])floatValues, (String[])stringValues, (int)numValues);
                        this._stringValuesMV[i] = stringValues;
                    }
                    break;
                }
                case DOUBLE: {
                    double[][] doubleValuesMV = this.transformToDoubleValuesMV(projectionBlock);
                    for (int i = 0; i < length; ++i) {
                        double[] doubleValues = doubleValuesMV[i];
                        int numValues = doubleValues.length;
                        String[] stringValues = new String[numValues];
                        ArrayCopyUtils.copy((double[])doubleValues, (String[])stringValues, (int)numValues);
                        this._stringValuesMV[i] = stringValues;
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return this._stringValuesMV;
    }
}

