/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ByteArray;

public abstract class BinaryOperatorTransformFunction
extends BaseTransformFunction {
    protected TransformFunction _leftTransformFunction;
    protected TransformFunction _rightTransformFunction;
    protected FieldSpec.DataType _leftStoredType;
    protected FieldSpec.DataType _rightStoredType;
    protected int[] _results;

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        Preconditions.checkArgument((arguments.size() == 2 ? 1 : 0) != 0, (Object)"Exact 2 arguments are required for binary operator transform function");
        this._leftTransformFunction = arguments.get(0);
        this._rightTransformFunction = arguments.get(1);
        this._leftStoredType = this._leftTransformFunction.getResultMetadata().getDataType().getStoredType();
        this._rightStoredType = this._rightTransformFunction.getResultMetadata().getDataType().getStoredType();
        if (this._leftStoredType == FieldSpec.DataType.BYTES || this._rightStoredType == FieldSpec.DataType.BYTES) {
            Preconditions.checkState((this._leftStoredType == this._rightStoredType ? 1 : 0) != 0, (Object)String.format("Unsupported data type for comparison: [Left Transform Function [%s] result type is [%s], Right Transform Function [%s] result type is [%s]]", this._leftTransformFunction.getName(), this._leftStoredType, this._rightTransformFunction.getName(), this._rightStoredType));
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return BOOLEAN_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        this.fillResultArray(projectionBlock);
        return this._results;
    }

    private void fillResultArray(ProjectionBlock projectionBlock) {
        if (this._results == null) {
            this._results = new int[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        int length = projectionBlock.getNumDocs();
        block8 : switch (this._leftStoredType) {
            case INT: {
                int[] leftIntValues = this._leftTransformFunction.transformToIntValuesSV(projectionBlock);
                switch (this._rightStoredType) {
                    case INT: {
                        int[] rightIntValues = this._rightTransformFunction.transformToIntValuesSV(projectionBlock);
                        for (int i = 0; i < length; ++i) {
                            this._results[i] = this.getIntResult(Integer.compare(leftIntValues[i], rightIntValues[i]));
                        }
                        break block8;
                    }
                    case LONG: {
                        long[] rightLongValues = this._rightTransformFunction.transformToLongValuesSV(projectionBlock);
                        for (int i = 0; i < length; ++i) {
                            this._results[i] = this.getIntResult(Long.compare(leftIntValues[i], rightLongValues[i]));
                        }
                        break block8;
                    }
                    case FLOAT: {
                        float[] rightFloatValues = this._rightTransformFunction.transformToFloatValuesSV(projectionBlock);
                        for (int i = 0; i < length; ++i) {
                            this._results[i] = this.getIntResult(Float.compare(leftIntValues[i], rightFloatValues[i]));
                        }
                        break block8;
                    }
                    case DOUBLE: {
                        double[] rightDoubleValues = this._rightTransformFunction.transformToDoubleValuesSV(projectionBlock);
                        for (int i = 0; i < length; ++i) {
                            this._results[i] = this.getIntResult(Double.compare(leftIntValues[i], rightDoubleValues[i]));
                        }
                        break block8;
                    }
                    case STRING: {
                        String[] rightStringValues = this._rightTransformFunction.transformToStringValuesSV(projectionBlock);
                        for (int i = 0; i < length; ++i) {
                            try {
                                this._results[i] = this.getIntResult(BigDecimal.valueOf(leftIntValues[i]).compareTo(new BigDecimal(rightStringValues[i])));
                                continue;
                            }
                            catch (NumberFormatException e) {
                                this._results[i] = 0;
                            }
                        }
                        break block8;
                    }
                    default: {
                        throw new IllegalStateException(String.format("Unsupported data type for comparison: [Left Transform Function [%s] result type is [%s], Right Transform Function [%s] result type is [%s]]", this._leftTransformFunction.getName(), this._leftStoredType, this._rightTransformFunction.getName(), this._rightStoredType));
                    }
                }
            }
            case LONG: {
                long[] leftLongValues = this._leftTransformFunction.transformToLongValuesSV(projectionBlock);
                switch (this._rightStoredType) {
                    case INT: {
                        int[] rightIntValues = this._rightTransformFunction.transformToIntValuesSV(projectionBlock);
                        for (int i = 0; i < length; ++i) {
                            this._results[i] = this.getIntResult(Long.compare(leftLongValues[i], rightIntValues[i]));
                        }
                        break block8;
                    }
                    case LONG: {
                        long[] rightLongValues = this._rightTransformFunction.transformToLongValuesSV(projectionBlock);
                        for (int i = 0; i < length; ++i) {
                            this._results[i] = this.getIntResult(Long.compare(leftLongValues[i], rightLongValues[i]));
                        }
                        break block8;
                    }
                    case FLOAT: {
                        float[] rightFloatValues = this._rightTransformFunction.transformToFloatValuesSV(projectionBlock);
                        for (int i = 0; i < length; ++i) {
                            this._results[i] = this.getIntResult(BigDecimal.valueOf(leftLongValues[i]).compareTo(BigDecimal.valueOf(rightFloatValues[i])));
                        }
                        break block8;
                    }
                    case DOUBLE: {
                        double[] rightDoubleValues = this._rightTransformFunction.transformToDoubleValuesSV(projectionBlock);
                        for (int i = 0; i < length; ++i) {
                            this._results[i] = this.getIntResult(BigDecimal.valueOf(leftLongValues[i]).compareTo(BigDecimal.valueOf(rightDoubleValues[i])));
                        }
                        break block8;
                    }
                    case STRING: {
                        String[] rightStringValues = this._rightTransformFunction.transformToStringValuesSV(projectionBlock);
                        for (int i = 0; i < length; ++i) {
                            try {
                                this._results[i] = this.getIntResult(BigDecimal.valueOf(leftLongValues[i]).compareTo(new BigDecimal(rightStringValues[i])));
                                continue;
                            }
                            catch (NumberFormatException e) {
                                this._results[i] = 0;
                            }
                        }
                        break block8;
                    }
                    default: {
                        throw new IllegalStateException(String.format("Unsupported data type for comparison: [Left Transform Function [%s] result type is [%s], Right Transform Function [%s] result type is [%s]]", this._leftTransformFunction.getName(), this._leftStoredType, this._rightTransformFunction.getName(), this._rightStoredType));
                    }
                }
            }
            case FLOAT: {
                float[] leftFloatValues = this._leftTransformFunction.transformToFloatValuesSV(projectionBlock);
                switch (this._rightStoredType) {
                    case INT: {
                        int[] rightIntValues = this._rightTransformFunction.transformToIntValuesSV(projectionBlock);
                        for (int i = 0; i < length; ++i) {
                            this._results[i] = this.getIntResult(Double.compare(leftFloatValues[i], rightIntValues[i]));
                        }
                        break block8;
                    }
                    case LONG: {
                        long[] rightLongValues = this._rightTransformFunction.transformToLongValuesSV(projectionBlock);
                        for (int i = 0; i < length; ++i) {
                            this._results[i] = this.getIntResult(BigDecimal.valueOf(leftFloatValues[i]).compareTo(BigDecimal.valueOf(rightLongValues[i])));
                        }
                        break block8;
                    }
                    case FLOAT: {
                        float[] rightFloatValues = this._rightTransformFunction.transformToFloatValuesSV(projectionBlock);
                        for (int i = 0; i < length; ++i) {
                            this._results[i] = this.getIntResult(Float.compare(leftFloatValues[i], rightFloatValues[i]));
                        }
                        break block8;
                    }
                    case DOUBLE: {
                        double[] rightDoubleValues = this._rightTransformFunction.transformToDoubleValuesSV(projectionBlock);
                        for (int i = 0; i < length; ++i) {
                            this._results[i] = this.getIntResult(Double.compare(leftFloatValues[i], rightDoubleValues[i]));
                        }
                        break block8;
                    }
                    case STRING: {
                        String[] rightStringValues = this._rightTransformFunction.transformToStringValuesSV(projectionBlock);
                        for (int i = 0; i < length; ++i) {
                            try {
                                this._results[i] = this.getIntResult(BigDecimal.valueOf(leftFloatValues[i]).compareTo(new BigDecimal(rightStringValues[i])));
                                continue;
                            }
                            catch (NumberFormatException e) {
                                this._results[i] = 0;
                            }
                        }
                        break block8;
                    }
                    default: {
                        throw new IllegalStateException(String.format("Unsupported data type for comparison: [Left Transform Function [%s] result type is [%s], Right Transform Function [%s] result type is [%s]]", this._leftTransformFunction.getName(), this._leftStoredType, this._rightTransformFunction.getName(), this._rightStoredType));
                    }
                }
            }
            case DOUBLE: {
                double[] leftDoubleValues = this._leftTransformFunction.transformToDoubleValuesSV(projectionBlock);
                switch (this._rightStoredType) {
                    case INT: {
                        int[] rightIntValues = this._rightTransformFunction.transformToIntValuesSV(projectionBlock);
                        for (int i = 0; i < length; ++i) {
                            this._results[i] = this.getIntResult(Double.compare(leftDoubleValues[i], rightIntValues[i]));
                        }
                        break block8;
                    }
                    case LONG: {
                        long[] rightLongValues = this._rightTransformFunction.transformToLongValuesSV(projectionBlock);
                        for (int i = 0; i < length; ++i) {
                            this._results[i] = this.getIntResult(BigDecimal.valueOf(leftDoubleValues[i]).compareTo(BigDecimal.valueOf(rightLongValues[i])));
                        }
                        break block8;
                    }
                    case FLOAT: {
                        float[] rightFloatValues = this._rightTransformFunction.transformToFloatValuesSV(projectionBlock);
                        for (int i = 0; i < length; ++i) {
                            this._results[i] = this.getIntResult(Double.compare(leftDoubleValues[i], rightFloatValues[i]));
                        }
                        break block8;
                    }
                    case DOUBLE: {
                        double[] rightDoubleValues = this._rightTransformFunction.transformToDoubleValuesSV(projectionBlock);
                        for (int i = 0; i < length; ++i) {
                            this._results[i] = this.getIntResult(Double.compare(leftDoubleValues[i], rightDoubleValues[i]));
                        }
                        break block8;
                    }
                    case STRING: {
                        String[] rightStringValues = this._rightTransformFunction.transformToStringValuesSV(projectionBlock);
                        for (int i = 0; i < length; ++i) {
                            try {
                                this._results[i] = this.getIntResult(BigDecimal.valueOf(leftDoubleValues[i]).compareTo(new BigDecimal(rightStringValues[i])));
                                continue;
                            }
                            catch (NumberFormatException e) {
                                this._results[i] = 0;
                            }
                        }
                        break block8;
                    }
                    default: {
                        throw new IllegalStateException(String.format("Unsupported data type for comparison: [Left Transform Function [%s] result type is [%s], Right Transform Function [%s] result type is [%s]]", this._leftTransformFunction.getName(), this._leftStoredType, this._rightTransformFunction.getName(), this._rightStoredType));
                    }
                }
            }
            case STRING: {
                String[] leftStringValues = this._leftTransformFunction.transformToStringValuesSV(projectionBlock);
                switch (this._rightStoredType) {
                    case INT: {
                        int[] rightIntValues = this._rightTransformFunction.transformToIntValuesSV(projectionBlock);
                        for (int i = 0; i < length; ++i) {
                            try {
                                this._results[i] = this.getIntResult(new BigDecimal(leftStringValues[i]).compareTo(BigDecimal.valueOf(rightIntValues[i])));
                                continue;
                            }
                            catch (NumberFormatException e) {
                                this._results[i] = 0;
                            }
                        }
                        break block8;
                    }
                    case LONG: {
                        long[] rightLongValues = this._rightTransformFunction.transformToLongValuesSV(projectionBlock);
                        for (int i = 0; i < length; ++i) {
                            try {
                                this._results[i] = this.getIntResult(new BigDecimal(leftStringValues[i]).compareTo(BigDecimal.valueOf(rightLongValues[i])));
                                continue;
                            }
                            catch (NumberFormatException e) {
                                this._results[i] = 0;
                            }
                        }
                        break block8;
                    }
                    case FLOAT: {
                        float[] rightFloatValues = this._rightTransformFunction.transformToFloatValuesSV(projectionBlock);
                        for (int i = 0; i < length; ++i) {
                            try {
                                this._results[i] = this.getIntResult(new BigDecimal(leftStringValues[i]).compareTo(BigDecimal.valueOf(rightFloatValues[i])));
                                continue;
                            }
                            catch (NumberFormatException e) {
                                this._results[i] = 0;
                            }
                        }
                        break block8;
                    }
                    case DOUBLE: {
                        double[] rightDoubleValues = this._rightTransformFunction.transformToDoubleValuesSV(projectionBlock);
                        for (int i = 0; i < length; ++i) {
                            try {
                                this._results[i] = this.getIntResult(new BigDecimal(leftStringValues[i]).compareTo(BigDecimal.valueOf(rightDoubleValues[i])));
                                continue;
                            }
                            catch (NumberFormatException e) {
                                this._results[i] = 0;
                            }
                        }
                        break block8;
                    }
                    case STRING: {
                        String[] rightStringValues = this._rightTransformFunction.transformToStringValuesSV(projectionBlock);
                        for (int i = 0; i < length; ++i) {
                            this._results[i] = this.getIntResult(leftStringValues[i].compareTo(rightStringValues[i]));
                        }
                        break block8;
                    }
                    default: {
                        throw new IllegalStateException(String.format("Unsupported data type for comparison: [Left Transform Function [%s] result type is [%s], Right Transform Function [%s] result type is [%s]]", this._leftTransformFunction.getName(), this._leftStoredType, this._rightTransformFunction.getName(), this._rightStoredType));
                    }
                }
            }
            case BYTES: {
                byte[][] leftBytesValues = this._leftTransformFunction.transformToBytesValuesSV(projectionBlock);
                byte[][] rightBytesValues = this._rightTransformFunction.transformToBytesValuesSV(projectionBlock);
                for (int i = 0; i < length; ++i) {
                    this._results[i] = this.getIntResult(new ByteArray(leftBytesValues[i]).compareTo(new ByteArray(rightBytesValues[i])));
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private int getIntResult(int comparisonResult) {
        return this.getBinaryFuncResult(comparisonResult) ? 1 : 0;
    }

    protected abstract boolean getBinaryFuncResult(int var1);
}

