/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.spi.data.FieldSpec;

public class CaseTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "case";
    private List<TransformFunction> _whenStatements = new ArrayList<TransformFunction>();
    private List<TransformFunction> _elseThenStatements = new ArrayList<TransformFunction>();
    private TransformResultMetadata _resultMetadata;
    private int[] _selectedResults;
    private int[] _intResults;
    private long[] _longResults;
    private float[] _floatResults;
    private double[] _doubleResults;
    private String[] _stringResults;
    private byte[][] _bytesResults;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        int i;
        if (arguments.size() % 2 != 1 || arguments.size() < 3) {
            throw new IllegalArgumentException("At least 3 odd number of arguments are required for CASE-WHEN-ELSE function");
        }
        int numWhenStatements = arguments.size() / 2;
        this._whenStatements = new ArrayList<TransformFunction>(numWhenStatements);
        for (i = 0; i < numWhenStatements; ++i) {
            this._whenStatements.add(arguments.get(i));
        }
        this._elseThenStatements = new ArrayList<TransformFunction>(numWhenStatements + 1);
        this._elseThenStatements.add(arguments.get(numWhenStatements * 2));
        for (i = numWhenStatements; i < numWhenStatements * 2; ++i) {
            this._elseThenStatements.add(arguments.get(i));
        }
        this._resultMetadata = this.calculateResultMetadata();
    }

    private TransformResultMetadata calculateResultMetadata() {
        TransformFunction elseStatement = this._elseThenStatements.get(0);
        TransformResultMetadata elseStatementResultMetadata = elseStatement.getResultMetadata();
        FieldSpec.DataType dataType = elseStatementResultMetadata.getDataType();
        Preconditions.checkState((boolean)elseStatementResultMetadata.isSingleValue(), (Object)"Unsupported multi-value expression in the ELSE clause");
        int numThenStatements = this._elseThenStatements.size() - 1;
        block38: for (int i = 0; i < numThenStatements; ++i) {
            TransformFunction thenStatement = this._elseThenStatements.get(i + 1);
            TransformResultMetadata thenStatementResultMetadata = thenStatement.getResultMetadata();
            Preconditions.checkState((boolean)thenStatementResultMetadata.isSingleValue(), (Object)String.format("Unsupported multi-value expression in the THEN clause of index: %d", i));
            FieldSpec.DataType thenStatementDataType = thenStatementResultMetadata.getDataType();
            switch (dataType) {
                case INT: {
                    if (thenStatement instanceof LiteralTransformFunction) {
                        dataType = LiteralTransformFunction.inferLiteralDataType((LiteralTransformFunction)thenStatement);
                        continue block38;
                    }
                    switch (thenStatementDataType) {
                        case INT: 
                        case LONG: 
                        case FLOAT: 
                        case DOUBLE: 
                        case STRING: {
                            dataType = thenStatementDataType;
                            continue block38;
                        }
                    }
                    throw new IllegalStateException(String.format("Incompatible expression type: %s in the THEN clause of index: %d, main type: %s", thenStatementDataType, i, dataType));
                }
                case LONG: {
                    FieldSpec.DataType literalDataType;
                    if (thenStatement instanceof LiteralTransformFunction) {
                        literalDataType = LiteralTransformFunction.inferLiteralDataType((LiteralTransformFunction)thenStatement);
                        switch (literalDataType) {
                            case INT: 
                            case LONG: {
                                continue block38;
                            }
                            case FLOAT: 
                            case DOUBLE: {
                                dataType = FieldSpec.DataType.DOUBLE;
                                continue block38;
                            }
                        }
                        dataType = literalDataType;
                        continue block38;
                    }
                    switch (thenStatementDataType) {
                        case INT: 
                        case LONG: {
                            continue block38;
                        }
                        case FLOAT: 
                        case DOUBLE: {
                            dataType = FieldSpec.DataType.DOUBLE;
                            continue block38;
                        }
                        case STRING: {
                            dataType = FieldSpec.DataType.STRING;
                            continue block38;
                        }
                    }
                    throw new IllegalStateException(String.format("Incompatible expression type: %s in the THEN clause of index: %d, main type: %s", thenStatementDataType, i, dataType));
                }
                case FLOAT: {
                    FieldSpec.DataType literalDataType;
                    if (thenStatement instanceof LiteralTransformFunction) {
                        literalDataType = LiteralTransformFunction.inferLiteralDataType((LiteralTransformFunction)thenStatement);
                        switch (literalDataType) {
                            case INT: 
                            case FLOAT: {
                                continue block38;
                            }
                            case LONG: 
                            case DOUBLE: {
                                dataType = FieldSpec.DataType.DOUBLE;
                                continue block38;
                            }
                        }
                        dataType = literalDataType;
                        continue block38;
                    }
                    switch (thenStatementDataType) {
                        case INT: 
                        case FLOAT: {
                            continue block38;
                        }
                        case LONG: 
                        case DOUBLE: {
                            dataType = FieldSpec.DataType.DOUBLE;
                            continue block38;
                        }
                        case STRING: {
                            dataType = FieldSpec.DataType.STRING;
                            continue block38;
                        }
                    }
                    throw new IllegalStateException(String.format("Incompatible expression type: %s in the THEN clause of index: %d, main type: %s", thenStatementDataType, i, dataType));
                }
                case DOUBLE: {
                    FieldSpec.DataType literalDataType;
                    if (thenStatement instanceof LiteralTransformFunction) {
                        literalDataType = LiteralTransformFunction.inferLiteralDataType((LiteralTransformFunction)thenStatement);
                        switch (literalDataType) {
                            case INT: 
                            case LONG: 
                            case FLOAT: 
                            case DOUBLE: {
                                continue block38;
                            }
                        }
                        dataType = literalDataType;
                        continue block38;
                    }
                    switch (thenStatementDataType) {
                        case INT: 
                        case LONG: 
                        case FLOAT: 
                        case DOUBLE: {
                            continue block38;
                        }
                        case STRING: {
                            dataType = thenStatementDataType;
                            continue block38;
                        }
                    }
                    throw new IllegalStateException(String.format("Incompatible expression type: %s in the THEN clause of index: %d, main type: %s", thenStatementDataType, i, dataType));
                }
                case STRING: {
                    if (thenStatement instanceof LiteralTransformFunction) continue block38;
                    switch (thenStatementDataType) {
                        case INT: 
                        case LONG: 
                        case FLOAT: 
                        case DOUBLE: 
                        case STRING: {
                            continue block38;
                        }
                    }
                    throw new IllegalStateException(String.format("Incompatible expression type: %s in the THEN clause of index: %d, main type: %s", thenStatementDataType, i, dataType));
                }
                default: {
                    if (thenStatementDataType == dataType) continue block38;
                    throw new IllegalStateException(String.format("Incompatible expression type: %s in the THEN clause of index: %d, main type: %s", thenStatementDataType, i, dataType));
                }
            }
        }
        return new TransformResultMetadata(dataType, true, false);
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    private int[] getSelectedArray(ProjectionBlock projectionBlock) {
        if (this._selectedResults == null) {
            this._selectedResults = new int[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        } else {
            Arrays.fill(this._selectedResults, 0);
        }
        int numWhenStatements = this._whenStatements.size();
        for (int i = 0; i < numWhenStatements; ++i) {
            TransformFunction whenStatement = this._whenStatements.get(i);
            int[] conditions = whenStatement.transformToIntValuesSV(projectionBlock);
            for (int j = 0; j < conditions.length; ++j) {
                if (this._selectedResults[j] != 0 || conditions[j] != 1) continue;
                this._selectedResults[j] = i + 1;
            }
        }
        return this._selectedResults;
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.INT) {
            return super.transformToIntValuesSV(projectionBlock);
        }
        int[] selected = this.getSelectedArray(projectionBlock);
        if (this._intResults == null) {
            this._intResults = new int[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        int numElseThenStatements = this._elseThenStatements.size();
        for (int i = 0; i < numElseThenStatements; ++i) {
            TransformFunction transformFunction = this._elseThenStatements.get(i);
            int[] intValues = transformFunction.transformToIntValuesSV(projectionBlock);
            int numDocs = projectionBlock.getNumDocs();
            for (int j = 0; j < numDocs; ++j) {
                if (selected[j] != i) continue;
                this._intResults[j] = intValues[j];
            }
        }
        return this._intResults;
    }

    @Override
    public long[] transformToLongValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.LONG) {
            return super.transformToLongValuesSV(projectionBlock);
        }
        int[] selected = this.getSelectedArray(projectionBlock);
        if (this._longResults == null) {
            this._longResults = new long[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        int numElseThenStatements = this._elseThenStatements.size();
        for (int i = 0; i < numElseThenStatements; ++i) {
            TransformFunction transformFunction = this._elseThenStatements.get(i);
            long[] longValues = transformFunction.transformToLongValuesSV(projectionBlock);
            int numDocs = projectionBlock.getNumDocs();
            for (int j = 0; j < numDocs; ++j) {
                if (selected[j] != i) continue;
                this._longResults[j] = longValues[j];
            }
        }
        return this._longResults;
    }

    @Override
    public float[] transformToFloatValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.FLOAT) {
            return super.transformToFloatValuesSV(projectionBlock);
        }
        int[] selected = this.getSelectedArray(projectionBlock);
        if (this._floatResults == null) {
            this._floatResults = new float[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        int numElseThenStatements = this._elseThenStatements.size();
        for (int i = 0; i < numElseThenStatements; ++i) {
            TransformFunction transformFunction = this._elseThenStatements.get(i);
            float[] floatValues = transformFunction.transformToFloatValuesSV(projectionBlock);
            int numDocs = projectionBlock.getNumDocs();
            for (int j = 0; j < numDocs; ++j) {
                if (selected[j] != i) continue;
                this._floatResults[j] = floatValues[j];
            }
        }
        return this._floatResults;
    }

    @Override
    public double[] transformToDoubleValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.DOUBLE) {
            return super.transformToDoubleValuesSV(projectionBlock);
        }
        int[] selected = this.getSelectedArray(projectionBlock);
        if (this._doubleResults == null) {
            this._doubleResults = new double[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        int numElseThenStatements = this._elseThenStatements.size();
        for (int i = 0; i < numElseThenStatements; ++i) {
            TransformFunction transformFunction = this._elseThenStatements.get(i);
            double[] doubleValues = transformFunction.transformToDoubleValuesSV(projectionBlock);
            int numDocs = projectionBlock.getNumDocs();
            for (int j = 0; j < numDocs; ++j) {
                if (selected[j] != i) continue;
                this._doubleResults[j] = doubleValues[j];
            }
        }
        return this._doubleResults;
    }

    @Override
    public String[] transformToStringValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.STRING) {
            return super.transformToStringValuesSV(projectionBlock);
        }
        int[] selected = this.getSelectedArray(projectionBlock);
        if (this._stringResults == null) {
            this._stringResults = new String[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        int numElseThenStatements = this._elseThenStatements.size();
        for (int i = 0; i < numElseThenStatements; ++i) {
            TransformFunction transformFunction = this._elseThenStatements.get(i);
            String[] stringValues = transformFunction.transformToStringValuesSV(projectionBlock);
            int numDocs = projectionBlock.getNumDocs();
            for (int j = 0; j < numDocs; ++j) {
                if (selected[j] != i) continue;
                this._stringResults[j] = stringValues[j];
            }
        }
        return this._stringResults;
    }

    @Override
    public byte[][] transformToBytesValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.BYTES) {
            return super.transformToBytesValuesSV(projectionBlock);
        }
        int[] selected = this.getSelectedArray(projectionBlock);
        if (this._bytesResults == null) {
            this._bytesResults = new byte[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
        }
        int numElseThenStatements = this._elseThenStatements.size();
        for (int i = 0; i < numElseThenStatements; ++i) {
            TransformFunction transformFunction = this._elseThenStatements.get(i);
            byte[][] bytesValues = transformFunction.transformToBytesValuesSV(projectionBlock);
            int numDocs = projectionBlock.getNumDocs();
            for (int j = 0; j < numDocs; ++j) {
                if (selected[j] != i) continue;
                this._bytesResults[j] = bytesValues[j];
            }
        }
        return this._bytesResults;
    }
}

