/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.common.function.DateTimeUtils;
import org.apache.pinot.common.function.TimeZoneKey;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.joda.time.DateTimeField;
import org.joda.time.chrono.ISOChronology;

public class DateTruncTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "dateTrunc";
    public static final String EXAMPLE_INVOCATION = String.format("%s('week', time_expression, 'seconds', <TZ>, <Output-Granularity>)", "dateTrunc");
    private static final String UTC_TZ = TimeZoneKey.UTC_KEY.getId();
    private TransformFunction _mainTransformFunction;
    private TransformResultMetadata _resultMetadata;
    private long[] _longOutputTimes;
    private DateTimeField _field;
    private TimeUnit _inputTimeUnit;
    private TimeUnit _outputTimeUnit;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        Preconditions.checkArgument((arguments.size() >= 2 && arguments.size() <= 5 ? 1 : 0) != 0, (String)"Between two to five arguments are required, example: %s", (Object)EXAMPLE_INVOCATION);
        String unit = ((LiteralTransformFunction)arguments.get(0)).getLiteral().toLowerCase();
        TransformFunction valueArgument = arguments.get(1);
        Preconditions.checkArgument((!(valueArgument instanceof LiteralTransformFunction) && valueArgument.getResultMetadata().isSingleValue() ? 1 : 0) != 0, (Object)"The second argument of dateTrunc transform function must be a single-valued column or a transform function");
        this._mainTransformFunction = valueArgument;
        String inputTimeUnitStr = arguments.size() >= 3 ? ((LiteralTransformFunction)arguments.get(2)).getLiteral().toUpperCase() : TimeUnit.MILLISECONDS.name();
        this._inputTimeUnit = TimeUnit.valueOf(inputTimeUnitStr);
        String timeZone = arguments.size() >= 4 ? ((LiteralTransformFunction)arguments.get(3)).getLiteral() : UTC_TZ;
        String outputTimeUnitStr = arguments.size() >= 5 ? ((LiteralTransformFunction)arguments.get(4)).getLiteral().toUpperCase() : inputTimeUnitStr;
        TimeZoneKey timeZoneKey = TimeZoneKey.getTimeZoneKey((String)timeZone);
        this._field = DateTimeUtils.getTimestampField((ISOChronology)DateTimeUtils.getChronology((TimeZoneKey)timeZoneKey), (String)unit);
        this._resultMetadata = LONG_SV_NO_DICTIONARY_METADATA;
        this._outputTimeUnit = TimeUnit.valueOf(outputTimeUnitStr);
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    @Override
    public long[] transformToLongValuesSV(ProjectionBlock projectionBlock) {
        if (this._longOutputTimes == null) {
            this._longOutputTimes = new long[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        int length = projectionBlock.getNumDocs();
        long[] input = this._mainTransformFunction.transformToLongValuesSV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            this._longOutputTimes[i] = this._outputTimeUnit.convert(this._field.roundFloor(TimeUnit.MILLISECONDS.convert(input[i], this._inputTimeUnit)), TimeUnit.MILLISECONDS);
        }
        return this._longOutputTimes;
    }
}

