/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.function.TransformFunctionType;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.core.query.utils.idset.IdSet;
import org.apache.pinot.core.query.utils.idset.IdSets;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.spi.data.FieldSpec;

public class InIdSetTransformFunction
extends BaseTransformFunction {
    private TransformFunction _transformFunction;
    private IdSet _idSet;
    private int[] _results;

    @Override
    public String getName() {
        return TransformFunctionType.INIDSET.getName();
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        Preconditions.checkArgument((arguments.size() == 2 ? 1 : 0) != 0, (Object)"2 arguments are required for IN_ID_SET transform function: expression, base64 encoded IdSet");
        Preconditions.checkArgument((boolean)arguments.get(0).getResultMetadata().isSingleValue(), (Object)"First argument for IN_ID_SET transform function must be a single-value expression");
        Preconditions.checkArgument((boolean)(arguments.get(1) instanceof LiteralTransformFunction), (Object)"Second argument for IN_ID_SET transform function must be a literal string of the base64 encoded IdSet");
        this._transformFunction = arguments.get(0);
        try {
            this._idSet = IdSets.fromBase64String(((LiteralTransformFunction)arguments.get(1)).getLiteral());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Caught exception while deserializing IdSet", e);
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return BOOLEAN_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        if (this._results == null) {
            this._results = new int[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        int length = projectionBlock.getNumDocs();
        FieldSpec.DataType storedType = this._transformFunction.getResultMetadata().getDataType().getStoredType();
        switch (storedType) {
            case INT: {
                int[] intValues = this._transformFunction.transformToIntValuesSV(projectionBlock);
                for (int i = 0; i < length; ++i) {
                    this._results[i] = this._idSet.contains(intValues[i]) ? 1 : 0;
                }
                break;
            }
            case LONG: {
                long[] longValues = this._transformFunction.transformToLongValuesSV(projectionBlock);
                for (int i = 0; i < length; ++i) {
                    this._results[i] = this._idSet.contains(longValues[i]) ? 1 : 0;
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = this._transformFunction.transformToFloatValuesSV(projectionBlock);
                for (int i = 0; i < length; ++i) {
                    this._results[i] = this._idSet.contains(floatValues[i]) ? 1 : 0;
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = this._transformFunction.transformToDoubleValuesSV(projectionBlock);
                for (int i = 0; i < length; ++i) {
                    this._results[i] = this._idSet.contains(doubleValues[i]) ? 1 : 0;
                }
                break;
            }
            case STRING: {
                String[] stringValues = this._transformFunction.transformToStringValuesSV(projectionBlock);
                for (int i = 0; i < length; ++i) {
                    this._results[i] = this._idSet.contains(stringValues[i]) ? 1 : 0;
                }
                break;
            }
            case BYTES: {
                byte[][] bytesValues = this._transformFunction.transformToBytesValuesSV(projectionBlock);
                for (int i = 0; i < length; ++i) {
                    this._results[i] = this._idSet.contains(bytesValues[i]) ? 1 : 0;
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this._results;
    }
}

