/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.collect.ImmutableSet;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.datasource.DataSource;

public class JsonExtractKeyTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "jsonExtractKey";
    private static final Configuration JSON_PATH_KEY_CONFIG = Configuration.builder().options(new Option[]{Option.AS_PATH_LIST}).build();
    private TransformFunction _jsonFieldTransformFunction;
    private String _jsonPath;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(@Nonnull List<TransformFunction> arguments, @Nonnull Map<String, DataSource> dataSourceMap) {
        if (arguments.size() != 2) {
            throw new IllegalArgumentException("Exactly 2 arguments are required for transform function: jsonExtractKey(jsonFieldName, 'jsonPath')");
        }
        TransformFunction firstArgument = arguments.get(0);
        if (firstArgument instanceof LiteralTransformFunction || !firstArgument.getResultMetadata().isSingleValue()) {
            throw new IllegalArgumentException("The first argument of jsonExtractKey transform function must be a single-valued column or a transform function");
        }
        this._jsonFieldTransformFunction = firstArgument;
        this._jsonPath = ((LiteralTransformFunction)arguments.get(1)).getLiteral();
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return STRING_MV_NO_DICTIONARY_METADATA;
    }

    @Override
    public String[][] transformToStringValuesMV(@Nonnull ProjectionBlock projectionBlock) {
        String[] stringValuesMV = this._jsonFieldTransformFunction.transformToStringValuesSV(projectionBlock);
        String[][] results = new String[projectionBlock.getNumDocs()][];
        for (int i = 0; i < projectionBlock.getNumDocs(); ++i) {
            List stringVals = (List)JsonPath.using((Configuration)JSON_PATH_KEY_CONFIG).parse(stringValuesMV[i]).read(this._jsonPath, new Predicate[0]);
            results[i] = new String[stringVals.size()];
            for (int j = 0; j < stringVals.size(); ++j) {
                results[i][j] = (String)stringVals.get(j);
            }
        }
        return results;
    }

    static {
        Configuration.setDefaults((Configuration.Defaults)new Configuration.Defaults(){
            private final JsonProvider jsonProvider = new JacksonJsonProvider();
            private final MappingProvider mappingProvider = new JacksonMappingProvider();

            public JsonProvider jsonProvider() {
                return this.jsonProvider;
            }

            public MappingProvider mappingProvider() {
                return this.mappingProvider;
            }

            public Set<Option> options() {
                return ImmutableSet.of((Object)Option.SUPPRESS_EXCEPTIONS);
            }
        });
    }
}

