/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.collect.ImmutableSet;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.JsonUtils;

public class JsonExtractScalarTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "jsonExtractScalar";
    private static final ParseContext JSON_PARSER_CONTEXT = JsonPath.using((Configuration)Configuration.defaultConfiguration().addOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS}));
    private TransformFunction _jsonFieldTransformFunction;
    private String _jsonPath;
    private Object _defaultValue = null;
    private TransformResultMetadata _resultMetadata;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        if (arguments.size() < 3 || arguments.size() > 4) {
            throw new IllegalArgumentException("Expected 3/4 arguments for transform function: jsonExtractScalar(jsonFieldName, 'jsonPath', 'resultsType', ['defaultValue'])");
        }
        TransformFunction firstArgument = arguments.get(0);
        if (firstArgument instanceof LiteralTransformFunction || !firstArgument.getResultMetadata().isSingleValue()) {
            throw new IllegalArgumentException("The first argument of jsonExtractScalar transform function must be a single-valued column or a transform function");
        }
        this._jsonFieldTransformFunction = firstArgument;
        this._jsonPath = ((LiteralTransformFunction)arguments.get(1)).getLiteral();
        String resultsType = ((LiteralTransformFunction)arguments.get(2)).getLiteral().toUpperCase();
        boolean isSingleValue = !resultsType.endsWith("_ARRAY");
        try {
            FieldSpec.DataType dataType = FieldSpec.DataType.valueOf((String)(isSingleValue ? resultsType : resultsType.substring(0, resultsType.length() - 6)));
            if (arguments.size() == 4) {
                this._defaultValue = dataType.convert(((LiteralTransformFunction)arguments.get(3)).getLiteral());
            }
            this._resultMetadata = new TransformResultMetadata(dataType, isSingleValue, false);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Unsupported results type: %s for jsonExtractScalar function. Supported types are: INT/LONG/FLOAT/DOUBLE/BOOLEAN/TIMESTAMP/STRING/INT_ARRAY/LONG_ARRAY/FLOAT_ARRAY/DOUBLE_ARRAY/STRING_ARRAY", resultsType));
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        if (this._intValuesSV == null) {
            this._intValuesSV = new int[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        String[] jsonStrings = this._jsonFieldTransformFunction.transformToStringValuesSV(projectionBlock);
        int numDocs = projectionBlock.getNumDocs();
        for (int i = 0; i < numDocs; ++i) {
            Object result = null;
            try {
                result = JSON_PARSER_CONTEXT.parse(jsonStrings[i]).read(this._jsonPath, new Predicate[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                if (this._defaultValue != null) {
                    this._intValuesSV[i] = (Integer)this._defaultValue;
                    continue;
                }
                throw new RuntimeException(String.format("Illegal Json Path: [%s], when reading [%s]", this._jsonPath, jsonStrings[i]));
            }
            this._intValuesSV[i] = result instanceof Number ? ((Number)result).intValue() : Integer.parseInt(result.toString());
        }
        return this._intValuesSV;
    }

    @Override
    public long[] transformToLongValuesSV(ProjectionBlock projectionBlock) {
        if (this._longValuesSV == null) {
            this._longValuesSV = new long[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        String[] jsonStrings = this._jsonFieldTransformFunction.transformToStringValuesSV(projectionBlock);
        int numDocs = projectionBlock.getNumDocs();
        for (int i = 0; i < numDocs; ++i) {
            Object result = null;
            try {
                result = JSON_PARSER_CONTEXT.parse(jsonStrings[i]).read(this._jsonPath, new Predicate[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                if (this._defaultValue != null) {
                    this._longValuesSV[i] = (Long)this._defaultValue;
                    continue;
                }
                throw new RuntimeException(String.format("Illegal Json Path: [%s], when reading [%s]", this._jsonPath, jsonStrings[i]));
            }
            this._longValuesSV[i] = result instanceof Number ? ((Number)result).longValue() : (long)Double.parseDouble(result.toString());
        }
        return this._longValuesSV;
    }

    @Override
    public float[] transformToFloatValuesSV(ProjectionBlock projectionBlock) {
        if (this._floatValuesSV == null) {
            this._floatValuesSV = new float[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        String[] jsonStrings = this._jsonFieldTransformFunction.transformToStringValuesSV(projectionBlock);
        int numDocs = projectionBlock.getNumDocs();
        for (int i = 0; i < numDocs; ++i) {
            Object result = null;
            try {
                result = JSON_PARSER_CONTEXT.parse(jsonStrings[i]).read(this._jsonPath, new Predicate[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                if (this._defaultValue != null) {
                    this._floatValuesSV[i] = ((Float)this._defaultValue).floatValue();
                    continue;
                }
                throw new RuntimeException(String.format("Illegal Json Path: [%s], when reading [%s]", this._jsonPath, jsonStrings[i]));
            }
            this._floatValuesSV[i] = result instanceof Number ? ((Number)result).floatValue() : Float.parseFloat(result.toString());
        }
        return this._floatValuesSV;
    }

    @Override
    public double[] transformToDoubleValuesSV(ProjectionBlock projectionBlock) {
        if (this._doubleValuesSV == null) {
            this._doubleValuesSV = new double[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        String[] jsonStrings = this._jsonFieldTransformFunction.transformToStringValuesSV(projectionBlock);
        int numDocs = projectionBlock.getNumDocs();
        for (int i = 0; i < numDocs; ++i) {
            Object result = null;
            try {
                result = JSON_PARSER_CONTEXT.parse(jsonStrings[i]).read(this._jsonPath, new Predicate[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                if (this._defaultValue != null) {
                    this._doubleValuesSV[i] = (Double)this._defaultValue;
                    continue;
                }
                throw new RuntimeException(String.format("Illegal Json Path: [%s], when reading [%s]", this._jsonPath, jsonStrings[i]));
            }
            this._doubleValuesSV[i] = result instanceof Number ? ((Number)result).doubleValue() : Double.parseDouble(result.toString());
        }
        return this._doubleValuesSV;
    }

    @Override
    public String[] transformToStringValuesSV(ProjectionBlock projectionBlock) {
        if (this._stringValuesSV == null) {
            this._stringValuesSV = new String[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        String[] jsonStrings = this._jsonFieldTransformFunction.transformToStringValuesSV(projectionBlock);
        int numDocs = projectionBlock.getNumDocs();
        for (int i = 0; i < numDocs; ++i) {
            Object result = null;
            try {
                result = JSON_PARSER_CONTEXT.parse(jsonStrings[i]).read(this._jsonPath, new Predicate[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                if (this._defaultValue != null) {
                    this._stringValuesSV[i] = (String)this._defaultValue;
                    continue;
                }
                throw new RuntimeException(String.format("Illegal Json Path: [%s], when reading [%s]", this._jsonPath, jsonStrings[i]));
            }
            this._stringValuesSV[i] = result instanceof String ? (String)result : JsonUtils.objectToJsonNode((Object)result).toString();
        }
        return this._stringValuesSV;
    }

    @Override
    public int[][] transformToIntValuesMV(ProjectionBlock projectionBlock) {
        if (this._intValuesMV == null) {
            this._intValuesMV = new int[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
        }
        String[] jsonStrings = this._jsonFieldTransformFunction.transformToStringValuesSV(projectionBlock);
        int numDocs = projectionBlock.getNumDocs();
        for (int i = 0; i < numDocs; ++i) {
            List result = null;
            try {
                result = (List)JSON_PARSER_CONTEXT.parse(jsonStrings[i]).read(this._jsonPath, new Predicate[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                this._intValuesMV[i] = new int[0];
                continue;
            }
            int numValues = result.size();
            int[] values = new int[numValues];
            for (int j = 0; j < numValues; ++j) {
                values[j] = (Integer)result.get(j);
            }
            this._intValuesMV[i] = values;
        }
        return this._intValuesMV;
    }

    @Override
    public long[][] transformToLongValuesMV(ProjectionBlock projectionBlock) {
        if (this._longValuesMV == null) {
            this._longValuesMV = new long[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
        }
        String[] jsonStrings = this._jsonFieldTransformFunction.transformToStringValuesSV(projectionBlock);
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            List result = null;
            try {
                result = (List)JSON_PARSER_CONTEXT.parse(jsonStrings[i]).read(this._jsonPath, new Predicate[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                this._longValuesMV[i] = new long[0];
                continue;
            }
            int numValues = result.size();
            long[] values = new long[numValues];
            for (int j = 0; j < numValues; ++j) {
                values[j] = (Long)result.get(j);
            }
            this._longValuesMV[i] = values;
        }
        return this._longValuesMV;
    }

    @Override
    public float[][] transformToFloatValuesMV(ProjectionBlock projectionBlock) {
        if (this._floatValuesMV == null) {
            this._floatValuesMV = new float[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
        }
        String[] jsonStrings = this._jsonFieldTransformFunction.transformToStringValuesSV(projectionBlock);
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            List result = null;
            try {
                result = (List)JSON_PARSER_CONTEXT.parse(jsonStrings[i]).read(this._jsonPath, new Predicate[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                this._floatValuesMV[i] = new float[0];
                continue;
            }
            int numValues = result.size();
            float[] values = new float[numValues];
            for (int j = 0; j < numValues; ++j) {
                values[j] = ((Float)result.get(j)).floatValue();
            }
            this._floatValuesMV[i] = values;
        }
        return this._floatValuesMV;
    }

    @Override
    public double[][] transformToDoubleValuesMV(ProjectionBlock projectionBlock) {
        if (this._doubleValuesMV == null) {
            this._doubleValuesMV = new double[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
        }
        String[] jsonStrings = this._jsonFieldTransformFunction.transformToStringValuesSV(projectionBlock);
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            List result = null;
            try {
                result = (List)JSON_PARSER_CONTEXT.parse(jsonStrings[i]).read(this._jsonPath, new Predicate[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                this._doubleValuesMV[i] = new double[0];
                continue;
            }
            int numValues = result.size();
            double[] values = new double[numValues];
            for (int j = 0; j < numValues; ++j) {
                values[j] = (Double)result.get(j);
            }
            this._doubleValuesMV[i] = values;
        }
        return this._doubleValuesMV;
    }

    @Override
    public String[][] transformToStringValuesMV(ProjectionBlock projectionBlock) {
        if (this._stringValuesMV == null) {
            this._stringValuesMV = new String[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
        }
        String[] jsonStrings = this._jsonFieldTransformFunction.transformToStringValuesSV(projectionBlock);
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            List result = null;
            try {
                result = (List)JSON_PARSER_CONTEXT.parse(jsonStrings[i]).read(this._jsonPath, new Predicate[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                this._stringValuesMV[i] = new String[0];
                continue;
            }
            int numValues = result.size();
            String[] values = new String[numValues];
            for (int j = 0; j < numValues; ++j) {
                values[j] = (String)result.get(j);
            }
            this._stringValuesMV[i] = values;
        }
        return this._stringValuesMV;
    }

    static {
        Configuration.setDefaults((Configuration.Defaults)new Configuration.Defaults(){
            private final JsonProvider jsonProvider = new JacksonJsonProvider();
            private final MappingProvider mappingProvider = new JacksonMappingProvider();

            public JsonProvider jsonProvider() {
                return this.jsonProvider;
            }

            public MappingProvider mappingProvider() {
                return this.mappingProvider;
            }

            public Set<Option> options() {
                return ImmutableSet.of((Object)Option.SUPPRESS_EXCEPTIONS);
            }
        });
    }
}

