/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BytesUtils;

public class LiteralTransformFunction
implements TransformFunction {
    private final String _literal;
    private int[] _intResult;
    private long[] _longResult;
    private float[] _floatResult;
    private double[] _doubleResult;
    private String[] _stringResult;
    private byte[][] _bytesResult;

    public LiteralTransformFunction(String literal) {
        this._literal = literal;
    }

    public static FieldSpec.DataType inferLiteralDataType(LiteralTransformFunction transformFunction) {
        String literal = transformFunction.getLiteral();
        try {
            Number literalNum = NumberUtils.createNumber((String)literal);
            if (literalNum instanceof Integer) {
                return FieldSpec.DataType.INT;
            }
            if (literalNum instanceof Long) {
                return FieldSpec.DataType.LONG;
            }
            if (literalNum instanceof Float) {
                return FieldSpec.DataType.FLOAT;
            }
            if (literalNum instanceof Double) {
                return FieldSpec.DataType.DOUBLE;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return FieldSpec.DataType.STRING;
    }

    public String getLiteral() {
        return this._literal;
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return BaseTransformFunction.STRING_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public Dictionary getDictionary() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] transformToDictIdsSV(ProjectionBlock projectionBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[][] transformToDictIdsMV(ProjectionBlock projectionBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        if (this._intResult == null) {
            this._intResult = new int[DocIdSetPlanNode.MAX_DOC_PER_CALL];
            Arrays.fill(this._intResult, Integer.parseInt(this._literal));
        }
        return this._intResult;
    }

    @Override
    public long[] transformToLongValuesSV(ProjectionBlock projectionBlock) {
        if (this._longResult == null) {
            this._longResult = new long[DocIdSetPlanNode.MAX_DOC_PER_CALL];
            Arrays.fill(this._longResult, new BigDecimal(this._literal).longValue());
        }
        return this._longResult;
    }

    @Override
    public float[] transformToFloatValuesSV(ProjectionBlock projectionBlock) {
        if (this._floatResult == null) {
            this._floatResult = new float[DocIdSetPlanNode.MAX_DOC_PER_CALL];
            Arrays.fill(this._floatResult, new BigDecimal(this._literal).floatValue());
        }
        return this._floatResult;
    }

    @Override
    public double[] transformToDoubleValuesSV(ProjectionBlock projectionBlock) {
        if (this._doubleResult == null) {
            this._doubleResult = new double[DocIdSetPlanNode.MAX_DOC_PER_CALL];
            Arrays.fill(this._doubleResult, new BigDecimal(this._literal).doubleValue());
        }
        return this._doubleResult;
    }

    @Override
    public String[] transformToStringValuesSV(ProjectionBlock projectionBlock) {
        if (this._stringResult == null) {
            this._stringResult = new String[DocIdSetPlanNode.MAX_DOC_PER_CALL];
            Arrays.fill(this._stringResult, this._literal);
        }
        return this._stringResult;
    }

    @Override
    public byte[][] transformToBytesValuesSV(ProjectionBlock projectionBlock) {
        if (this._bytesResult == null) {
            this._bytesResult = new byte[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
            Arrays.fill((Object[])this._bytesResult, BytesUtils.toBytes((String)this._literal));
        }
        return this._bytesResult;
    }

    @Override
    public int[][] transformToIntValuesMV(ProjectionBlock projectionBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long[][] transformToLongValuesMV(ProjectionBlock projectionBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float[][] transformToFloatValuesMV(ProjectionBlock projectionBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double[][] transformToDoubleValuesMV(ProjectionBlock projectionBlock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[][] transformToStringValuesMV(ProjectionBlock projectionBlock) {
        throw new UnsupportedOperationException();
    }
}

