/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.spi.utils.ArrayCopyUtils;

public abstract class LogicalOperatorTransformFunction
extends BaseTransformFunction {
    protected List<TransformFunction> _arguments;
    protected int[] _results;

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        this._arguments = arguments;
        int numArguments = arguments.size();
        Preconditions.checkState((numArguments > 1 ? 1 : 0) != 0, (Object)String.format("Expect more than 1 argument for logical operator [%s], args [%s].", this.getName(), Arrays.toString(arguments.toArray())));
        for (int i = 0; i < numArguments; ++i) {
            TransformResultMetadata argumentMetadata = arguments.get(i).getResultMetadata();
            Preconditions.checkState((argumentMetadata.isSingleValue() && argumentMetadata.getDataType().getStoredType().isNumeric() ? 1 : 0) != 0, (Object)String.format("Unsupported argument of index: %d, expecting single-valued boolean/number", i));
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return BOOLEAN_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        if (this._results == null) {
            this._results = new int[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        int numDocs = projectionBlock.getNumDocs();
        ArrayCopyUtils.copy((int[])this._arguments.get(0).transformToIntValuesSV(projectionBlock), (int[])this._results, (int)numDocs);
        int numArguments = this._arguments.size();
        for (int i = 1; i < numArguments; ++i) {
            TransformFunction transformFunction = this._arguments.get(i);
            int[] results = transformFunction.transformToIntValuesSV(projectionBlock);
            for (int j = 0; j < numDocs; ++j) {
                this._results[j] = this.getLogicalFuncResult(this._results[j], results[j]);
            }
        }
        return this._results;
    }

    abstract int getLogicalFuncResult(int var1, int var2);
}

