/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.pinot.core.data.manager.offline.DimensionTableDataManager;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.PrimaryKey;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;

public class LookupTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "lookUp";
    private String _dimTableName;
    private String _dimColumnName;
    private final List<String> _joinKeys = new ArrayList<String>();
    private final List<FieldSpec> _joinValueFieldSpecs = new ArrayList<FieldSpec>();
    private final List<TransformFunction> _joinValueFunctions = new ArrayList<TransformFunction>();
    private DimensionTableDataManager _dataManager;
    private FieldSpec _lookupColumnFieldSpec;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        Preconditions.checkArgument((arguments.size() >= 4 ? 1 : 0) != 0, (Object)"At least 4 arguments are required for LOOKUP transform function: LOOKUP(TableName, ColumnName, JoinKey, JoinValue [, JoinKey2, JoinValue2 ...])");
        Preconditions.checkArgument((arguments.size() % 2 == 0 ? 1 : 0) != 0, (Object)"Should have the same number of JoinKey and JoinValue arguments");
        TransformFunction dimTableNameFunction = arguments.get(0);
        Preconditions.checkArgument((boolean)(dimTableNameFunction instanceof LiteralTransformFunction), (Object)"First argument must be a literal(string) representing the dimension table name");
        this._dimTableName = TableNameBuilder.OFFLINE.tableNameWithType(((LiteralTransformFunction)dimTableNameFunction).getLiteral());
        TransformFunction dimColumnFunction = arguments.get(1);
        Preconditions.checkArgument((boolean)(dimColumnFunction instanceof LiteralTransformFunction), (Object)"Second argument must be a literal(string) representing the column name from dimension table to lookup");
        this._dimColumnName = ((LiteralTransformFunction)dimColumnFunction).getLiteral();
        List<TransformFunction> joinArguments = arguments.subList(2, arguments.size());
        int numJoinArguments = joinArguments.size();
        for (int i = 0; i < numJoinArguments / 2; ++i) {
            TransformFunction dimJoinKeyFunction = joinArguments.get(i * 2);
            Preconditions.checkArgument((boolean)(dimJoinKeyFunction instanceof LiteralTransformFunction), (Object)"JoinKey argument must be a literal(string) representing the primary key for the dimension table");
            this._joinKeys.add(((LiteralTransformFunction)dimJoinKeyFunction).getLiteral());
            TransformFunction factJoinValueFunction = joinArguments.get(i * 2 + 1);
            TransformResultMetadata factJoinValueFunctionResultMetadata = factJoinValueFunction.getResultMetadata();
            Preconditions.checkArgument((boolean)factJoinValueFunctionResultMetadata.isSingleValue(), (Object)"JoinValue argument must be a single value expression");
            this._joinValueFunctions.add(factJoinValueFunction);
        }
        this._dataManager = DimensionTableDataManager.getInstanceByTableName(this._dimTableName);
        Preconditions.checkArgument((this._dataManager != null ? 1 : 0) != 0, (String)"Dimension table does not exist: %s", (Object)this._dimTableName);
        this._lookupColumnFieldSpec = this._dataManager.getColumnFieldSpec(this._dimColumnName);
        Preconditions.checkArgument((this._lookupColumnFieldSpec != null ? 1 : 0) != 0, (String)"Column does not exist in dimension table: %s:%s", (Object)this._dimTableName, (Object)this._dimColumnName);
        for (String joinKey : this._joinKeys) {
            FieldSpec pkColumnSpec = this._dataManager.getColumnFieldSpec(joinKey);
            Preconditions.checkArgument((pkColumnSpec != null ? 1 : 0) != 0, (String)"Primary key column doesn't exist in dimension table: %s:%s", (Object)this._dimTableName, (Object)joinKey);
            this._joinValueFieldSpecs.add(pkColumnSpec);
        }
        List<String> tablePrimaryKeyColumns = this._dataManager.getPrimaryKeyColumns();
        Preconditions.checkArgument((boolean)this._joinKeys.equals(tablePrimaryKeyColumns), (String)"Provided join keys (%s) must be the same as table primary keys: %s", this._joinKeys, tablePrimaryKeyColumns);
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return new TransformResultMetadata(this._lookupColumnFieldSpec.getDataType(), this._lookupColumnFieldSpec.isSingleValueField(), false);
    }

    private Object[] lookup(ProjectionBlock projectionBlock) {
        int numPkColumns = this._joinKeys.size();
        int numDocuments = projectionBlock.getNumDocs();
        Object[][] pkColumns = new Object[numPkColumns][];
        block8: for (int c = 0; c < numPkColumns; ++c) {
            FieldSpec.DataType storedType = this._joinValueFieldSpecs.get(c).getDataType().getStoredType();
            TransformFunction tf = this._joinValueFunctions.get(c);
            switch (storedType) {
                case INT: {
                    pkColumns[c] = ArrayUtils.toObject((int[])tf.transformToIntValuesSV(projectionBlock));
                    continue block8;
                }
                case LONG: {
                    pkColumns[c] = ArrayUtils.toObject((long[])tf.transformToLongValuesSV(projectionBlock));
                    continue block8;
                }
                case FLOAT: {
                    pkColumns[c] = ArrayUtils.toObject((float[])tf.transformToFloatValuesSV(projectionBlock));
                    continue block8;
                }
                case DOUBLE: {
                    pkColumns[c] = ArrayUtils.toObject((double[])tf.transformToDoubleValuesSV(projectionBlock));
                    continue block8;
                }
                case STRING: {
                    pkColumns[c] = tf.transformToStringValuesSV(projectionBlock);
                    continue block8;
                }
                case BYTES: {
                    byte[][] primitiveValues = tf.transformToBytesValuesSV(projectionBlock);
                    pkColumns[c] = new ByteArray[numDocuments];
                    for (int i = 0; i < numDocuments; ++i) {
                        pkColumns[c][i] = new ByteArray(primitiveValues[i]);
                    }
                    continue block8;
                }
                default: {
                    throw new IllegalStateException("Unknown column type for primary key");
                }
            }
        }
        Object[] resultSet = new Object[numDocuments];
        Object[] pkValues = new Object[numPkColumns];
        for (int i = 0; i < numDocuments; ++i) {
            for (int c = 0; c < numPkColumns; ++c) {
                pkValues[c] = pkColumns[c][i];
            }
            GenericRow row = this._dataManager.lookupRowByPrimaryKey(new PrimaryKey(pkValues));
            if (row == null) continue;
            resultSet[i] = row.getValue(this._dimColumnName);
        }
        return resultSet;
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        Object[] lookupObjects = this.lookup(projectionBlock);
        int[] resultSet = new int[lookupObjects.length];
        Arrays.fill(resultSet, ((Number)this._lookupColumnFieldSpec.getDefaultNullValue()).intValue());
        for (int i = 0; i < lookupObjects.length; ++i) {
            if (lookupObjects[i] == null) continue;
            resultSet[i] = ((Number)lookupObjects[i]).intValue();
        }
        return resultSet;
    }

    @Override
    public long[] transformToLongValuesSV(ProjectionBlock projectionBlock) {
        Object[] lookupObjects = this.lookup(projectionBlock);
        long[] resultSet = new long[lookupObjects.length];
        Arrays.fill(resultSet, ((Number)this._lookupColumnFieldSpec.getDefaultNullValue()).longValue());
        for (int i = 0; i < lookupObjects.length; ++i) {
            if (lookupObjects[i] == null) continue;
            resultSet[i] = ((Number)lookupObjects[i]).longValue();
        }
        return resultSet;
    }

    @Override
    public float[] transformToFloatValuesSV(ProjectionBlock projectionBlock) {
        Object[] lookupObjects = this.lookup(projectionBlock);
        float[] resultSet = new float[lookupObjects.length];
        Arrays.fill(resultSet, ((Number)this._lookupColumnFieldSpec.getDefaultNullValue()).floatValue());
        for (int i = 0; i < lookupObjects.length; ++i) {
            if (lookupObjects[i] == null) continue;
            resultSet[i] = ((Number)lookupObjects[i]).floatValue();
        }
        return resultSet;
    }

    @Override
    public double[] transformToDoubleValuesSV(ProjectionBlock projectionBlock) {
        Object[] lookupObjects = this.lookup(projectionBlock);
        double[] resultSet = new double[lookupObjects.length];
        Arrays.fill(resultSet, ((Number)this._lookupColumnFieldSpec.getDefaultNullValue()).doubleValue());
        for (int i = 0; i < lookupObjects.length; ++i) {
            if (lookupObjects[i] == null) continue;
            resultSet[i] = ((Number)lookupObjects[i]).doubleValue();
        }
        return resultSet;
    }

    @Override
    public String[] transformToStringValuesSV(ProjectionBlock projectionBlock) {
        Object[] lookupObjects = this.lookup(projectionBlock);
        Object[] resultSet = new String[lookupObjects.length];
        Arrays.fill(resultSet, this._lookupColumnFieldSpec.getDefaultNullValueString());
        for (int i = 0; i < lookupObjects.length; ++i) {
            if (lookupObjects[i] == null) continue;
            resultSet[i] = lookupObjects[i].toString();
        }
        return resultSet;
    }

    @Override
    public byte[][] transformToBytesValuesSV(ProjectionBlock projectionBlock) {
        Object[] lookupObjects = this.lookup(projectionBlock);
        byte[][] resultSet = new byte[lookupObjects.length][0];
        for (int i = 0; i < lookupObjects.length; ++i) {
            if (lookupObjects[i] == null) continue;
            resultSet[i] = (byte[])lookupObjects[i];
        }
        return resultSet;
    }

    @Override
    public int[][] transformToIntValuesMV(ProjectionBlock projectionBlock) {
        Object[] lookupObjects = this.lookup(projectionBlock);
        int[][] resultSet = new int[lookupObjects.length][0];
        for (int i = 0; i < lookupObjects.length; ++i) {
            if (lookupObjects[i] == null) continue;
            resultSet[i] = (int[])lookupObjects[i];
        }
        return resultSet;
    }

    @Override
    public long[][] transformToLongValuesMV(ProjectionBlock projectionBlock) {
        Object[] lookupObjects = this.lookup(projectionBlock);
        long[][] resultSet = new long[lookupObjects.length][0];
        for (int i = 0; i < lookupObjects.length; ++i) {
            if (lookupObjects[i] == null) continue;
            resultSet[i] = (long[])lookupObjects[i];
        }
        return resultSet;
    }

    @Override
    public float[][] transformToFloatValuesMV(ProjectionBlock projectionBlock) {
        Object[] lookupObjects = this.lookup(projectionBlock);
        float[][] resultSet = new float[lookupObjects.length][0];
        for (int i = 0; i < lookupObjects.length; ++i) {
            if (lookupObjects[i] == null) continue;
            resultSet[i] = (float[])lookupObjects[i];
        }
        return resultSet;
    }

    @Override
    public double[][] transformToDoubleValuesMV(ProjectionBlock projectionBlock) {
        Object[] lookupObjects = this.lookup(projectionBlock);
        double[][] resultSet = new double[lookupObjects.length][0];
        for (int i = 0; i < lookupObjects.length; ++i) {
            if (lookupObjects[i] == null) continue;
            resultSet[i] = (double[])lookupObjects[i];
        }
        return resultSet;
    }

    @Override
    public String[][] transformToStringValuesMV(ProjectionBlock projectionBlock) {
        Object[] lookupObjects = this.lookup(projectionBlock);
        String[][] resultSet = new String[lookupObjects.length][0];
        for (int i = 0; i < lookupObjects.length; ++i) {
            if (lookupObjects[i] == null) continue;
            resultSet[i] = (String[])lookupObjects[i];
        }
        return resultSet;
    }
}

