/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.pinot.common.function.FunctionInfo;
import org.apache.pinot.common.function.FunctionInvoker;
import org.apache.pinot.common.function.FunctionUtils;
import org.apache.pinot.common.utils.PinotDataType;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.spi.data.FieldSpec;

public class ScalarTransformFunctionWrapper
extends BaseTransformFunction {
    private final String _name;
    private final FunctionInvoker _functionInvoker;
    private final PinotDataType _resultType;
    private final TransformResultMetadata _resultMetadata;
    private Object[] _arguments;
    private int _numNonLiteralArguments;
    private int[] _nonLiteralIndices;
    private TransformFunction[] _nonLiteralFunctions;
    private Object[][] _nonLiteralValues;
    private int[] _intResults;
    private float[] _floatResults;
    private double[] _doubleResults;
    private long[] _longResults;
    private String[] _stringResults;
    private byte[][] _bytesResults;
    private int[][] _intMVResults;
    private long[][] _longMVResults;
    private float[][] _floatMVResults;
    private double[][] _doubleMVResults;
    private String[][] _stringMVResults;

    public ScalarTransformFunctionWrapper(FunctionInfo functionInfo) {
        this._name = functionInfo.getMethod().getName();
        this._functionInvoker = new FunctionInvoker(functionInfo);
        Class[] parameterClasses = this._functionInvoker.getParameterClasses();
        PinotDataType[] parameterTypes = this._functionInvoker.getParameterTypes();
        int numParameters = parameterClasses.length;
        for (int i = 0; i < numParameters; ++i) {
            Preconditions.checkArgument((parameterTypes[i] != null ? 1 : 0) != 0, (String)"Unsupported parameter class: %s for method: %s", (Object)parameterClasses[i], (Object)functionInfo.getMethod());
        }
        Class resultClass = this._functionInvoker.getResultClass();
        PinotDataType resultType = FunctionUtils.getParameterType((Class)resultClass);
        if (resultType != null) {
            this._resultType = resultType;
            this._resultMetadata = new TransformResultMetadata(FunctionUtils.getDataType((Class)resultClass), this._resultType.isSingleValue(), false);
        } else {
            this._resultType = PinotDataType.STRING;
            this._resultMetadata = new TransformResultMetadata(FieldSpec.DataType.STRING, true, false);
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        PinotDataType[] parameterTypes;
        int numArguments = arguments.size();
        Preconditions.checkArgument((numArguments == (parameterTypes = this._functionInvoker.getParameterTypes()).length ? 1 : 0) != 0, (String)"Wrong number of arguments for method: %s, expected: %s, actual: %s", (Object)this._functionInvoker.getMethod(), (Object)parameterTypes.length, (Object)numArguments);
        this._arguments = new Object[numArguments];
        this._nonLiteralIndices = new int[numArguments];
        this._nonLiteralFunctions = new TransformFunction[numArguments];
        for (int i = 0; i < numArguments; ++i) {
            TransformFunction transformFunction = arguments.get(i);
            if (transformFunction instanceof LiteralTransformFunction) {
                String literal = ((LiteralTransformFunction)transformFunction).getLiteral();
                this._arguments[i] = parameterTypes[i].convert((Object)literal, PinotDataType.STRING);
                continue;
            }
            this._nonLiteralIndices[this._numNonLiteralArguments] = i;
            this._nonLiteralFunctions[this._numNonLiteralArguments] = transformFunction;
            ++this._numNonLiteralArguments;
        }
        this._nonLiteralValues = new Object[this._numNonLiteralArguments][];
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.INT) {
            return super.transformToIntValuesSV(projectionBlock);
        }
        if (this._intResults == null) {
            this._intResults = new int[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        this.getNonLiteralValues(projectionBlock);
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._arguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            this._intResults[i] = (Integer)this._resultType.toInternal(this._functionInvoker.invoke(this._arguments));
        }
        return this._intResults;
    }

    @Override
    public long[] transformToLongValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.LONG) {
            return super.transformToLongValuesSV(projectionBlock);
        }
        if (this._longResults == null) {
            this._longResults = new long[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        this.getNonLiteralValues(projectionBlock);
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._arguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            this._longResults[i] = (Long)this._resultType.toInternal(this._functionInvoker.invoke(this._arguments));
        }
        return this._longResults;
    }

    @Override
    public float[] transformToFloatValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.FLOAT) {
            return super.transformToFloatValuesSV(projectionBlock);
        }
        if (this._floatResults == null) {
            this._floatResults = new float[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        this.getNonLiteralValues(projectionBlock);
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._arguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            this._floatResults[i] = ((Float)this._resultType.toInternal(this._functionInvoker.invoke(this._arguments))).floatValue();
        }
        return this._floatResults;
    }

    @Override
    public double[] transformToDoubleValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.DOUBLE) {
            return super.transformToDoubleValuesSV(projectionBlock);
        }
        if (this._doubleResults == null) {
            this._doubleResults = new double[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        this.getNonLiteralValues(projectionBlock);
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._arguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            this._doubleResults[i] = (Double)this._resultType.toInternal(this._functionInvoker.invoke(this._arguments));
        }
        return this._doubleResults;
    }

    @Override
    public String[] transformToStringValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.STRING) {
            return super.transformToStringValuesSV(projectionBlock);
        }
        if (this._stringResults == null) {
            this._stringResults = new String[DocIdSetPlanNode.MAX_DOC_PER_CALL];
        }
        this.getNonLiteralValues(projectionBlock);
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._arguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            Object result = this._functionInvoker.invoke(this._arguments);
            this._stringResults[i] = this._resultType == PinotDataType.STRING ? result.toString() : (String)this._resultType.toInternal(result);
        }
        return this._stringResults;
    }

    @Override
    public byte[][] transformToBytesValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.BYTES) {
            return super.transformToBytesValuesSV(projectionBlock);
        }
        if (this._bytesResults == null) {
            this._bytesResults = new byte[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
        }
        this.getNonLiteralValues(projectionBlock);
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._arguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            this._bytesResults[i] = (byte[])this._resultType.toInternal(this._functionInvoker.invoke(this._arguments));
        }
        return this._bytesResults;
    }

    @Override
    public int[][] transformToIntValuesMV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.INT) {
            return super.transformToIntValuesMV(projectionBlock);
        }
        if (this._intMVResults == null) {
            this._intMVResults = new int[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
        }
        this.getNonLiteralValues(projectionBlock);
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._arguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            this._intMVResults[i] = (int[])this._resultType.toInternal(this._functionInvoker.invoke(this._arguments));
        }
        return this._intMVResults;
    }

    @Override
    public long[][] transformToLongValuesMV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.LONG) {
            return super.transformToLongValuesMV(projectionBlock);
        }
        if (this._longMVResults == null) {
            this._longMVResults = new long[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
        }
        this.getNonLiteralValues(projectionBlock);
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._arguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            this._longMVResults[i] = (long[])this._resultType.toInternal(this._functionInvoker.invoke(this._arguments));
        }
        return this._longMVResults;
    }

    @Override
    public float[][] transformToFloatValuesMV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.FLOAT) {
            return super.transformToFloatValuesMV(projectionBlock);
        }
        if (this._floatMVResults == null) {
            this._floatMVResults = new float[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
        }
        this.getNonLiteralValues(projectionBlock);
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._arguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            this._floatMVResults[i] = (float[])this._resultType.toInternal(this._functionInvoker.invoke(this._arguments));
        }
        return this._floatMVResults;
    }

    @Override
    public double[][] transformToDoubleValuesMV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.DOUBLE) {
            return super.transformToDoubleValuesMV(projectionBlock);
        }
        if (this._doubleMVResults == null) {
            this._doubleMVResults = new double[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
        }
        this.getNonLiteralValues(projectionBlock);
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._arguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            this._doubleMVResults[i] = (double[])this._resultType.toInternal(this._functionInvoker.invoke(this._arguments));
        }
        return this._doubleMVResults;
    }

    @Override
    public String[][] transformToStringValuesMV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() != FieldSpec.DataType.STRING) {
            return super.transformToStringValuesMV(projectionBlock);
        }
        if (this._stringMVResults == null) {
            this._stringMVResults = new String[DocIdSetPlanNode.MAX_DOC_PER_CALL][];
        }
        this.getNonLiteralValues(projectionBlock);
        int length = projectionBlock.getNumDocs();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < this._numNonLiteralArguments; ++j) {
                this._arguments[this._nonLiteralIndices[j]] = this._nonLiteralValues[j][i];
            }
            this._stringMVResults[i] = (String[])this._resultType.toInternal(this._functionInvoker.invoke(this._arguments));
        }
        return this._stringMVResults;
    }

    private void getNonLiteralValues(ProjectionBlock projectionBlock) {
        PinotDataType[] parameterTypes = this._functionInvoker.getParameterTypes();
        block15: for (int i = 0; i < this._numNonLiteralArguments; ++i) {
            PinotDataType parameterType = parameterTypes[this._nonLiteralIndices[i]];
            TransformFunction transformFunction = this._nonLiteralFunctions[i];
            switch (parameterType) {
                case INTEGER: {
                    this._nonLiteralValues[i] = ArrayUtils.toObject((int[])transformFunction.transformToIntValuesSV(projectionBlock));
                    continue block15;
                }
                case LONG: {
                    this._nonLiteralValues[i] = ArrayUtils.toObject((long[])transformFunction.transformToLongValuesSV(projectionBlock));
                    continue block15;
                }
                case FLOAT: {
                    this._nonLiteralValues[i] = ArrayUtils.toObject((float[])transformFunction.transformToFloatValuesSV(projectionBlock));
                    continue block15;
                }
                case DOUBLE: {
                    this._nonLiteralValues[i] = ArrayUtils.toObject((double[])transformFunction.transformToDoubleValuesSV(projectionBlock));
                    continue block15;
                }
                case BOOLEAN: {
                    int j;
                    int[] intValues = transformFunction.transformToIntValuesSV(projectionBlock);
                    int numValues = intValues.length;
                    Boolean[] booleanValues = new Boolean[numValues];
                    for (j = 0; j < numValues; ++j) {
                        booleanValues[j] = intValues[j] == 1;
                    }
                    this._nonLiteralValues[i] = booleanValues;
                    continue block15;
                }
                case TIMESTAMP: {
                    int j;
                    long[] longValues = transformFunction.transformToLongValuesSV(projectionBlock);
                    int numValues = longValues.length;
                    Timestamp[] timestampValues = new Timestamp[numValues];
                    for (j = 0; j < numValues; ++j) {
                        timestampValues[j] = new Timestamp(longValues[j]);
                    }
                    this._nonLiteralValues[i] = timestampValues;
                    continue block15;
                }
                case STRING: {
                    this._nonLiteralValues[i] = transformFunction.transformToStringValuesSV(projectionBlock);
                    continue block15;
                }
                case BYTES: {
                    this._nonLiteralValues[i] = (Object[])transformFunction.transformToBytesValuesSV(projectionBlock);
                    continue block15;
                }
                case PRIMITIVE_INT_ARRAY: {
                    this._nonLiteralValues[i] = (Object[])transformFunction.transformToIntValuesMV(projectionBlock);
                    continue block15;
                }
                case PRIMITIVE_LONG_ARRAY: {
                    this._nonLiteralValues[i] = (Object[])transformFunction.transformToLongValuesMV(projectionBlock);
                    continue block15;
                }
                case PRIMITIVE_FLOAT_ARRAY: {
                    this._nonLiteralValues[i] = (Object[])transformFunction.transformToFloatValuesMV(projectionBlock);
                    continue block15;
                }
                case PRIMITIVE_DOUBLE_ARRAY: {
                    this._nonLiteralValues[i] = (Object[])transformFunction.transformToDoubleValuesMV(projectionBlock);
                    continue block15;
                }
                case STRING_ARRAY: {
                    this._nonLiteralValues[i] = transformFunction.transformToStringValuesMV(projectionBlock);
                    continue block15;
                }
                default: {
                    throw new IllegalStateException("Unsupported parameter type: " + parameterType);
                }
            }
        }
    }
}

