/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.transformer.datetime;

import org.apache.pinot.core.operator.transform.transformer.datetime.BaseDateTimeTransformer;
import org.apache.pinot.core.operator.transform.transformer.datetime.EpochToEpochTransformer;
import org.apache.pinot.core.operator.transform.transformer.datetime.EpochToSDFTransformer;
import org.apache.pinot.core.operator.transform.transformer.datetime.SDFToEpochTransformer;
import org.apache.pinot.core.operator.transform.transformer.datetime.SDFToSDFTransformer;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.apache.pinot.spi.data.DateTimeGranularitySpec;

public class DateTimeTransformerFactory {
    private DateTimeTransformerFactory() {
    }

    public static BaseDateTimeTransformer getDateTimeTransformer(String inputFormatStr, String outputFormatStr, String outputGranularityStr) {
        DateTimeFormatSpec inputFormat = new DateTimeFormatSpec(inputFormatStr);
        DateTimeFormatSpec outputFormat = new DateTimeFormatSpec(outputFormatStr);
        DateTimeGranularitySpec outputGranularity = new DateTimeGranularitySpec(outputGranularityStr);
        DateTimeFieldSpec.TimeFormat inputTimeFormat = inputFormat.getTimeFormat();
        DateTimeFieldSpec.TimeFormat outputTimeFormat = outputFormat.getTimeFormat();
        if (inputTimeFormat == DateTimeFieldSpec.TimeFormat.EPOCH) {
            if (outputTimeFormat == DateTimeFieldSpec.TimeFormat.EPOCH) {
                return new EpochToEpochTransformer(inputFormat, outputFormat, outputGranularity);
            }
            return new EpochToSDFTransformer(inputFormat, outputFormat, outputGranularity);
        }
        if (outputTimeFormat == DateTimeFieldSpec.TimeFormat.EPOCH) {
            return new SDFToEpochTransformer(inputFormat, outputFormat, outputGranularity);
        }
        return new SDFToSDFTransformer(inputFormat, outputFormat, outputGranularity);
    }
}

