/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.core.operator.query.AggregationGroupByOperator;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.plan.TransformPlanNode;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.startree.StarTreeUtils;
import org.apache.pinot.core.startree.plan.StarTreeTransformPlanNode;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.index.startree.AggregationFunctionColumnPair;
import org.apache.pinot.segment.spi.index.startree.StarTreeV2;

public class AggregationGroupByPlanNode
implements PlanNode {
    private final IndexSegment _indexSegment;
    private final int _maxInitialResultHolderCapacity;
    private final int _numGroupsLimit;
    private final AggregationFunction[] _aggregationFunctions;
    private final ExpressionContext[] _groupByExpressions;
    private final TransformPlanNode _transformPlanNode;
    private final StarTreeTransformPlanNode _starTreeTransformPlanNode;

    public AggregationGroupByPlanNode(IndexSegment indexSegment, QueryContext queryContext, int maxInitialResultHolderCapacity, int numGroupsLimit) {
        Map<String, List<PredicateEvaluator>> predicateEvaluatorsMap;
        AggregationFunctionColumnPair[] aggregationFunctionColumnPairs;
        this._indexSegment = indexSegment;
        this._maxInitialResultHolderCapacity = maxInitialResultHolderCapacity;
        this._numGroupsLimit = numGroupsLimit;
        this._aggregationFunctions = queryContext.getAggregationFunctions();
        assert (this._aggregationFunctions != null);
        List<ExpressionContext> groupByExpressions = queryContext.getGroupByExpressions();
        assert (groupByExpressions != null);
        this._groupByExpressions = groupByExpressions.toArray(new ExpressionContext[0]);
        List starTrees = indexSegment.getStarTrees();
        if (starTrees != null && !StarTreeUtils.isStarTreeDisabled(queryContext) && (aggregationFunctionColumnPairs = StarTreeUtils.extractAggregationFunctionPairs(this._aggregationFunctions)) != null && (predicateEvaluatorsMap = StarTreeUtils.extractPredicateEvaluatorsMap(indexSegment, queryContext.getFilter())) != null) {
            for (StarTreeV2 starTreeV2 : starTrees) {
                if (!StarTreeUtils.isFitForStarTree(starTreeV2.getMetadata(), aggregationFunctionColumnPairs, this._groupByExpressions, predicateEvaluatorsMap.keySet())) continue;
                this._transformPlanNode = null;
                this._starTreeTransformPlanNode = new StarTreeTransformPlanNode(starTreeV2, aggregationFunctionColumnPairs, this._groupByExpressions, predicateEvaluatorsMap, queryContext.getDebugOptions());
                return;
            }
        }
        Set<ExpressionContext> expressionsToTransform = AggregationFunctionUtils.collectExpressionsToTransform(this._aggregationFunctions, this._groupByExpressions);
        this._transformPlanNode = new TransformPlanNode(this._indexSegment, queryContext, expressionsToTransform, DocIdSetPlanNode.MAX_DOC_PER_CALL);
        this._starTreeTransformPlanNode = null;
    }

    public AggregationGroupByOperator run() {
        int numTotalDocs = this._indexSegment.getSegmentMetadata().getTotalDocs();
        if (this._transformPlanNode != null) {
            return new AggregationGroupByOperator(this._aggregationFunctions, this._groupByExpressions, this._maxInitialResultHolderCapacity, this._numGroupsLimit, this._transformPlanNode.run(), numTotalDocs, false);
        }
        return new AggregationGroupByOperator(this._aggregationFunctions, this._groupByExpressions, this._maxInitialResultHolderCapacity, this._numGroupsLimit, this._starTreeTransformPlanNode.run(), numTotalDocs, true);
    }
}

