/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.pinot.common.proto.Server;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.operator.combine.AggregationOnlyCombineOperator;
import org.apache.pinot.core.operator.combine.DistinctCombineOperator;
import org.apache.pinot.core.operator.combine.GroupByCombineOperator;
import org.apache.pinot.core.operator.combine.GroupByOrderByCombineOperator;
import org.apache.pinot.core.operator.combine.SelectionOnlyCombineOperator;
import org.apache.pinot.core.operator.combine.SelectionOrderByCombineOperator;
import org.apache.pinot.core.operator.streaming.StreamingSelectionOnlyCombineOperator;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.utils.QueryContextUtils;
import org.apache.pinot.core.util.QueryOptions;
import org.apache.pinot.core.util.trace.TraceCallable;
import org.apache.pinot.spi.exception.BadQueryRequestException;

public class CombinePlanNode
implements PlanNode {
    private static final int MAX_NUM_THREADS_PER_QUERY = Math.max(1, Math.min(10, Runtime.getRuntime().availableProcessors() / 2));
    private static final int TARGET_NUM_PLANS_PER_THREAD = 10;
    private final List<PlanNode> _planNodes;
    private final QueryContext _queryContext;
    private final ExecutorService _executorService;
    private final long _endTimeMs;
    private final int _numGroupsLimit;
    private final StreamObserver<Server.ServerResponse> _streamObserver;
    private final int _groupByTrimThreshold;

    public CombinePlanNode(List<PlanNode> planNodes, QueryContext queryContext, ExecutorService executorService, long endTimeMs, int numGroupsLimit, @Nullable StreamObserver<Server.ServerResponse> streamObserver, int groupByTrimThreshold) {
        this._planNodes = planNodes;
        this._queryContext = queryContext;
        this._executorService = executorService;
        this._endTimeMs = endTimeMs;
        this._numGroupsLimit = numGroupsLimit;
        this._streamObserver = streamObserver;
        this._groupByTrimThreshold = groupByTrimThreshold;
    }

    public Operator<IntermediateResultsBlock> run() {
        final int numPlanNodes = this._planNodes.size();
        ArrayList<Operator> operators = new ArrayList<Operator>(numPlanNodes);
        if (numPlanNodes <= 10) {
            for (PlanNode planNode : this._planNodes) {
                operators.add(planNode.run());
            }
        } else {
            final int numThreads = Math.min((numPlanNodes + 10 - 1) / 10, MAX_NUM_THREADS_PER_QUERY);
            final Phaser phaser = new Phaser(1);
            Future[] futures = new Future[numThreads];
            for (int i = 0; i < numThreads; ++i) {
                final int index = i;
                futures[i] = this._executorService.submit(new TraceCallable<List<Operator>>(){

                    @Override
                    public List<Operator> callJob() {
                        try {
                            if (phaser.register() < 0) {
                                List<Operator> list = Collections.emptyList();
                                return list;
                            }
                            ArrayList<Operator> operators = new ArrayList<Operator>();
                            for (int i = index; i < numPlanNodes; i += numThreads) {
                                operators.add(CombinePlanNode.this._planNodes.get(i).run());
                            }
                            ArrayList<Operator> arrayList = operators;
                            return arrayList;
                        }
                        finally {
                            phaser.arriveAndDeregister();
                        }
                    }
                });
            }
            try {
                for (Future future : futures) {
                    List ops = (List)future.get(this._endTimeMs - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                    operators.addAll(ops);
                }
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof BadQueryRequestException) {
                    throw (BadQueryRequestException)cause;
                }
                throw new RuntimeException("Caught exception while running CombinePlanNode.", e);
            }
            finally {
                for (Future future : futures) {
                    if (future.isDone()) continue;
                    future.cancel(true);
                }
                phaser.awaitAdvance(phaser.arriveAndDeregister());
            }
        }
        if (this._streamObserver != null) {
            return new StreamingSelectionOnlyCombineOperator(operators, this._queryContext, this._executorService, this._endTimeMs, this._streamObserver);
        }
        if (QueryContextUtils.isAggregationQuery(this._queryContext)) {
            if (this._queryContext.getGroupByExpressions() == null) {
                return new AggregationOnlyCombineOperator(operators, this._queryContext, this._executorService, this._endTimeMs);
            }
            QueryOptions queryOptions = new QueryOptions(this._queryContext.getQueryOptions());
            if (queryOptions.isGroupByModeSQL()) {
                return new GroupByOrderByCombineOperator(operators, this._queryContext, this._executorService, this._endTimeMs, this._groupByTrimThreshold);
            }
            return new GroupByCombineOperator(operators, this._queryContext, this._executorService, this._endTimeMs, this._numGroupsLimit);
        }
        if (QueryContextUtils.isSelectionQuery(this._queryContext)) {
            if (this._queryContext.getLimit() == 0 || this._queryContext.getOrderByExpressions() == null) {
                return new SelectionOnlyCombineOperator(operators, this._queryContext, this._executorService, this._endTimeMs);
            }
            return new SelectionOrderByCombineOperator(operators, this._queryContext, this._executorService, this._endTimeMs);
        }
        assert (QueryContextUtils.isDistinctQuery(this._queryContext));
        return new DistinctCombineOperator(operators, this._queryContext, this._executorService, this._endTimeMs);
    }
}

