/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.core.operator.query.DictionaryBasedAggregationOperator;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.index.reader.Dictionary;

public class DictionaryBasedAggregationPlanNode
implements PlanNode {
    private final IndexSegment _indexSegment;
    private final AggregationFunction[] _aggregationFunctions;
    private final Map<String, Dictionary> _dictionaryMap;

    public DictionaryBasedAggregationPlanNode(IndexSegment indexSegment, QueryContext queryContext) {
        this._indexSegment = indexSegment;
        this._aggregationFunctions = queryContext.getAggregationFunctions();
        assert (this._aggregationFunctions != null);
        this._dictionaryMap = new HashMap<String, Dictionary>();
        for (AggregationFunction aggregationFunction : this._aggregationFunctions) {
            String column = aggregationFunction.getInputExpressions().get(0).getIdentifier();
            this._dictionaryMap.computeIfAbsent(column, k -> this._indexSegment.getDataSource(k).getDictionary());
        }
    }

    public DictionaryBasedAggregationOperator run() {
        return new DictionaryBasedAggregationOperator(this._aggregationFunctions, this._dictionaryMap, this._indexSegment.getSegmentMetadata().getTotalDocs());
    }
}

