/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import java.util.List;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.operator.query.DictionaryBasedDistinctOperator;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctAggregationFunction;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;

public class DictionaryBasedDistinctPlanNode
implements PlanNode {
    private final FieldSpec.DataType _dataType;
    private final int _numDocs;
    private final DistinctAggregationFunction _distinctAggregationFunction;
    private final Dictionary _dictionary;

    public DictionaryBasedDistinctPlanNode(IndexSegment indexSegment, QueryContext queryContext, Dictionary dictionary) {
        AggregationFunction[] aggregationFunctions = queryContext.getAggregationFunctions();
        assert (aggregationFunctions != null && aggregationFunctions.length == 1 && aggregationFunctions[0] instanceof DistinctAggregationFunction);
        this._distinctAggregationFunction = (DistinctAggregationFunction)aggregationFunctions[0];
        List<ExpressionContext> expressions = this._distinctAggregationFunction.getInputExpressions();
        ExpressionContext expression = expressions.get(0);
        this._dataType = indexSegment.getDataSource(expression.getIdentifier()).getDataSourceMetadata().getDataType();
        this._dictionary = dictionary;
        this._numDocs = indexSegment.getSegmentMetadata().getTotalDocs();
    }

    public DictionaryBasedDistinctOperator run() {
        return new DictionaryBasedDistinctOperator(this._dataType, this._distinctAggregationFunction, this._dictionary, this._numDocs);
    }
}

