/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import org.apache.pinot.core.operator.query.DistinctOperator;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.plan.TransformPlanNode;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctAggregationFunction;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.IndexSegment;

public class DistinctPlanNode
implements PlanNode {
    private final IndexSegment _indexSegment;
    private final DistinctAggregationFunction _distinctAggregationFunction;
    private final TransformPlanNode _transformPlanNode;

    public DistinctPlanNode(IndexSegment indexSegment, QueryContext queryContext) {
        this._indexSegment = indexSegment;
        AggregationFunction[] aggregationFunctions = queryContext.getAggregationFunctions();
        assert (aggregationFunctions != null && aggregationFunctions.length == 1 && aggregationFunctions[0] instanceof DistinctAggregationFunction);
        this._distinctAggregationFunction = (DistinctAggregationFunction)aggregationFunctions[0];
        this._transformPlanNode = new TransformPlanNode(this._indexSegment, queryContext, this._distinctAggregationFunction.getInputExpressions(), DocIdSetPlanNode.MAX_DOC_PER_CALL);
    }

    public DistinctOperator run() {
        return new DistinctOperator(this._indexSegment, this._distinctAggregationFunction, this._transformPlanNode.run());
    }
}

