/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import com.google.common.base.Preconditions;
import org.apache.pinot.core.operator.DocIdSetOperator;
import org.apache.pinot.core.plan.FilterPlanNode;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.IndexSegment;

public class DocIdSetPlanNode
implements PlanNode {
    public static int MAX_DOC_PER_CALL = 10000;
    private final FilterPlanNode _filterPlanNode;
    private final int _maxDocPerCall;

    public DocIdSetPlanNode(IndexSegment indexSegment, QueryContext queryContext, int maxDocPerCall) {
        Preconditions.checkState((maxDocPerCall > 0 && maxDocPerCall <= MAX_DOC_PER_CALL ? 1 : 0) != 0);
        this._filterPlanNode = new FilterPlanNode(indexSegment, queryContext);
        this._maxDocPerCall = maxDocPerCall;
    }

    public DocIdSetOperator run() {
        return new DocIdSetOperator(this._filterPlanNode.run(), this._maxDocPerCall);
    }
}

