/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.common.request.context.predicate.JsonMatchPredicate;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.common.request.context.predicate.RegexpLikePredicate;
import org.apache.pinot.common.request.context.predicate.TextMatchPredicate;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.operator.filter.BitmapBasedFilterOperator;
import org.apache.pinot.core.operator.filter.EmptyFilterOperator;
import org.apache.pinot.core.operator.filter.ExpressionFilterOperator;
import org.apache.pinot.core.operator.filter.FilterOperatorUtils;
import org.apache.pinot.core.operator.filter.H3IndexFilterOperator;
import org.apache.pinot.core.operator.filter.JsonMatchFilterOperator;
import org.apache.pinot.core.operator.filter.MatchAllFilterOperator;
import org.apache.pinot.core.operator.filter.TextMatchFilterOperator;
import org.apache.pinot.core.operator.filter.predicate.FSTBasedRegexpPredicateEvaluatorFactory;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluatorProvider;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.util.QueryOptions;
import org.apache.pinot.segment.local.segment.index.datasource.MutableDataSource;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.ThreadSafeMutableRoaringBitmap;
import org.apache.pinot.segment.spi.index.reader.JsonIndexReader;
import org.apache.pinot.segment.spi.index.reader.NullValueVectorReader;
import org.apache.pinot.spi.exception.BadQueryRequestException;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;

public class FilterPlanNode
implements PlanNode {
    private final IndexSegment _indexSegment;
    private final QueryContext _queryContext;
    private final int _numDocs;

    public FilterPlanNode(IndexSegment indexSegment, QueryContext queryContext) {
        this._indexSegment = indexSegment;
        this._queryContext = queryContext;
        this._numDocs = this._indexSegment.getSegmentMetadata().getTotalDocs();
    }

    public BaseFilterOperator run() {
        FilterContext filter = this._queryContext.getFilter();
        ThreadSafeMutableRoaringBitmap validDocIds = this._indexSegment.getValidDocIds();
        boolean upsertSkipped = false;
        if (this._queryContext.getQueryOptions() != null) {
            upsertSkipped = new QueryOptions(this._queryContext.getQueryOptions()).isSkipUpsert();
        }
        if (filter != null) {
            BaseFilterOperator filterOperator = this.constructPhysicalOperator(filter, this._queryContext.getDebugOptions());
            if (validDocIds != null && !upsertSkipped) {
                BitmapBasedFilterOperator validDocFilter = new BitmapBasedFilterOperator((ImmutableRoaringBitmap)validDocIds.getMutableRoaringBitmap(), false, this._numDocs);
                return FilterOperatorUtils.getAndFilterOperator(Arrays.asList(filterOperator, validDocFilter), this._numDocs, this._queryContext.getDebugOptions());
            }
            return filterOperator;
        }
        if (validDocIds != null && !upsertSkipped) {
            return new BitmapBasedFilterOperator((ImmutableRoaringBitmap)validDocIds.getMutableRoaringBitmap(), false, this._numDocs);
        }
        return new MatchAllFilterOperator(this._numDocs);
    }

    private boolean canApplyH3Index(Predicate predicate, FunctionContext function) {
        if (predicate.getType() != Predicate.Type.RANGE) {
            return false;
        }
        if (!function.getFunctionName().equalsIgnoreCase("ST_Distance")) {
            return false;
        }
        List arguments = function.getArguments();
        if (arguments.size() != 2) {
            throw new BadQueryRequestException("Expect 2 arguments for function: ST_Distance");
        }
        String columnName = null;
        boolean findLiteral = false;
        for (ExpressionContext argument : arguments) {
            if (argument.getType() == ExpressionContext.Type.IDENTIFIER) {
                columnName = argument.getIdentifier();
                continue;
            }
            if (argument.getType() != ExpressionContext.Type.LITERAL) continue;
            findLiteral = true;
        }
        return columnName != null && this._indexSegment.getDataSource(columnName).getH3Index() != null && findLiteral;
    }

    private BaseFilterOperator constructPhysicalOperator(FilterContext filter, @Nullable Map<String, String> debugOptions) {
        switch (filter.getType()) {
            case AND: {
                List childFilters = filter.getChildren();
                ArrayList<BaseFilterOperator> childFilterOperators = new ArrayList<BaseFilterOperator>(childFilters.size());
                for (FilterContext childFilter : childFilters) {
                    BaseFilterOperator childFilterOperator = this.constructPhysicalOperator(childFilter, debugOptions);
                    if (childFilterOperator.isResultEmpty()) {
                        return EmptyFilterOperator.getInstance();
                    }
                    if (childFilterOperator.isResultMatchingAll()) continue;
                    childFilterOperators.add(childFilterOperator);
                }
                return FilterOperatorUtils.getAndFilterOperator(childFilterOperators, this._numDocs, debugOptions);
            }
            case OR: {
                List childFilters = filter.getChildren();
                ArrayList<BaseFilterOperator> childFilterOperators = new ArrayList<BaseFilterOperator>(childFilters.size());
                for (FilterContext childFilter : childFilters) {
                    BaseFilterOperator childFilterOperator = this.constructPhysicalOperator(childFilter, debugOptions);
                    if (childFilterOperator.isResultMatchingAll()) {
                        return new MatchAllFilterOperator(this._numDocs);
                    }
                    if (childFilterOperator.isResultEmpty()) continue;
                    childFilterOperators.add(childFilterOperator);
                }
                return FilterOperatorUtils.getOrFilterOperator(childFilterOperators, this._numDocs, debugOptions);
            }
            case PREDICATE: {
                Predicate predicate = filter.getPredicate();
                ExpressionContext lhs = predicate.getLhs();
                if (lhs.getType() == ExpressionContext.Type.FUNCTION) {
                    if (this.canApplyH3Index(predicate, lhs.getFunction())) {
                        return new H3IndexFilterOperator(this._indexSegment, predicate, this._numDocs);
                    }
                    return new ExpressionFilterOperator(this._indexSegment, predicate, this._numDocs);
                }
                String column = lhs.getIdentifier();
                DataSource dataSource = this._indexSegment.getDataSource(column);
                switch (predicate.getType()) {
                    case TEXT_MATCH: {
                        return new TextMatchFilterOperator(dataSource.getTextIndex(), ((TextMatchPredicate)predicate).getValue(), this._numDocs);
                    }
                    case REGEXP_LIKE: {
                        PredicateEvaluator evaluator = dataSource.getFSTIndex() != null ? FSTBasedRegexpPredicateEvaluatorFactory.newFSTBasedEvaluator(dataSource.getFSTIndex(), dataSource.getDictionary(), ((RegexpLikePredicate)predicate).getValue()) : (dataSource instanceof MutableDataSource && ((MutableDataSource)dataSource).isFSTEnabled() ? FSTBasedRegexpPredicateEvaluatorFactory.newAutomatonBasedEvaluator(dataSource.getDictionary(), ((RegexpLikePredicate)predicate).getValue()) : PredicateEvaluatorProvider.getPredicateEvaluator(predicate, dataSource.getDictionary(), dataSource.getDataSourceMetadata().getDataType()));
                        return FilterOperatorUtils.getLeafFilterOperator(evaluator, dataSource, this._numDocs);
                    }
                    case JSON_MATCH: {
                        JsonIndexReader jsonIndex = dataSource.getJsonIndex();
                        Preconditions.checkState((jsonIndex != null ? 1 : 0) != 0, (String)"Cannot apply JSON_MATCH on column: %s without json index", (Object)column);
                        return new JsonMatchFilterOperator(jsonIndex, ((JsonMatchPredicate)predicate).getValue(), this._numDocs);
                    }
                    case IS_NULL: {
                        NullValueVectorReader nullValueVector = dataSource.getNullValueVector();
                        if (nullValueVector != null) {
                            return new BitmapBasedFilterOperator(nullValueVector.getNullBitmap(), false, this._numDocs);
                        }
                        return EmptyFilterOperator.getInstance();
                    }
                    case IS_NOT_NULL: {
                        NullValueVectorReader nullValueVector = dataSource.getNullValueVector();
                        if (nullValueVector != null) {
                            return new BitmapBasedFilterOperator(nullValueVector.getNullBitmap(), true, this._numDocs);
                        }
                        return new MatchAllFilterOperator(this._numDocs);
                    }
                }
                PredicateEvaluator predicateEvaluator = PredicateEvaluatorProvider.getPredicateEvaluator(predicate, dataSource.getDictionary(), dataSource.getDataSourceMetadata().getDataType());
                return FilterOperatorUtils.getLeafFilterOperator(predicateEvaluator, dataSource, this._numDocs);
            }
        }
        throw new IllegalStateException();
    }
}

