/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.core.operator.query.MetadataBasedAggregationOperator;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.datasource.DataSource;

public class MetadataBasedAggregationPlanNode
implements PlanNode {
    private final IndexSegment _indexSegment;
    private final AggregationFunction[] _aggregationFunctions;
    private final Map<String, DataSource> _dataSourceMap;

    public MetadataBasedAggregationPlanNode(IndexSegment indexSegment, QueryContext queryContext) {
        this._indexSegment = indexSegment;
        this._aggregationFunctions = queryContext.getAggregationFunctions();
        assert (this._aggregationFunctions != null);
        this._dataSourceMap = new HashMap<String, DataSource>();
        for (AggregationFunction aggregationFunction : this._aggregationFunctions) {
            if (aggregationFunction.getType() == AggregationFunctionType.COUNT) continue;
            String column = aggregationFunction.getInputExpressions().get(0).getIdentifier();
            this._dataSourceMap.computeIfAbsent(column, arg_0 -> ((IndexSegment)this._indexSegment).getDataSource(arg_0));
        }
    }

    public MetadataBasedAggregationOperator run() {
        return new MetadataBasedAggregationOperator(this._aggregationFunctions, this._indexSegment.getSegmentMetadata(), this._dataSourceMap);
    }
}

