/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.blocks.IntermediateResultsBlock;
import org.apache.pinot.core.operator.query.EmptySelectionOperator;
import org.apache.pinot.core.operator.query.SelectionOnlyOperator;
import org.apache.pinot.core.operator.query.SelectionOrderByOperator;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.plan.TransformPlanNode;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.apache.pinot.segment.spi.IndexSegment;

public class SelectionPlanNode
implements PlanNode {
    private final IndexSegment _indexSegment;
    private final QueryContext _queryContext;
    private final List<ExpressionContext> _expressions;
    private final TransformPlanNode _transformPlanNode;

    public SelectionPlanNode(IndexSegment indexSegment, QueryContext queryContext) {
        this._indexSegment = indexSegment;
        this._queryContext = queryContext;
        this._expressions = SelectionOperatorUtils.extractExpressions(queryContext, indexSegment);
        int limit = queryContext.getLimit();
        if (limit > 0) {
            List<OrderByExpressionContext> orderByExpressions = this._queryContext.getOrderByExpressions();
            if (orderByExpressions == null) {
                this._transformPlanNode = new TransformPlanNode(this._indexSegment, queryContext, this._expressions, Math.min(limit, DocIdSetPlanNode.MAX_DOC_PER_CALL));
            } else if (orderByExpressions.size() == this._expressions.size()) {
                this._transformPlanNode = new TransformPlanNode(this._indexSegment, queryContext, this._expressions, DocIdSetPlanNode.MAX_DOC_PER_CALL);
            } else {
                ArrayList<ExpressionContext> expressionsToTransform = new ArrayList<ExpressionContext>(orderByExpressions.size() + 1);
                for (OrderByExpressionContext orderByExpression : orderByExpressions) {
                    expressionsToTransform.add(orderByExpression.getExpression());
                }
                expressionsToTransform.add(ExpressionContext.forIdentifier((String)"$docId"));
                this._transformPlanNode = new TransformPlanNode(this._indexSegment, queryContext, expressionsToTransform, DocIdSetPlanNode.MAX_DOC_PER_CALL);
            }
        } else {
            this._transformPlanNode = new TransformPlanNode(this._indexSegment, queryContext, this._expressions, 0);
        }
    }

    public Operator<IntermediateResultsBlock> run() {
        TransformOperator transformOperator = this._transformPlanNode.run();
        if (this._queryContext.getLimit() > 0) {
            if (this._queryContext.getOrderByExpressions() == null) {
                return new SelectionOnlyOperator(this._indexSegment, this._queryContext, this._expressions, transformOperator);
            }
            return new SelectionOrderByOperator(this._indexSegment, this._queryContext, this._expressions, transformOperator);
        }
        return new EmptySelectionOperator(this._indexSegment, this._expressions, transformOperator);
    }
}

