/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.operator.streaming.StreamingSelectionOnlyOperator;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.plan.TransformPlanNode;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.apache.pinot.segment.spi.IndexSegment;

public class StreamingSelectionPlanNode
implements PlanNode {
    private final IndexSegment _indexSegment;
    private final QueryContext _queryContext;
    private final List<ExpressionContext> _expressions;
    private final TransformPlanNode _transformPlanNode;

    public StreamingSelectionPlanNode(IndexSegment indexSegment, QueryContext queryContext) {
        Preconditions.checkState((queryContext.getOrderByExpressions() == null ? 1 : 0) != 0, (Object)"Selection order-by is not supported for streaming");
        this._indexSegment = indexSegment;
        this._queryContext = queryContext;
        this._expressions = SelectionOperatorUtils.extractExpressions(queryContext, indexSegment);
        this._transformPlanNode = new TransformPlanNode(this._indexSegment, queryContext, this._expressions, Math.min(queryContext.getLimit(), DocIdSetPlanNode.MAX_DOC_PER_CALL));
    }

    public StreamingSelectionOnlyOperator run() {
        return new StreamingSelectionOnlyOperator(this._indexSegment, this._queryContext, this._expressions, this._transformPlanNode.run());
    }
}

