/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import java.util.Collection;
import java.util.HashSet;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.operator.transform.PassThroughTransformOperator;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.plan.DocIdSetPlanNode;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.plan.ProjectionPlanNode;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.IndexSegment;

public class TransformPlanNode
implements PlanNode {
    private final Collection<ExpressionContext> _expressions;
    private final ProjectionPlanNode _projectionPlanNode;
    private boolean _areAllExpressionsIdentifiers = true;

    public TransformPlanNode(IndexSegment indexSegment, QueryContext queryContext, Collection<ExpressionContext> expressions, int maxDocsPerCall) {
        this._expressions = expressions;
        HashSet<String> projectionColumns = new HashSet<String>();
        for (ExpressionContext expression : expressions) {
            expression.getColumns(projectionColumns);
            if (expression.getType() == ExpressionContext.Type.IDENTIFIER) continue;
            this._areAllExpressionsIdentifiers = false;
        }
        DocIdSetPlanNode docIdSetPlanNode = maxDocsPerCall > 0 ? new DocIdSetPlanNode(indexSegment, queryContext, maxDocsPerCall) : null;
        this._projectionPlanNode = new ProjectionPlanNode(indexSegment, projectionColumns, docIdSetPlanNode);
    }

    public TransformOperator run() {
        if (!this._areAllExpressionsIdentifiers) {
            return new TransformOperator(this._projectionPlanNode.run(), this._expressions);
        }
        return new PassThroughTransformOperator(this._projectionPlanNode.run(), this._expressions);
    }
}

