/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan.maker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.pinot.common.proto.Server;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.core.plan.AggregationGroupByOrderByPlanNode;
import org.apache.pinot.core.plan.AggregationGroupByPlanNode;
import org.apache.pinot.core.plan.AggregationPlanNode;
import org.apache.pinot.core.plan.CombinePlanNode;
import org.apache.pinot.core.plan.DictionaryBasedAggregationPlanNode;
import org.apache.pinot.core.plan.DictionaryBasedDistinctPlanNode;
import org.apache.pinot.core.plan.DistinctPlanNode;
import org.apache.pinot.core.plan.GlobalPlanImplV0;
import org.apache.pinot.core.plan.InstanceResponsePlanNode;
import org.apache.pinot.core.plan.MetadataBasedAggregationPlanNode;
import org.apache.pinot.core.plan.Plan;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.plan.SelectionPlanNode;
import org.apache.pinot.core.plan.StreamingSelectionPlanNode;
import org.apache.pinot.core.plan.maker.PlanMaker;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.core.query.aggregation.function.DistinctAggregationFunction;
import org.apache.pinot.core.query.config.QueryExecutorConfig;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.utils.QueryContextUtils;
import org.apache.pinot.core.util.QueryOptions;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstancePlanMakerImplV2
implements PlanMaker {
    public static final String MAX_INITIAL_RESULT_HOLDER_CAPACITY_KEY = "max.init.group.holder.capacity";
    public static final int DEFAULT_MAX_INITIAL_RESULT_HOLDER_CAPACITY = 10000;
    public static final String NUM_GROUPS_LIMIT = "num.groups.limit";
    public static final int DEFAULT_NUM_GROUPS_LIMIT = 100000;
    public static final String ENABLE_SEGMENT_GROUP_TRIM = "enable.segment.group.trim";
    public static final boolean DEFAULT_ENABLE_SEGMENT_GROUP_TRIM = false;
    public static final String MIN_SEGMENT_GROUP_TRIM_SIZE = "min.segment.group.trim.size";
    public static final int DEFAULT_MIN_SEGMENT_GROUP_TRIM_SIZE = -1;
    public static final String GROUPBY_TRIM_THRESHOLD = "groupby.trim.threshold";
    public static final int DEFAULT_GROUPBY_TRIM_THRESHOLD = 1000000;
    private static final Logger LOGGER = LoggerFactory.getLogger(InstancePlanMakerImplV2.class);
    private final int _maxInitialResultHolderCapacity;
    private final int _numGroupsLimit;
    private final int _groupByTrimThreshold;
    private final int _minSegmentGroupTrimSize;

    @VisibleForTesting
    public InstancePlanMakerImplV2() {
        this._maxInitialResultHolderCapacity = 10000;
        this._numGroupsLimit = 100000;
        this._groupByTrimThreshold = 1000000;
        this._minSegmentGroupTrimSize = -1;
    }

    @VisibleForTesting
    public InstancePlanMakerImplV2(int maxInitialResultHolderCapacity, int numGroupsLimit) {
        this._maxInitialResultHolderCapacity = maxInitialResultHolderCapacity;
        this._numGroupsLimit = numGroupsLimit;
        this._groupByTrimThreshold = 1000000;
        this._minSegmentGroupTrimSize = -1;
    }

    @VisibleForTesting
    public InstancePlanMakerImplV2(int minSegmentGroupTrimSize) {
        this._maxInitialResultHolderCapacity = 10000;
        this._numGroupsLimit = 100000;
        this._groupByTrimThreshold = 1000000;
        this._minSegmentGroupTrimSize = minSegmentGroupTrimSize;
    }

    public InstancePlanMakerImplV2(QueryExecutorConfig queryExecutorConfig) {
        this._maxInitialResultHolderCapacity = queryExecutorConfig.getConfig().getProperty(MAX_INITIAL_RESULT_HOLDER_CAPACITY_KEY, 10000);
        this._numGroupsLimit = queryExecutorConfig.getConfig().getProperty(NUM_GROUPS_LIMIT, 100000);
        this._groupByTrimThreshold = queryExecutorConfig.getConfig().getProperty(GROUPBY_TRIM_THRESHOLD, 1000000);
        Preconditions.checkState((this._maxInitialResultHolderCapacity <= this._numGroupsLimit ? 1 : 0) != 0, (String)"Invalid configuration: maxInitialResultHolderCapacity: %d must be smaller or equal to numGroupsLimit: %d", (int)this._maxInitialResultHolderCapacity, (int)this._numGroupsLimit);
        boolean enableSegmentGroupTrim = queryExecutorConfig.getConfig().getProperty(ENABLE_SEGMENT_GROUP_TRIM, false);
        int minSegmentGroupTrimSize = queryExecutorConfig.getConfig().getProperty(MIN_SEGMENT_GROUP_TRIM_SIZE, -1);
        this._minSegmentGroupTrimSize = minSegmentGroupTrimSize > 0 ? minSegmentGroupTrimSize : (enableSegmentGroupTrim ? 5000 : -1);
        LOGGER.info("Initializing plan maker with maxInitialResultHolderCapacity: {}, numGroupsLimit: {}, enableSegmentTrim: {}, minSegmentGroupTrimSize: {}", new Object[]{this._maxInitialResultHolderCapacity, this._numGroupsLimit, minSegmentGroupTrimSize > 0 || enableSegmentGroupTrim, this._minSegmentGroupTrimSize});
    }

    @Override
    public Plan makeInstancePlan(List<IndexSegment> indexSegments, QueryContext queryContext, ExecutorService executorService, long endTimeMs) {
        ArrayList<PlanNode> planNodes = new ArrayList<PlanNode>(indexSegments.size());
        for (IndexSegment indexSegment : indexSegments) {
            planNodes.add(this.makeSegmentPlanNode(indexSegment, queryContext));
        }
        CombinePlanNode combinePlanNode = new CombinePlanNode(planNodes, queryContext, executorService, endTimeMs, this._numGroupsLimit, null, this._groupByTrimThreshold);
        return new GlobalPlanImplV0(new InstanceResponsePlanNode(combinePlanNode));
    }

    @Override
    public PlanNode makeSegmentPlanNode(IndexSegment indexSegment, QueryContext queryContext) {
        List<ExpressionContext> selectExpressions = queryContext.getSelectExpressions();
        if (selectExpressions.size() == 1 && "*".equals(selectExpressions.get(0).getIdentifier())) {
            indexSegment.prefetch(indexSegment.getPhysicalColumnNames());
        } else {
            indexSegment.prefetch(queryContext.getColumns());
        }
        if (QueryContextUtils.isAggregationQuery(queryContext)) {
            List<ExpressionContext> groupByExpressions = queryContext.getGroupByExpressions();
            if (groupByExpressions != null) {
                QueryOptions queryOptions = new QueryOptions(queryContext.getQueryOptions());
                if (queryOptions.isGroupByModeSQL()) {
                    return new AggregationGroupByOrderByPlanNode(indexSegment, queryContext, this._maxInitialResultHolderCapacity, this._numGroupsLimit, this._minSegmentGroupTrimSize);
                }
                return new AggregationGroupByPlanNode(indexSegment, queryContext, this._maxInitialResultHolderCapacity, this._numGroupsLimit);
            }
            if (queryContext.getFilter() == null && indexSegment.getValidDocIds() == null) {
                if (InstancePlanMakerImplV2.isFitForMetadataBasedPlan(queryContext)) {
                    return new MetadataBasedAggregationPlanNode(indexSegment, queryContext);
                }
                if (InstancePlanMakerImplV2.isFitForDictionaryBasedPlan(queryContext, indexSegment)) {
                    return new DictionaryBasedAggregationPlanNode(indexSegment, queryContext);
                }
            }
            return new AggregationPlanNode(indexSegment, queryContext);
        }
        if (QueryContextUtils.isSelectionQuery(queryContext)) {
            return new SelectionPlanNode(indexSegment, queryContext);
        }
        assert (QueryContextUtils.isDistinctQuery(queryContext));
        return this.getDistinctPlanNode(indexSegment, queryContext);
    }

    @Override
    public Plan makeStreamingInstancePlan(List<IndexSegment> indexSegments, QueryContext queryContext, ExecutorService executorService, StreamObserver<Server.ServerResponse> streamObserver, long endTimeMs) {
        ArrayList<PlanNode> planNodes = new ArrayList<PlanNode>(indexSegments.size());
        for (IndexSegment indexSegment : indexSegments) {
            planNodes.add(this.makeStreamingSegmentPlanNode(indexSegment, queryContext));
        }
        CombinePlanNode combinePlanNode = new CombinePlanNode(planNodes, queryContext, executorService, endTimeMs, this._numGroupsLimit, streamObserver, this._groupByTrimThreshold);
        return new GlobalPlanImplV0(new InstanceResponsePlanNode(combinePlanNode));
    }

    @Override
    public PlanNode makeStreamingSegmentPlanNode(IndexSegment indexSegment, QueryContext queryContext) {
        if (!QueryContextUtils.isSelectionQuery(queryContext)) {
            throw new UnsupportedOperationException("Only selection queries are supported");
        }
        return new StreamingSelectionPlanNode(indexSegment, queryContext);
    }

    @VisibleForTesting
    static boolean isFitForMetadataBasedPlan(QueryContext queryContext) {
        List<ExpressionContext> selectExpressions = queryContext.getSelectExpressions();
        for (ExpressionContext expression : selectExpressions) {
            if (expression.getFunction().getFunctionName().equals("count")) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    static boolean isFitForDictionaryBasedPlan(QueryContext queryContext, IndexSegment indexSegment) {
        List<ExpressionContext> selectExpressions = queryContext.getSelectExpressions();
        for (ExpressionContext expression : selectExpressions) {
            FunctionContext function = expression.getFunction();
            String functionName = function.getFunctionName();
            if (!AggregationFunctionUtils.isFitForDictionaryBasedComputation(functionName)) {
                return false;
            }
            ExpressionContext argument = (ExpressionContext)function.getArguments().get(0);
            if (argument.getType() != ExpressionContext.Type.IDENTIFIER) {
                return false;
            }
            String column = argument.getIdentifier();
            Dictionary dictionary = indexSegment.getDataSource(column).getDictionary();
            if (dictionary == null) {
                return false;
            }
            if (dictionary.isSorted() || functionName.equalsIgnoreCase(AggregationFunctionType.DISTINCTCOUNT.name()) || functionName.equalsIgnoreCase(AggregationFunctionType.SEGMENTPARTITIONEDDISTINCTCOUNT.name())) continue;
            return false;
        }
        return true;
    }

    private PlanNode getDistinctPlanNode(IndexSegment indexSegment, QueryContext queryContext) {
        String column;
        Dictionary dictionary;
        ExpressionContext expression;
        AggregationFunction[] aggregationFunctions = queryContext.getAggregationFunctions();
        DistinctAggregationFunction distinctAggregationFunction = (DistinctAggregationFunction)aggregationFunctions[0];
        List<ExpressionContext> expressions = distinctAggregationFunction.getInputExpressions();
        if (expressions.size() == 1 && queryContext.getFilter() == null && (expression = expressions.get(0)).getType() == ExpressionContext.Type.IDENTIFIER && (dictionary = indexSegment.getDataSource(column = expression.getIdentifier()).getDictionary()) != null) {
            return new DictionaryBasedDistinctPlanNode(indexSegment, queryContext, dictionary);
        }
        return new DistinctPlanNode(indexSegment, queryContext);
    }
}

