/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import com.google.common.math.DoubleMath;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.AggregationInfo;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.segment.spi.index.startree.AggregationFunctionColumnPair;

public class AggregationFunctionUtils {
    private AggregationFunctionUtils() {
    }

    public static List<String> getArguments(AggregationInfo aggregationInfo) {
        List expressions = aggregationInfo.getExpressions();
        if (expressions != null) {
            return expressions;
        }
        String column = (String)aggregationInfo.getAggregationParams().get("column");
        return Arrays.asList(column.split(":"));
    }

    @Nullable
    public static AggregationFunctionColumnPair getAggregationFunctionColumnPair(AggregationFunction aggregationFunction) {
        ExpressionContext inputExpression;
        AggregationFunctionType aggregationFunctionType = aggregationFunction.getType();
        if (aggregationFunctionType == AggregationFunctionType.COUNT) {
            return AggregationFunctionColumnPair.COUNT_STAR;
        }
        List<ExpressionContext> inputExpressions = aggregationFunction.getInputExpressions();
        if (inputExpressions.size() == 1 && (inputExpression = inputExpressions.get(0)).getType() == ExpressionContext.Type.IDENTIFIER) {
            return new AggregationFunctionColumnPair(aggregationFunctionType, inputExpression.getIdentifier());
        }
        return null;
    }

    public static String formatValue(Object value) {
        if (value instanceof Double) {
            double doubleValue = (Double)value;
            if (doubleValue <= 9.223372036854776E18 && doubleValue >= -9.223372036854776E18 && DoubleMath.isMathematicalInteger((double)doubleValue)) {
                return (long)doubleValue + ".00000";
            }
            return String.format(Locale.US, "%1.5f", doubleValue);
        }
        return value.toString();
    }

    public static Serializable getSerializableValue(Object value) {
        if (value instanceof Number) {
            return (Number)value;
        }
        return value.toString();
    }

    public static String concatArgs(String[] arguments) {
        return arguments.length > 1 ? String.join((CharSequence)":", arguments) : arguments[0];
    }

    public static Set<ExpressionContext> collectExpressionsToTransform(AggregationFunction[] aggregationFunctions, @Nullable ExpressionContext[] groupByExpressions) {
        HashSet<ExpressionContext> expressions = new HashSet<ExpressionContext>();
        for (AggregationFunction aggregationFunction : aggregationFunctions) {
            expressions.addAll(aggregationFunction.getInputExpressions());
        }
        if (groupByExpressions != null) {
            expressions.addAll(Arrays.asList(groupByExpressions));
        }
        return expressions;
    }

    public static Map<ExpressionContext, BlockValSet> getBlockValSetMap(AggregationFunction aggregationFunction, TransformBlock transformBlock) {
        List<ExpressionContext> expressions = aggregationFunction.getInputExpressions();
        int numExpressions = expressions.size();
        if (numExpressions == 0) {
            return Collections.emptyMap();
        }
        if (numExpressions == 1) {
            ExpressionContext expression = expressions.get(0);
            return Collections.singletonMap(expression, transformBlock.getBlockValueSet(expression));
        }
        HashMap<ExpressionContext, BlockValSet> blockValSetMap = new HashMap<ExpressionContext, BlockValSet>();
        for (ExpressionContext expression : expressions) {
            blockValSetMap.put(expression, transformBlock.getBlockValueSet(expression));
        }
        return blockValSetMap;
    }

    public static Map<ExpressionContext, BlockValSet> getBlockValSetMap(AggregationFunctionColumnPair aggregationFunctionColumnPair, TransformBlock transformBlock) {
        ExpressionContext expression = ExpressionContext.forIdentifier((String)aggregationFunctionColumnPair.getColumn());
        BlockValSet blockValSet = transformBlock.getBlockValueSet(aggregationFunctionColumnPair.toColumnName());
        return Collections.singletonMap(expression, blockValSet);
    }

    public static boolean isFitForDictionaryBasedComputation(String functionName) {
        return functionName.equalsIgnoreCase(AggregationFunctionType.MIN.name()) || functionName.equalsIgnoreCase(AggregationFunctionType.MAX.name()) || functionName.equalsIgnoreCase(AggregationFunctionType.MINMAXRANGE.name()) || functionName.equalsIgnoreCase(AggregationFunctionType.DISTINCTCOUNT.name()) || functionName.equalsIgnoreCase(AggregationFunctionType.SEGMENTPARTITIONEDDISTINCTCOUNT.name());
    }
}

