/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.segment.spi.AggregationFunctionType;

public class DistinctAggregationFunction
implements AggregationFunction<Object, Comparable> {
    private final List<ExpressionContext> _expressions;
    private final String[] _columns;
    private final List<OrderByExpressionContext> _orderByExpressions;
    private final int _limit;

    public DistinctAggregationFunction(List<ExpressionContext> expressions, @Nullable List<OrderByExpressionContext> orderByExpressions, int limit) {
        this._expressions = expressions;
        int numExpressions = expressions.size();
        this._columns = new String[numExpressions];
        for (int i = 0; i < numExpressions; ++i) {
            this._columns[i] = expressions.get(i).toString();
        }
        this._orderByExpressions = orderByExpressions;
        this._limit = limit;
    }

    public String[] getColumns() {
        return this._columns;
    }

    public List<OrderByExpressionContext> getOrderByExpressions() {
        return this._orderByExpressions;
    }

    public int getLimit() {
        return this._limit;
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.DISTINCT;
    }

    @Override
    public String getColumnName() {
        return AggregationFunctionType.DISTINCT.getName() + "_" + AggregationFunctionUtils.concatArgs(this._columns);
    }

    @Override
    public String getResultColumnName() {
        return AggregationFunctionType.DISTINCT.getName().toLowerCase() + "(" + AggregationFunctionUtils.concatArgs(this._columns) + ")";
    }

    @Override
    public List<ExpressionContext> getInputExpressions() {
        return this._expressions;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        throw new UnsupportedOperationException("Operation not supported for DISTINCT aggregation function");
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        throw new UnsupportedOperationException("Operation not supported for DISTINCT aggregation function");
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        throw new UnsupportedOperationException("Operation not supported for DISTINCT aggregation function");
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        throw new UnsupportedOperationException("Operation not supported for DISTINCT aggregation function");
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        throw new UnsupportedOperationException("Operation not supported for DISTINCT aggregation function");
    }

    @Override
    public Object extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        throw new UnsupportedOperationException("Operation not supported for DISTINCT aggregation function");
    }

    @Override
    public Object extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        throw new UnsupportedOperationException("Operation not supported for DISTINCT aggregation function");
    }

    @Override
    public Object merge(Object intermediateResult1, Object intermediateResult2) {
        throw new UnsupportedOperationException("Operation not supported for DISTINCT aggregation function");
    }

    @Override
    public boolean isIntermediateResultComparable() {
        throw new UnsupportedOperationException("Operation not supported for DISTINCT aggregation function");
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        throw new UnsupportedOperationException("Operation not supported for DISTINCT aggregation function");
    }

    @Override
    public Comparable extractFinalResult(Object intermediateResult) {
        throw new UnsupportedOperationException("Operation not supported for DISTINCT aggregation function");
    }
}

