/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import it.unimi.dsi.fastutil.floats.FloatOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.BaseSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ByteArray;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.RoaringBitmap;

public class DistinctCountAggregationFunction
extends BaseSingleInputAggregationFunction<Set, Integer> {
    public DistinctCountAggregationFunction(ExpressionContext expression) {
        super(expression);
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.DISTINCTCOUNT;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        Dictionary dictionary = blockValSet.getDictionary();
        if (dictionary != null) {
            int[] dictIds = blockValSet.getDictionaryIdsSV();
            DistinctCountAggregationFunction.getDictIdBitmap(aggregationResultHolder, dictionary).addN(dictIds, 0, length);
            return;
        }
        FieldSpec.DataType storedType = blockValSet.getValueType().getStoredType();
        Set valueSet = DistinctCountAggregationFunction.getValueSet(aggregationResultHolder, storedType);
        switch (storedType) {
            case INT: {
                IntOpenHashSet intSet = (IntOpenHashSet)valueSet;
                int[] intValues = blockValSet.getIntValuesSV();
                for (int i = 0; i < length; ++i) {
                    intSet.add(intValues[i]);
                }
                break;
            }
            case LONG: {
                LongOpenHashSet longSet = (LongOpenHashSet)valueSet;
                long[] longValues = blockValSet.getLongValuesSV();
                for (int i = 0; i < length; ++i) {
                    longSet.add(longValues[i]);
                }
                break;
            }
            case FLOAT: {
                FloatOpenHashSet floatSet = (FloatOpenHashSet)valueSet;
                float[] floatValues = blockValSet.getFloatValuesSV();
                for (int i = 0; i < length; ++i) {
                    floatSet.add(floatValues[i]);
                }
                break;
            }
            case DOUBLE: {
                DoubleOpenHashSet doubleSet = (DoubleOpenHashSet)valueSet;
                double[] doubleValues = blockValSet.getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    doubleSet.add(doubleValues[i]);
                }
                break;
            }
            case STRING: {
                ObjectOpenHashSet stringSet = (ObjectOpenHashSet)valueSet;
                String[] stringValues = blockValSet.getStringValuesSV();
                for (int i = 0; i < length; ++i) {
                    stringSet.add((Object)stringValues[i]);
                }
                break;
            }
            case BYTES: {
                ObjectOpenHashSet bytesSet = (ObjectOpenHashSet)valueSet;
                byte[][] bytesValues = blockValSet.getBytesValuesSV();
                for (int i = 0; i < length; ++i) {
                    bytesSet.add((Object)new ByteArray(bytesValues[i]));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for DISTINCT_COUNT aggregation function: " + storedType);
            }
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        Dictionary dictionary = blockValSet.getDictionary();
        if (dictionary != null) {
            int[] dictIds = blockValSet.getDictionaryIdsSV();
            for (int i = 0; i < length; ++i) {
                DistinctCountAggregationFunction.getDictIdBitmap(groupByResultHolder, groupKeyArray[i], dictionary).add(dictIds[i]);
            }
            return;
        }
        FieldSpec.DataType storedType = blockValSet.getValueType().getStoredType();
        switch (storedType) {
            case INT: {
                int[] intValues = blockValSet.getIntValuesSV();
                for (int i = 0; i < length; ++i) {
                    ((IntOpenHashSet)DistinctCountAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.INT)).add(intValues[i]);
                }
                break;
            }
            case LONG: {
                long[] longValues = blockValSet.getLongValuesSV();
                for (int i = 0; i < length; ++i) {
                    ((LongOpenHashSet)DistinctCountAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.LONG)).add(longValues[i]);
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = blockValSet.getFloatValuesSV();
                for (int i = 0; i < length; ++i) {
                    ((FloatOpenHashSet)DistinctCountAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.FLOAT)).add(floatValues[i]);
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = blockValSet.getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    ((DoubleOpenHashSet)DistinctCountAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.DOUBLE)).add(doubleValues[i]);
                }
                break;
            }
            case STRING: {
                String[] stringValues = blockValSet.getStringValuesSV();
                for (int i = 0; i < length; ++i) {
                    ((ObjectOpenHashSet)DistinctCountAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.STRING)).add((Object)stringValues[i]);
                }
                break;
            }
            case BYTES: {
                byte[][] bytesValues = blockValSet.getBytesValuesSV();
                for (int i = 0; i < length; ++i) {
                    ((ObjectOpenHashSet)DistinctCountAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.BYTES)).add((Object)new ByteArray(bytesValues[i]));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for DISTINCT_COUNT aggregation function: " + storedType);
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        Dictionary dictionary = blockValSet.getDictionary();
        if (dictionary != null) {
            int[] dictIds = blockValSet.getDictionaryIdsSV();
            for (int i = 0; i < length; ++i) {
                DistinctCountAggregationFunction.setDictIdForGroupKeys(groupByResultHolder, groupKeysArray[i], dictionary, dictIds[i]);
            }
            return;
        }
        FieldSpec.DataType storedType = blockValSet.getValueType().getStoredType();
        switch (storedType) {
            case INT: {
                int[] intValues = blockValSet.getIntValuesSV();
                for (int i = 0; i < length; ++i) {
                    DistinctCountAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], intValues[i]);
                }
                break;
            }
            case LONG: {
                long[] longValues = blockValSet.getLongValuesSV();
                for (int i = 0; i < length; ++i) {
                    DistinctCountAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], longValues[i]);
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = blockValSet.getFloatValuesSV();
                for (int i = 0; i < length; ++i) {
                    DistinctCountAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], floatValues[i]);
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = blockValSet.getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    DistinctCountAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], doubleValues[i]);
                }
                break;
            }
            case STRING: {
                String[] stringValues = blockValSet.getStringValuesSV();
                for (int i = 0; i < length; ++i) {
                    DistinctCountAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], stringValues[i]);
                }
                break;
            }
            case BYTES: {
                byte[][] bytesValues = blockValSet.getBytesValuesSV();
                for (int i = 0; i < length; ++i) {
                    DistinctCountAggregationFunction.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], new ByteArray(bytesValues[i]));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for DISTINCT_COUNT aggregation function: " + storedType);
            }
        }
    }

    @Override
    public Set extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        Object result = aggregationResultHolder.getResult();
        if (result == null) {
            return new IntOpenHashSet();
        }
        if (result instanceof DictIdsWrapper) {
            return DistinctCountAggregationFunction.convertToValueSet((DictIdsWrapper)result);
        }
        return (Set)result;
    }

    @Override
    public Set extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        Object result = groupByResultHolder.getResult(groupKey);
        if (result == null) {
            return new IntOpenHashSet();
        }
        if (result instanceof DictIdsWrapper) {
            return DistinctCountAggregationFunction.convertToValueSet((DictIdsWrapper)result);
        }
        return (Set)result;
    }

    @Override
    public Set merge(Set intermediateResult1, Set intermediateResult2) {
        if (intermediateResult1.isEmpty()) {
            return intermediateResult2;
        }
        if (intermediateResult2.isEmpty()) {
            return intermediateResult1;
        }
        intermediateResult1.addAll(intermediateResult2);
        return intermediateResult1;
    }

    @Override
    public boolean isIntermediateResultComparable() {
        return false;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.INT;
    }

    @Override
    public Integer extractFinalResult(Set intermediateResult) {
        return intermediateResult.size();
    }

    protected static RoaringBitmap getDictIdBitmap(AggregationResultHolder aggregationResultHolder, Dictionary dictionary) {
        DictIdsWrapper dictIdsWrapper = (DictIdsWrapper)aggregationResultHolder.getResult();
        if (dictIdsWrapper == null) {
            dictIdsWrapper = new DictIdsWrapper(dictionary);
            aggregationResultHolder.setValue(dictIdsWrapper);
        }
        return dictIdsWrapper._dictIdBitmap;
    }

    protected static Set getValueSet(AggregationResultHolder aggregationResultHolder, FieldSpec.DataType valueType) {
        Set valueSet = (Set)aggregationResultHolder.getResult();
        if (valueSet == null) {
            valueSet = DistinctCountAggregationFunction.getValueSet(valueType);
            aggregationResultHolder.setValue(valueSet);
        }
        return valueSet;
    }

    private static Set getValueSet(FieldSpec.DataType valueType) {
        switch (valueType) {
            case INT: {
                return new IntOpenHashSet();
            }
            case LONG: {
                return new LongOpenHashSet();
            }
            case FLOAT: {
                return new FloatOpenHashSet();
            }
            case DOUBLE: {
                return new DoubleOpenHashSet();
            }
            case STRING: 
            case BYTES: {
                return new ObjectOpenHashSet();
            }
        }
        throw new IllegalStateException("Illegal data type for DISTINCT_COUNT aggregation function: " + valueType);
    }

    protected static RoaringBitmap getDictIdBitmap(GroupByResultHolder groupByResultHolder, int groupKey, Dictionary dictionary) {
        DictIdsWrapper dictIdsWrapper = (DictIdsWrapper)groupByResultHolder.getResult(groupKey);
        if (dictIdsWrapper == null) {
            dictIdsWrapper = new DictIdsWrapper(dictionary);
            groupByResultHolder.setValueForKey(groupKey, dictIdsWrapper);
        }
        return dictIdsWrapper._dictIdBitmap;
    }

    protected static Set getValueSet(GroupByResultHolder groupByResultHolder, int groupKey, FieldSpec.DataType valueType) {
        Set valueSet = (Set)groupByResultHolder.getResult(groupKey);
        if (valueSet == null) {
            valueSet = DistinctCountAggregationFunction.getValueSet(valueType);
            groupByResultHolder.setValueForKey(groupKey, valueSet);
        }
        return valueSet;
    }

    private static void setDictIdForGroupKeys(GroupByResultHolder groupByResultHolder, int[] groupKeys, Dictionary dictionary, int dictId) {
        for (int groupKey : groupKeys) {
            DistinctCountAggregationFunction.getDictIdBitmap(groupByResultHolder, groupKey, dictionary).add(dictId);
        }
    }

    private static void setValueForGroupKeys(GroupByResultHolder groupByResultHolder, int[] groupKeys, int value) {
        for (int groupKey : groupKeys) {
            ((IntOpenHashSet)DistinctCountAggregationFunction.getValueSet(groupByResultHolder, groupKey, FieldSpec.DataType.INT)).add(value);
        }
    }

    private static void setValueForGroupKeys(GroupByResultHolder groupByResultHolder, int[] groupKeys, long value) {
        for (int groupKey : groupKeys) {
            ((LongOpenHashSet)DistinctCountAggregationFunction.getValueSet(groupByResultHolder, groupKey, FieldSpec.DataType.LONG)).add(value);
        }
    }

    private static void setValueForGroupKeys(GroupByResultHolder groupByResultHolder, int[] groupKeys, float value) {
        for (int groupKey : groupKeys) {
            ((FloatOpenHashSet)DistinctCountAggregationFunction.getValueSet(groupByResultHolder, groupKey, FieldSpec.DataType.FLOAT)).add(value);
        }
    }

    private static void setValueForGroupKeys(GroupByResultHolder groupByResultHolder, int[] groupKeys, double value) {
        for (int groupKey : groupKeys) {
            ((DoubleOpenHashSet)DistinctCountAggregationFunction.getValueSet(groupByResultHolder, groupKey, FieldSpec.DataType.DOUBLE)).add(value);
        }
    }

    private static void setValueForGroupKeys(GroupByResultHolder groupByResultHolder, int[] groupKeys, String value) {
        for (int groupKey : groupKeys) {
            ((ObjectOpenHashSet)DistinctCountAggregationFunction.getValueSet(groupByResultHolder, groupKey, FieldSpec.DataType.STRING)).add((Object)value);
        }
    }

    private static void setValueForGroupKeys(GroupByResultHolder groupByResultHolder, int[] groupKeys, ByteArray value) {
        for (int groupKey : groupKeys) {
            ((ObjectOpenHashSet)DistinctCountAggregationFunction.getValueSet(groupByResultHolder, groupKey, FieldSpec.DataType.BYTES)).add((Object)value);
        }
    }

    private static Set convertToValueSet(DictIdsWrapper dictIdsWrapper) {
        Dictionary dictionary = dictIdsWrapper._dictionary;
        RoaringBitmap dictIdBitmap = dictIdsWrapper._dictIdBitmap;
        int numValues = dictIdBitmap.getCardinality();
        PeekableIntIterator iterator = dictIdBitmap.getIntIterator();
        FieldSpec.DataType storedType = dictionary.getValueType();
        switch (storedType) {
            case INT: {
                IntOpenHashSet intSet = new IntOpenHashSet(numValues);
                while (iterator.hasNext()) {
                    intSet.add(dictionary.getIntValue(iterator.next()));
                }
                return intSet;
            }
            case LONG: {
                LongOpenHashSet longSet = new LongOpenHashSet(numValues);
                while (iterator.hasNext()) {
                    longSet.add(dictionary.getLongValue(iterator.next()));
                }
                return longSet;
            }
            case FLOAT: {
                FloatOpenHashSet floatSet = new FloatOpenHashSet(numValues);
                while (iterator.hasNext()) {
                    floatSet.add(dictionary.getFloatValue(iterator.next()));
                }
                return floatSet;
            }
            case DOUBLE: {
                DoubleOpenHashSet doubleSet = new DoubleOpenHashSet(numValues);
                while (iterator.hasNext()) {
                    doubleSet.add(dictionary.getDoubleValue(iterator.next()));
                }
                return doubleSet;
            }
            case STRING: {
                ObjectOpenHashSet stringSet = new ObjectOpenHashSet(numValues);
                while (iterator.hasNext()) {
                    stringSet.add((Object)dictionary.getStringValue(iterator.next()));
                }
                return stringSet;
            }
            case BYTES: {
                ObjectOpenHashSet bytesSet = new ObjectOpenHashSet(numValues);
                while (iterator.hasNext()) {
                    bytesSet.add((Object)new ByteArray(dictionary.getBytesValue(iterator.next())));
                }
                return bytesSet;
            }
        }
        throw new IllegalStateException("Illegal data type for DISTINCT_COUNT aggregation function: " + storedType);
    }

    private static final class DictIdsWrapper {
        final Dictionary _dictionary;
        final RoaringBitmap _dictIdBitmap;

        private DictIdsWrapper(Dictionary dictionary) {
            this._dictionary = dictionary;
            this._dictIdBitmap = new RoaringBitmap();
        }
    }
}

