/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.BaseSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.RoaringBitmap;

public class DistinctCountBitmapAggregationFunction
extends BaseSingleInputAggregationFunction<RoaringBitmap, Integer> {
    public DistinctCountBitmapAggregationFunction(ExpressionContext expression) {
        super(expression);
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.DISTINCTCOUNTBITMAP;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        FieldSpec.DataType storedType = blockValSet.getValueType().getStoredType();
        if (storedType == FieldSpec.DataType.BYTES) {
            byte[][] bytesValues = blockValSet.getBytesValuesSV();
            RoaringBitmap valueBitmap = (RoaringBitmap)aggregationResultHolder.getResult();
            if (valueBitmap != null) {
                for (int i = 0; i < length; ++i) {
                    valueBitmap.or(ObjectSerDeUtils.ROARING_BITMAP_SER_DE.deserialize(bytesValues[i]));
                }
            } else {
                valueBitmap = ObjectSerDeUtils.ROARING_BITMAP_SER_DE.deserialize(bytesValues[0]);
                aggregationResultHolder.setValue(valueBitmap);
                for (int i = 1; i < length; ++i) {
                    valueBitmap.or(ObjectSerDeUtils.ROARING_BITMAP_SER_DE.deserialize(bytesValues[i]));
                }
            }
            return;
        }
        Dictionary dictionary = blockValSet.getDictionary();
        if (dictionary != null) {
            int[] dictIds = blockValSet.getDictionaryIdsSV();
            DistinctCountBitmapAggregationFunction.getDictIdBitmap(aggregationResultHolder, dictionary).addN(dictIds, 0, length);
            return;
        }
        RoaringBitmap valueBitmap = DistinctCountBitmapAggregationFunction.getValueBitmap(aggregationResultHolder);
        switch (storedType) {
            case INT: {
                int[] intValues = blockValSet.getIntValuesSV();
                valueBitmap.addN(intValues, 0, length);
                break;
            }
            case LONG: {
                long[] longValues = blockValSet.getLongValuesSV();
                for (int i = 0; i < length; ++i) {
                    valueBitmap.add(Long.hashCode(longValues[i]));
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = blockValSet.getFloatValuesSV();
                for (int i = 0; i < length; ++i) {
                    valueBitmap.add(Float.hashCode(floatValues[i]));
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = blockValSet.getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    valueBitmap.add(Double.hashCode(doubleValues[i]));
                }
                break;
            }
            case STRING: {
                String[] stringValues = blockValSet.getStringValuesSV();
                for (int i = 0; i < length; ++i) {
                    valueBitmap.add(stringValues[i].hashCode());
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for DISTINCT_COUNT_BITMAP aggregation function: " + storedType);
            }
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        FieldSpec.DataType storedType = blockValSet.getValueType().getStoredType();
        if (storedType == FieldSpec.DataType.BYTES) {
            byte[][] bytesValues = blockValSet.getBytesValuesSV();
            for (int i = 0; i < length; ++i) {
                RoaringBitmap value = ObjectSerDeUtils.ROARING_BITMAP_SER_DE.deserialize(bytesValues[i]);
                int groupKey = groupKeyArray[i];
                RoaringBitmap valueBitmap = (RoaringBitmap)groupByResultHolder.getResult(groupKey);
                if (valueBitmap != null) {
                    valueBitmap.or(value);
                    continue;
                }
                groupByResultHolder.setValueForKey(groupKey, value);
            }
            return;
        }
        Dictionary dictionary = blockValSet.getDictionary();
        if (dictionary != null) {
            int[] dictIds = blockValSet.getDictionaryIdsSV();
            for (int i = 0; i < length; ++i) {
                DistinctCountBitmapAggregationFunction.getDictIdBitmap(groupByResultHolder, groupKeyArray[i], dictionary).add(dictIds[i]);
            }
            return;
        }
        switch (storedType) {
            case INT: {
                int[] intValues = blockValSet.getIntValuesSV();
                for (int i = 0; i < length; ++i) {
                    DistinctCountBitmapAggregationFunction.getValueBitmap(groupByResultHolder, groupKeyArray[i]).add(intValues[i]);
                }
                break;
            }
            case LONG: {
                long[] longValues = blockValSet.getLongValuesSV();
                for (int i = 0; i < length; ++i) {
                    DistinctCountBitmapAggregationFunction.getValueBitmap(groupByResultHolder, groupKeyArray[i]).add(Long.hashCode(longValues[i]));
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = blockValSet.getFloatValuesSV();
                for (int i = 0; i < length; ++i) {
                    DistinctCountBitmapAggregationFunction.getValueBitmap(groupByResultHolder, groupKeyArray[i]).add(Float.hashCode(floatValues[i]));
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = blockValSet.getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    DistinctCountBitmapAggregationFunction.getValueBitmap(groupByResultHolder, groupKeyArray[i]).add(Double.hashCode(doubleValues[i]));
                }
                break;
            }
            case STRING: {
                String[] stringValues = blockValSet.getStringValuesSV();
                for (int i = 0; i < length; ++i) {
                    DistinctCountBitmapAggregationFunction.getValueBitmap(groupByResultHolder, groupKeyArray[i]).add(stringValues[i].hashCode());
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for DISTINCT_COUNT_BITMAP aggregation function: " + storedType);
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        FieldSpec.DataType storedType = blockValSet.getValueType().getStoredType();
        if (storedType == FieldSpec.DataType.BYTES) {
            byte[][] bytesValues = blockValSet.getBytesValuesSV();
            for (int i = 0; i < length; ++i) {
                RoaringBitmap value = ObjectSerDeUtils.ROARING_BITMAP_SER_DE.deserialize(bytesValues[i]);
                for (int groupKey : groupKeysArray[i]) {
                    RoaringBitmap bitmap = (RoaringBitmap)groupByResultHolder.getResult(groupKey);
                    if (bitmap != null) {
                        bitmap.or(value);
                        continue;
                    }
                    groupByResultHolder.setValueForKey(groupKey, value.clone());
                }
            }
            return;
        }
        Dictionary dictionary = blockValSet.getDictionary();
        if (dictionary != null) {
            int[] dictIds = blockValSet.getDictionaryIdsSV();
            for (int i = 0; i < length; ++i) {
                DistinctCountBitmapAggregationFunction.setDictIdForGroupKeys(groupByResultHolder, groupKeysArray[i], dictionary, dictIds[i]);
            }
            return;
        }
        switch (storedType) {
            case INT: {
                int[] intValues = blockValSet.getIntValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], intValues[i]);
                }
                break;
            }
            case LONG: {
                long[] longValues = blockValSet.getLongValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], Long.hashCode(longValues[i]));
                }
                break;
            }
            case FLOAT: {
                float[] floatValues = blockValSet.getFloatValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], Float.hashCode(floatValues[i]));
                }
                break;
            }
            case DOUBLE: {
                double[] doubleValues = blockValSet.getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], Double.hashCode(doubleValues[i]));
                }
                break;
            }
            case STRING: {
                String[] stringValues = blockValSet.getStringValuesSV();
                for (int i = 0; i < length; ++i) {
                    this.setValueForGroupKeys(groupByResultHolder, groupKeysArray[i], stringValues[i].hashCode());
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for DISTINCT_COUNT_BITMAP aggregation function: " + storedType);
            }
        }
    }

    @Override
    public RoaringBitmap extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        Object result = aggregationResultHolder.getResult();
        if (result == null) {
            return new RoaringBitmap();
        }
        if (result instanceof DictIdsWrapper) {
            return DistinctCountBitmapAggregationFunction.convertToValueBitmap((DictIdsWrapper)result);
        }
        return (RoaringBitmap)result;
    }

    @Override
    public RoaringBitmap extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        Object result = groupByResultHolder.getResult(groupKey);
        if (result == null) {
            return new RoaringBitmap();
        }
        if (result instanceof DictIdsWrapper) {
            return DistinctCountBitmapAggregationFunction.convertToValueBitmap((DictIdsWrapper)result);
        }
        return (RoaringBitmap)result;
    }

    @Override
    public RoaringBitmap merge(RoaringBitmap intermediateResult1, RoaringBitmap intermediateResult2) {
        intermediateResult1.or(intermediateResult2);
        return intermediateResult1;
    }

    @Override
    public boolean isIntermediateResultComparable() {
        return false;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.INT;
    }

    @Override
    public Integer extractFinalResult(RoaringBitmap intermediateResult) {
        return intermediateResult.getCardinality();
    }

    protected static RoaringBitmap getDictIdBitmap(AggregationResultHolder aggregationResultHolder, Dictionary dictionary) {
        DictIdsWrapper dictIdsWrapper = (DictIdsWrapper)aggregationResultHolder.getResult();
        if (dictIdsWrapper == null) {
            dictIdsWrapper = new DictIdsWrapper(dictionary);
            aggregationResultHolder.setValue(dictIdsWrapper);
        }
        return dictIdsWrapper._dictIdBitmap;
    }

    protected static RoaringBitmap getValueBitmap(AggregationResultHolder aggregationResultHolder) {
        RoaringBitmap bitmap = (RoaringBitmap)aggregationResultHolder.getResult();
        if (bitmap == null) {
            bitmap = new RoaringBitmap();
            aggregationResultHolder.setValue(bitmap);
        }
        return bitmap;
    }

    protected static RoaringBitmap getDictIdBitmap(GroupByResultHolder groupByResultHolder, int groupKey, Dictionary dictionary) {
        DictIdsWrapper dictIdsWrapper = (DictIdsWrapper)groupByResultHolder.getResult(groupKey);
        if (dictIdsWrapper == null) {
            dictIdsWrapper = new DictIdsWrapper(dictionary);
            groupByResultHolder.setValueForKey(groupKey, dictIdsWrapper);
        }
        return dictIdsWrapper._dictIdBitmap;
    }

    protected static RoaringBitmap getValueBitmap(GroupByResultHolder groupByResultHolder, int groupKey) {
        RoaringBitmap bitmap = (RoaringBitmap)groupByResultHolder.getResult(groupKey);
        if (bitmap == null) {
            bitmap = new RoaringBitmap();
            groupByResultHolder.setValueForKey(groupKey, bitmap);
        }
        return bitmap;
    }

    private static void setDictIdForGroupKeys(GroupByResultHolder groupByResultHolder, int[] groupKeys, Dictionary dictionary, int dictId) {
        for (int groupKey : groupKeys) {
            DistinctCountBitmapAggregationFunction.getDictIdBitmap(groupByResultHolder, groupKey, dictionary).add(dictId);
        }
    }

    private void setValueForGroupKeys(GroupByResultHolder groupByResultHolder, int[] groupKeys, int value) {
        for (int groupKey : groupKeys) {
            DistinctCountBitmapAggregationFunction.getValueBitmap(groupByResultHolder, groupKey).add(value);
        }
    }

    private static RoaringBitmap convertToValueBitmap(DictIdsWrapper dictIdsWrapper) {
        Dictionary dictionary = dictIdsWrapper._dictionary;
        RoaringBitmap dictIdBitmap = dictIdsWrapper._dictIdBitmap;
        RoaringBitmap valueBitmap = new RoaringBitmap();
        PeekableIntIterator iterator = dictIdBitmap.getIntIterator();
        FieldSpec.DataType storedType = dictionary.getValueType();
        switch (storedType) {
            case INT: {
                while (iterator.hasNext()) {
                    valueBitmap.add(dictionary.getIntValue(iterator.next()));
                }
                break;
            }
            case LONG: {
                while (iterator.hasNext()) {
                    valueBitmap.add(Long.hashCode(dictionary.getLongValue(iterator.next())));
                }
                break;
            }
            case FLOAT: {
                while (iterator.hasNext()) {
                    valueBitmap.add(Float.hashCode(dictionary.getFloatValue(iterator.next())));
                }
                break;
            }
            case DOUBLE: {
                while (iterator.hasNext()) {
                    valueBitmap.add(Double.hashCode(dictionary.getDoubleValue(iterator.next())));
                }
                break;
            }
            case STRING: {
                while (iterator.hasNext()) {
                    valueBitmap.add(dictionary.getStringValue(iterator.next()).hashCode());
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for DISTINCT_COUNT_BITMAP aggregation function: " + storedType);
            }
        }
        return valueBitmap;
    }

    private static final class DictIdsWrapper {
        final Dictionary _dictionary;
        final RoaringBitmap _dictIdBitmap;

        private DictIdsWrapper(Dictionary dictionary) {
            this._dictionary = dictionary;
            this._dictIdBitmap = new RoaringBitmap();
        }
    }
}

