/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.DistinctCountBitmapAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.RoaringBitmap;

public class DistinctCountBitmapMVAggregationFunction
extends DistinctCountBitmapAggregationFunction {
    public DistinctCountBitmapMVAggregationFunction(ExpressionContext expression) {
        super(expression);
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.DISTINCTCOUNTBITMAPMV;
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        Dictionary dictionary = blockValSet.getDictionary();
        if (dictionary != null) {
            RoaringBitmap dictIdBitmap = DistinctCountBitmapMVAggregationFunction.getDictIdBitmap(aggregationResultHolder, dictionary);
            int[][] dictIds = blockValSet.getDictionaryIdsMV();
            for (int i = 0; i < length; ++i) {
                dictIdBitmap.add(dictIds[i]);
            }
            return;
        }
        RoaringBitmap valueBitmap = DistinctCountBitmapMVAggregationFunction.getValueBitmap(aggregationResultHolder);
        FieldSpec.DataType storedType = blockValSet.getValueType().getStoredType();
        switch (storedType) {
            case INT: {
                int[][] intValues = blockValSet.getIntValuesMV();
                for (int i = 0; i < length; ++i) {
                    valueBitmap.add(intValues[i]);
                }
                break;
            }
            case LONG: {
                long[][] longValues = blockValSet.getLongValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (long value : longValues[i]) {
                        valueBitmap.add(Long.hashCode(value));
                    }
                }
                break;
            }
            case FLOAT: {
                float[][] floatValues = blockValSet.getFloatValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (float value : floatValues[i]) {
                        valueBitmap.add(Float.hashCode(value));
                    }
                }
            }
            case DOUBLE: {
                double[][] doubleValues = blockValSet.getDoubleValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (double value : doubleValues[i]) {
                        valueBitmap.add(Double.hashCode(value));
                    }
                }
                break;
            }
            case STRING: {
                String[][] stringValues = blockValSet.getStringValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (String value : stringValues[i]) {
                        valueBitmap.add(value.hashCode());
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for DISTINCT_COUNT_BITMAP_MV aggregation function: " + storedType);
            }
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        Dictionary dictionary = blockValSet.getDictionary();
        if (dictionary != null) {
            int[][] dictIds = blockValSet.getDictionaryIdsMV();
            for (int i = 0; i < length; ++i) {
                DistinctCountBitmapMVAggregationFunction.getDictIdBitmap(groupByResultHolder, groupKeyArray[i], dictionary).add(dictIds[i]);
            }
            return;
        }
        FieldSpec.DataType storedType = blockValSet.getValueType().getStoredType();
        switch (storedType) {
            case INT: {
                int[][] intValues = blockValSet.getIntValuesMV();
                for (int i = 0; i < length; ++i) {
                    DistinctCountBitmapMVAggregationFunction.getValueBitmap(groupByResultHolder, groupKeyArray[i]).add(intValues[i]);
                }
                break;
            }
            case LONG: {
                long[][] longValues = blockValSet.getLongValuesMV();
                for (int i = 0; i < length; ++i) {
                    RoaringBitmap bitmap = DistinctCountBitmapMVAggregationFunction.getValueBitmap(groupByResultHolder, groupKeyArray[i]);
                    for (long value : longValues[i]) {
                        bitmap.add(Long.hashCode(value));
                    }
                }
                break;
            }
            case FLOAT: {
                float[][] floatValues = blockValSet.getFloatValuesMV();
                for (int i = 0; i < length; ++i) {
                    RoaringBitmap bitmap = DistinctCountBitmapMVAggregationFunction.getValueBitmap(groupByResultHolder, groupKeyArray[i]);
                    for (float value : floatValues[i]) {
                        bitmap.add(Float.hashCode(value));
                    }
                }
                break;
            }
            case DOUBLE: {
                double[][] doubleValues = blockValSet.getDoubleValuesMV();
                for (int i = 0; i < length; ++i) {
                    RoaringBitmap bitmap = DistinctCountBitmapMVAggregationFunction.getValueBitmap(groupByResultHolder, groupKeyArray[i]);
                    for (double value : doubleValues[i]) {
                        bitmap.add(Double.hashCode(value));
                    }
                }
                break;
            }
            case STRING: {
                String[][] stringValues = blockValSet.getStringValuesMV();
                for (int i = 0; i < length; ++i) {
                    RoaringBitmap bitmap = DistinctCountBitmapMVAggregationFunction.getValueBitmap(groupByResultHolder, groupKeyArray[i]);
                    for (String value : stringValues[i]) {
                        bitmap.add(value.hashCode());
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for DISTINCT_COUNT_BITMAP_MV aggregation function: " + storedType);
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        Dictionary dictionary = blockValSet.getDictionary();
        if (dictionary != null) {
            int[][] dictIds = blockValSet.getDictionaryIdsMV();
            for (int i = 0; i < length; ++i) {
                for (int groupKey : groupKeysArray[i]) {
                    DistinctCountBitmapMVAggregationFunction.getDictIdBitmap(groupByResultHolder, groupKey, dictionary).add(dictIds[i]);
                }
            }
            return;
        }
        FieldSpec.DataType storedType = blockValSet.getValueType().getStoredType();
        switch (storedType) {
            case INT: {
                int[][] intValues = blockValSet.getIntValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (int groupKey : groupKeysArray[i]) {
                        DistinctCountBitmapMVAggregationFunction.getValueBitmap(groupByResultHolder, groupKey).add(intValues[i]);
                    }
                }
                break;
            }
            case LONG: {
                long[][] longValues = blockValSet.getLongValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (int groupKey : groupKeysArray[i]) {
                        RoaringBitmap bitmap = DistinctCountBitmapMVAggregationFunction.getValueBitmap(groupByResultHolder, groupKey);
                        for (long value : longValues[i]) {
                            bitmap.add(Long.hashCode(value));
                        }
                    }
                }
                break;
            }
            case FLOAT: {
                float[][] floatValues = blockValSet.getFloatValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (int groupKey : groupKeysArray[i]) {
                        RoaringBitmap bitmap = DistinctCountBitmapMVAggregationFunction.getValueBitmap(groupByResultHolder, groupKey);
                        for (float value : floatValues[i]) {
                            bitmap.add(Float.hashCode(value));
                        }
                    }
                }
                break;
            }
            case DOUBLE: {
                double[][] doubleValues = blockValSet.getDoubleValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (int groupKey : groupKeysArray[i]) {
                        RoaringBitmap bitmap = DistinctCountBitmapMVAggregationFunction.getValueBitmap(groupByResultHolder, groupKey);
                        for (double value : doubleValues[i]) {
                            bitmap.add(Double.hashCode(value));
                        }
                    }
                }
                break;
            }
            case STRING: {
                String[][] stringValues = blockValSet.getStringValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (int groupKey : groupKeysArray[i]) {
                        RoaringBitmap bitmap = DistinctCountBitmapMVAggregationFunction.getValueBitmap(groupByResultHolder, groupKey);
                        for (String value : stringValues[i]) {
                            bitmap.add(value.hashCode());
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for DISTINCT_COUNT_BITMAP_MV aggregation function: " + storedType);
            }
        }
    }
}

