/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import it.unimi.dsi.fastutil.floats.FloatOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.DistinctCountAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.RoaringBitmap;

public class DistinctCountMVAggregationFunction
extends DistinctCountAggregationFunction {
    public DistinctCountMVAggregationFunction(ExpressionContext expression) {
        super(expression);
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.DISTINCTCOUNTMV;
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        Dictionary dictionary = blockValSet.getDictionary();
        if (dictionary != null) {
            RoaringBitmap dictIdBitmap = DistinctCountMVAggregationFunction.getDictIdBitmap(aggregationResultHolder, dictionary);
            int[][] dictIds = blockValSet.getDictionaryIdsMV();
            for (int i = 0; i < length; ++i) {
                dictIdBitmap.add(dictIds[i]);
            }
            return;
        }
        FieldSpec.DataType storedType = blockValSet.getValueType().getStoredType();
        Set valueSet = DistinctCountMVAggregationFunction.getValueSet(aggregationResultHolder, storedType);
        switch (storedType) {
            case INT: {
                IntOpenHashSet intSet = (IntOpenHashSet)valueSet;
                int[][] intValues = blockValSet.getIntValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (int value : intValues[i]) {
                        intSet.add(value);
                    }
                }
                break;
            }
            case LONG: {
                LongOpenHashSet longSet = (LongOpenHashSet)valueSet;
                long[][] longValues = blockValSet.getLongValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (long value : longValues[i]) {
                        longSet.add(value);
                    }
                }
                break;
            }
            case FLOAT: {
                FloatOpenHashSet floatSet = (FloatOpenHashSet)valueSet;
                float[][] floatValues = blockValSet.getFloatValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (float value : floatValues[i]) {
                        floatSet.add(value);
                    }
                }
            }
            case DOUBLE: {
                DoubleOpenHashSet doubleSet = (DoubleOpenHashSet)valueSet;
                double[][] doubleValues = blockValSet.getDoubleValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (double value : doubleValues[i]) {
                        doubleSet.add(value);
                    }
                }
                break;
            }
            case STRING: {
                ObjectOpenHashSet stringSet = (ObjectOpenHashSet)valueSet;
                String[][] stringValues = blockValSet.getStringValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (String value : stringValues[i]) {
                        stringSet.add((Object)value);
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for DISTINCT_COUNT_MV aggregation function: " + storedType);
            }
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        Dictionary dictionary = blockValSet.getDictionary();
        if (dictionary != null) {
            int[][] dictIds = blockValSet.getDictionaryIdsMV();
            for (int i = 0; i < length; ++i) {
                DistinctCountMVAggregationFunction.getDictIdBitmap(groupByResultHolder, groupKeyArray[i], dictionary).add(dictIds[i]);
            }
            return;
        }
        FieldSpec.DataType storedType = blockValSet.getValueType().getStoredType();
        switch (storedType) {
            case INT: {
                int[][] intValues = blockValSet.getIntValuesMV();
                for (int i = 0; i < length; ++i) {
                    IntOpenHashSet intSet = (IntOpenHashSet)DistinctCountMVAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.INT);
                    for (int value : intValues[i]) {
                        intSet.add(value);
                    }
                }
                break;
            }
            case LONG: {
                long[][] longValues = blockValSet.getLongValuesMV();
                for (int i = 0; i < length; ++i) {
                    LongOpenHashSet longSet = (LongOpenHashSet)DistinctCountMVAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.LONG);
                    for (long value : longValues[i]) {
                        longSet.add(value);
                    }
                }
                break;
            }
            case FLOAT: {
                float[][] floatValues = blockValSet.getFloatValuesMV();
                for (int i = 0; i < length; ++i) {
                    FloatOpenHashSet floatSet = (FloatOpenHashSet)DistinctCountMVAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.FLOAT);
                    for (float value : floatValues[i]) {
                        floatSet.add(value);
                    }
                }
                break;
            }
            case DOUBLE: {
                double[][] doubleValues = blockValSet.getDoubleValuesMV();
                for (int i = 0; i < length; ++i) {
                    DoubleOpenHashSet doubleSet = (DoubleOpenHashSet)DistinctCountMVAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.DOUBLE);
                    for (double value : doubleValues[i]) {
                        doubleSet.add(value);
                    }
                }
                break;
            }
            case STRING: {
                String[][] stringValues = blockValSet.getStringValuesMV();
                for (int i = 0; i < length; ++i) {
                    ObjectOpenHashSet stringSet = (ObjectOpenHashSet)DistinctCountMVAggregationFunction.getValueSet(groupByResultHolder, groupKeyArray[i], FieldSpec.DataType.STRING);
                    for (String value : stringValues[i]) {
                        stringSet.add((Object)value);
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for DISTINCT_COUNT_MV aggregation function: " + storedType);
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        Dictionary dictionary = blockValSet.getDictionary();
        if (dictionary != null) {
            int[][] dictIds = blockValSet.getDictionaryIdsMV();
            for (int i = 0; i < length; ++i) {
                for (int groupKey : groupKeysArray[i]) {
                    DistinctCountMVAggregationFunction.getDictIdBitmap(groupByResultHolder, groupKey, dictionary).add(dictIds[i]);
                }
            }
            return;
        }
        FieldSpec.DataType storedType = blockValSet.getValueType().getStoredType();
        switch (storedType) {
            case INT: {
                int[][] intValues = blockValSet.getIntValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (int groupKey : groupKeysArray[i]) {
                        IntOpenHashSet intSet = (IntOpenHashSet)DistinctCountMVAggregationFunction.getValueSet(groupByResultHolder, groupKey, FieldSpec.DataType.INT);
                        for (int value : intValues[i]) {
                            intSet.add(value);
                        }
                    }
                }
                break;
            }
            case LONG: {
                long[][] longValues = blockValSet.getLongValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (int groupKey : groupKeysArray[i]) {
                        LongOpenHashSet longSet = (LongOpenHashSet)DistinctCountMVAggregationFunction.getValueSet(groupByResultHolder, groupKey, FieldSpec.DataType.LONG);
                        for (long value : longValues[i]) {
                            longSet.add(value);
                        }
                    }
                }
                break;
            }
            case FLOAT: {
                float[][] floatValues = blockValSet.getFloatValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (int groupKey : groupKeysArray[i]) {
                        FloatOpenHashSet floatSet = (FloatOpenHashSet)DistinctCountMVAggregationFunction.getValueSet(groupByResultHolder, groupKey, FieldSpec.DataType.FLOAT);
                        for (float value : floatValues[i]) {
                            floatSet.add(value);
                        }
                    }
                }
                break;
            }
            case DOUBLE: {
                double[][] doubleValues = blockValSet.getDoubleValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (int groupKey : groupKeysArray[i]) {
                        DoubleOpenHashSet doubleSet = (DoubleOpenHashSet)DistinctCountMVAggregationFunction.getValueSet(groupByResultHolder, groupKey, FieldSpec.DataType.DOUBLE);
                        for (double value : doubleValues[i]) {
                            doubleSet.add(value);
                        }
                    }
                }
                break;
            }
            case STRING: {
                String[][] stringValues = blockValSet.getStringValuesMV();
                for (int i = 0; i < length; ++i) {
                    for (int groupKey : groupKeysArray[i]) {
                        ObjectOpenHashSet stringSet = (ObjectOpenHashSet)DistinctCountMVAggregationFunction.getValueSet(groupByResultHolder, groupKey, FieldSpec.DataType.STRING);
                        for (String value : stringValues[i]) {
                            stringSet.add((Object)value);
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException("Illegal data type for DISTINCT_COUNT_MV aggregation function: " + storedType);
            }
        }
    }
}

