/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import com.clearspring.analytics.stream.cardinality.HyperLogLog;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.BaseSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.segment.spi.AggregationFunctionType;

@Deprecated
public class FastHLLAggregationFunction
extends BaseSingleInputAggregationFunction<HyperLogLog, Long> {
    public static final int DEFAULT_LOG2M = 8;
    private static final int BYTE_TO_CHAR_OFFSET = 129;

    public FastHLLAggregationFunction(ExpressionContext expression) {
        super(expression);
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.FASTHLL;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        String[] values = blockValSetMap.get(this._expression).getStringValuesSV();
        try {
            HyperLogLog hyperLogLog = (HyperLogLog)aggregationResultHolder.getResult();
            if (hyperLogLog != null) {
                for (int i = 0; i < length; ++i) {
                    hyperLogLog.addAll(FastHLLAggregationFunction.convertStringToHLL(values[i]));
                }
            } else {
                hyperLogLog = FastHLLAggregationFunction.convertStringToHLL(values[0]);
                aggregationResultHolder.setValue(hyperLogLog);
                for (int i = 1; i < length; ++i) {
                    hyperLogLog.addAll(FastHLLAggregationFunction.convertStringToHLL(values[i]));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while merging HyperLogLogs", e);
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        String[] values = blockValSetMap.get(this._expression).getStringValuesSV();
        try {
            for (int i = 0; i < length; ++i) {
                HyperLogLog value = FastHLLAggregationFunction.convertStringToHLL(values[i]);
                int groupKey = groupKeyArray[i];
                HyperLogLog hyperLogLog = (HyperLogLog)groupByResultHolder.getResult(groupKey);
                if (hyperLogLog != null) {
                    hyperLogLog.addAll(value);
                    continue;
                }
                groupByResultHolder.setValueForKey(groupKey, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while merging HyperLogLogs", e);
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        String[] values = blockValSetMap.get(this._expression).getStringValuesSV();
        try {
            for (int i = 0; i < length; ++i) {
                HyperLogLog value = FastHLLAggregationFunction.convertStringToHLL(values[i]);
                for (int groupKey : groupKeysArray[i]) {
                    HyperLogLog hyperLogLog = (HyperLogLog)groupByResultHolder.getResult(groupKey);
                    if (hyperLogLog != null) {
                        hyperLogLog.addAll(value);
                        continue;
                    }
                    groupByResultHolder.setValueForKey(groupKey, FastHLLAggregationFunction.convertStringToHLL(values[i]));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while merging HyperLogLogs", e);
        }
    }

    @Override
    public HyperLogLog extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        HyperLogLog hyperLogLog = (HyperLogLog)aggregationResultHolder.getResult();
        if (hyperLogLog == null) {
            return new HyperLogLog(8);
        }
        return hyperLogLog;
    }

    @Override
    public HyperLogLog extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        HyperLogLog hyperLogLog = (HyperLogLog)groupByResultHolder.getResult(groupKey);
        if (hyperLogLog == null) {
            return new HyperLogLog(8);
        }
        return hyperLogLog;
    }

    @Override
    public HyperLogLog merge(HyperLogLog intermediateResult1, HyperLogLog intermediateResult2) {
        if (intermediateResult1.sizeof() != intermediateResult2.sizeof()) {
            if (intermediateResult1.cardinality() == 0L) {
                return intermediateResult2;
            }
            Preconditions.checkState((intermediateResult2.cardinality() == 0L ? 1 : 0) != 0, (Object)"Cannot merge HyperLogLogs of different sizes");
            return intermediateResult1;
        }
        try {
            intermediateResult1.addAll(intermediateResult2);
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while merging HyperLogLog", e);
        }
        return intermediateResult1;
    }

    @Override
    public boolean isIntermediateResultComparable() {
        return false;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.LONG;
    }

    @Override
    public Long extractFinalResult(HyperLogLog intermediateResult) {
        return intermediateResult.cardinality();
    }

    private static HyperLogLog convertStringToHLL(String value) {
        char[] chars = value.toCharArray();
        int length = chars.length;
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)(chars[i] - 129);
        }
        return ObjectSerDeUtils.HYPER_LOG_LOG_SER_DE.deserialize(bytes);
    }
}

