/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.BaseSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.segment.local.utils.GeometrySerializer;
import org.apache.pinot.segment.local.utils.GeometryUtils;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.utils.ByteArray;
import org.locationtech.jts.geom.Geometry;

public class StUnionAggregationFunction
extends BaseSingleInputAggregationFunction<Geometry, ByteArray> {
    public StUnionAggregationFunction(ExpressionContext expression) {
        super(expression);
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.STUNION;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        byte[][] bytesArray = blockValSetMap.get(this._expression).getBytesValuesSV();
        Geometry geometry = (Geometry)aggregationResultHolder.getResult();
        for (int i = 0; i < length; ++i) {
            Geometry value = GeometrySerializer.deserialize((byte[])bytesArray[i]);
            geometry = geometry == null ? value : geometry.union(value);
        }
        aggregationResultHolder.setValue(geometry);
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        byte[][] bytesArray = blockValSetMap.get(this._expression).getBytesValuesSV();
        for (int i = 0; i < length; ++i) {
            int groupKey = groupKeyArray[i];
            Geometry value = GeometrySerializer.deserialize((byte[])bytesArray[i]);
            Geometry geometry = (Geometry)groupByResultHolder.getResult(groupKey);
            groupByResultHolder.setValueForKey(groupKey, geometry == null ? value : geometry.union(value));
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        byte[][] bytesArray = blockValSetMap.get(this._expression).getBytesValuesSV();
        for (int i = 0; i < length; ++i) {
            Geometry value = GeometrySerializer.deserialize((byte[])bytesArray[i]);
            int[] nArray = groupKeysArray[i];
            int n = nArray.length;
            for (int j = 0; j < n; ++j) {
                int groupKey;
                Geometry geometry = (Geometry)groupByResultHolder.getResult(groupKey = nArray[j]);
                groupByResultHolder.setValueForKey(groupKey, geometry == null ? value : geometry.union(value));
            }
        }
    }

    @Override
    public Geometry extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        Geometry geometry = (Geometry)aggregationResultHolder.getResult();
        return geometry == null ? GeometryUtils.EMPTY_POINT : geometry;
    }

    @Override
    public Geometry extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        Geometry geometry = (Geometry)groupByResultHolder.getResult(groupKey);
        return geometry == null ? GeometryUtils.EMPTY_POINT : geometry;
    }

    @Override
    public Geometry merge(Geometry intermediateResult1, Geometry intermediateResult2) {
        return intermediateResult1.union(intermediateResult2);
    }

    @Override
    public boolean isIntermediateResultComparable() {
        return false;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.BYTES;
    }

    @Override
    public ByteArray extractFinalResult(Geometry geometry) {
        return new ByteArray(GeometrySerializer.serialize((Geometry)geometry));
    }
}

