/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.groupby;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.query.aggregation.groupby.GroupKeyGenerator;
import org.apache.pinot.core.query.aggregation.groupby.utils.ValueToIdMap;
import org.apache.pinot.core.query.aggregation.groupby.utils.ValueToIdMapFactory;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.FixedIntArray;

public class NoDictionaryMultiColumnGroupKeyGenerator
implements GroupKeyGenerator {
    private final ExpressionContext[] _groupByExpressions;
    private final int _numGroupByExpressions;
    private final FieldSpec.DataType[] _storedTypes;
    private final Dictionary[] _dictionaries;
    private final ValueToIdMap[] _onTheFlyDictionaries;
    private final Object2IntOpenHashMap<FixedIntArray> _groupKeyMap;
    private final boolean[] _isSingleValueExpressions;
    private final int _globalGroupIdUpperBound;
    private int _numGroups = 0;

    public NoDictionaryMultiColumnGroupKeyGenerator(TransformOperator transformOperator, ExpressionContext[] groupByExpressions, int numGroupsLimit) {
        this._groupByExpressions = groupByExpressions;
        this._numGroupByExpressions = groupByExpressions.length;
        this._storedTypes = new FieldSpec.DataType[this._numGroupByExpressions];
        this._dictionaries = new Dictionary[this._numGroupByExpressions];
        this._onTheFlyDictionaries = new ValueToIdMap[this._numGroupByExpressions];
        this._isSingleValueExpressions = new boolean[this._numGroupByExpressions];
        for (int i = 0; i < this._numGroupByExpressions; ++i) {
            ExpressionContext groupByExpression = groupByExpressions[i];
            TransformResultMetadata transformResultMetadata = transformOperator.getResultMetadata(groupByExpression);
            this._storedTypes[i] = transformResultMetadata.getDataType().getStoredType();
            if (transformResultMetadata.hasDictionary()) {
                this._dictionaries[i] = transformOperator.getDictionary(groupByExpression);
            } else {
                this._onTheFlyDictionaries[i] = ValueToIdMapFactory.get(this._storedTypes[i]);
            }
            this._isSingleValueExpressions[i] = transformResultMetadata.isSingleValue();
        }
        this._groupKeyMap = new Object2IntOpenHashMap();
        this._groupKeyMap.defaultReturnValue(-1);
        this._globalGroupIdUpperBound = numGroupsLimit;
    }

    @Override
    public int getGlobalGroupKeyUpperBound() {
        return this._globalGroupIdUpperBound;
    }

    @Override
    public void generateKeysForBlock(TransformBlock transformBlock, int[] groupKeys) {
        int i;
        int numDocs = transformBlock.getNumDocs();
        int[][] keys = new int[numDocs][this._numGroupByExpressions];
        block8: for (i = 0; i < this._numGroupByExpressions; ++i) {
            BlockValSet blockValSet = transformBlock.getBlockValueSet(this._groupByExpressions[i]);
            if (this._dictionaries[i] != null) {
                int[] dictIds = blockValSet.getDictionaryIdsSV();
                for (int j = 0; j < numDocs; ++j) {
                    keys[j][i] = dictIds[j];
                }
                continue;
            }
            ValueToIdMap onTheFlyDictionary = this._onTheFlyDictionaries[i];
            switch (this._storedTypes[i]) {
                case INT: {
                    int[] intValues = blockValSet.getIntValuesSV();
                    for (int j = 0; j < numDocs; ++j) {
                        keys[j][i] = onTheFlyDictionary.put(intValues[j]);
                    }
                    continue block8;
                }
                case LONG: {
                    long[] longValues = blockValSet.getLongValuesSV();
                    for (int j = 0; j < numDocs; ++j) {
                        keys[j][i] = onTheFlyDictionary.put(longValues[j]);
                    }
                    continue block8;
                }
                case FLOAT: {
                    float[] floatValues = blockValSet.getFloatValuesSV();
                    for (int j = 0; j < numDocs; ++j) {
                        keys[j][i] = onTheFlyDictionary.put(floatValues[j]);
                    }
                    continue block8;
                }
                case DOUBLE: {
                    double[] doubleValues = blockValSet.getDoubleValuesSV();
                    for (int j = 0; j < numDocs; ++j) {
                        keys[j][i] = onTheFlyDictionary.put(doubleValues[j]);
                    }
                    continue block8;
                }
                case STRING: {
                    String[] stringValues = blockValSet.getStringValuesSV();
                    for (int j = 0; j < numDocs; ++j) {
                        keys[j][i] = onTheFlyDictionary.put(stringValues[j]);
                    }
                    continue block8;
                }
                case BYTES: {
                    byte[][] bytesValues = blockValSet.getBytesValuesSV();
                    for (int j = 0; j < numDocs; ++j) {
                        keys[j][i] = onTheFlyDictionary.put(new ByteArray(bytesValues[j]));
                    }
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("Illegal data type for no-dictionary key generator: " + this._storedTypes[i]);
                }
            }
        }
        for (i = 0; i < numDocs; ++i) {
            groupKeys[i] = this.getGroupIdForKey(new FixedIntArray(keys[i]));
        }
    }

    @Override
    public void generateKeysForBlock(TransformBlock transformBlock, int[][] groupKeys) {
        int i;
        int numDocs = transformBlock.getNumDocs();
        int[][][] keys = new int[numDocs][this._numGroupByExpressions][];
        block15: for (i = 0; i < this._numGroupByExpressions; ++i) {
            int j;
            BlockValSet blockValSet = transformBlock.getBlockValueSet(this._groupByExpressions[i]);
            if (this._dictionaries[i] != null) {
                Object dictIds;
                if (this._isSingleValueExpressions[i]) {
                    dictIds = blockValSet.getDictionaryIdsSV();
                    for (int j2 = 0; j2 < numDocs; ++j2) {
                        keys[j2][i] = new int[]{dictIds[j2]};
                    }
                    continue;
                }
                dictIds = blockValSet.getDictionaryIdsMV();
                for (int j3 = 0; j3 < numDocs; ++j3) {
                    keys[j3][i] = (int[])dictIds[j3];
                }
                continue;
            }
            ValueToIdMap onTheFlyDictionary = this._onTheFlyDictionaries[i];
            if (this._isSingleValueExpressions[i]) {
                switch (this._storedTypes[i]) {
                    case INT: {
                        int[] intValues = blockValSet.getIntValuesSV();
                        for (int j4 = 0; j4 < numDocs; ++j4) {
                            keys[j4][i] = new int[]{onTheFlyDictionary.put(intValues[j4])};
                        }
                        continue block15;
                    }
                    case LONG: {
                        long[] longValues = blockValSet.getLongValuesSV();
                        for (int j5 = 0; j5 < numDocs; ++j5) {
                            keys[j5][i] = new int[]{onTheFlyDictionary.put(longValues[j5])};
                        }
                        continue block15;
                    }
                    case FLOAT: {
                        float[] floatValues = blockValSet.getFloatValuesSV();
                        for (int j6 = 0; j6 < numDocs; ++j6) {
                            keys[j6][i] = new int[]{onTheFlyDictionary.put(floatValues[j6])};
                        }
                        continue block15;
                    }
                    case DOUBLE: {
                        double[] doubleValues = blockValSet.getDoubleValuesSV();
                        for (int j7 = 0; j7 < numDocs; ++j7) {
                            keys[j7][i] = new int[]{onTheFlyDictionary.put(doubleValues[j7])};
                        }
                        continue block15;
                    }
                    case STRING: {
                        String[] stringValues = blockValSet.getStringValuesSV();
                        for (j = 0; j < numDocs; ++j) {
                            keys[j][i] = new int[]{onTheFlyDictionary.put(stringValues[j])};
                        }
                        continue block15;
                    }
                    case BYTES: {
                        byte[][] bytesValues = blockValSet.getBytesValuesSV();
                        for (int j8 = 0; j8 < numDocs; ++j8) {
                            keys[j8][i] = new int[]{onTheFlyDictionary.put(new ByteArray(bytesValues[j8]))};
                        }
                        continue block15;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal data type for no-dictionary key generator: " + this._storedTypes[i]);
                    }
                }
            }
            switch (this._storedTypes[i]) {
                case INT: {
                    int[][] intValues = blockValSet.getIntValuesMV();
                    for (int j9 = 0; j9 < numDocs; ++j9) {
                        int mvSize = intValues[j9].length;
                        int[] mvKeys = new int[mvSize];
                        for (int k = 0; k < mvSize; ++k) {
                            mvKeys[k] = onTheFlyDictionary.put(intValues[j9][k]);
                        }
                        keys[j9][i] = mvKeys;
                    }
                    continue block15;
                }
                case LONG: {
                    long[][] longValues = blockValSet.getLongValuesMV();
                    for (int j10 = 0; j10 < numDocs; ++j10) {
                        int mvSize = longValues[j10].length;
                        int[] mvKeys = new int[mvSize];
                        for (int k = 0; k < mvSize; ++k) {
                            mvKeys[k] = onTheFlyDictionary.put(longValues[j10][k]);
                        }
                        keys[j10][i] = mvKeys;
                    }
                    continue block15;
                }
                case FLOAT: {
                    float[][] floatValues = blockValSet.getFloatValuesMV();
                    for (int j11 = 0; j11 < numDocs; ++j11) {
                        int mvSize = floatValues[j11].length;
                        int[] mvKeys = new int[mvSize];
                        for (int k = 0; k < mvSize; ++k) {
                            mvKeys[k] = onTheFlyDictionary.put(floatValues[j11][k]);
                        }
                        keys[j11][i] = mvKeys;
                    }
                    continue block15;
                }
                case DOUBLE: {
                    double[][] doubleValues = blockValSet.getDoubleValuesMV();
                    for (int j12 = 0; j12 < numDocs; ++j12) {
                        int mvSize = doubleValues[j12].length;
                        int[] mvKeys = new int[mvSize];
                        for (int k = 0; k < mvSize; ++k) {
                            mvKeys[k] = onTheFlyDictionary.put(doubleValues[j12][k]);
                        }
                        keys[j12][i] = mvKeys;
                    }
                    continue block15;
                }
                case STRING: {
                    String[][] stringValues = blockValSet.getStringValuesMV();
                    for (j = 0; j < numDocs; ++j) {
                        int mvSize = stringValues[j].length;
                        int[] mvKeys = new int[mvSize];
                        for (int k = 0; k < mvSize; ++k) {
                            mvKeys[k] = onTheFlyDictionary.put(stringValues[j][k]);
                        }
                        keys[j][i] = mvKeys;
                    }
                    continue block15;
                }
                default: {
                    throw new IllegalArgumentException("Illegal data type for no-dictionary key generator: " + this._storedTypes[i]);
                }
            }
        }
        for (i = 0; i < numDocs; ++i) {
            groupKeys[i] = this.getGroupIdsForKeys(keys[i]);
        }
    }

    @Override
    public int getCurrentGroupKeyUpperBound() {
        return this._groupKeyMap.size();
    }

    @Override
    public Iterator<GroupKeyGenerator.GroupKey> getGroupKeys() {
        return new GroupKeyIterator();
    }

    @Override
    public Iterator<GroupKeyGenerator.StringGroupKey> getStringGroupKeys() {
        return new StringGroupKeyIterator();
    }

    private int getGroupIdForKey(FixedIntArray keyList) {
        int groupId = this._groupKeyMap.getInt((Object)keyList);
        if (groupId == -1 && this._numGroups < this._globalGroupIdUpperBound) {
            groupId = this._numGroups;
            this._groupKeyMap.put((Object)keyList, this._numGroups++);
        }
        return groupId;
    }

    private int[] getGroupIdsForKeys(int[][] keysList) {
        IntArrayList groupIds = new IntArrayList();
        this.getGroupIdsForKeyHelper(keysList, new int[keysList.length], 0, groupIds);
        return groupIds.toIntArray();
    }

    private void getGroupIdsForKeyHelper(int[][] keysList, int[] groupKeyIds, int level, IntArrayList groupIds) {
        int numGroups = keysList.length;
        if (level == numGroups) {
            groupIds.add(this.getGroupIdForKey(new FixedIntArray(Arrays.copyOf(groupKeyIds, numGroups))));
            return;
        }
        int numEntriesInGroup = keysList[level].length;
        for (int i = 0; i < numEntriesInGroup; ++i) {
            groupKeyIds[level] = keysList[level][i];
            this.getGroupIdsForKeyHelper(keysList, groupKeyIds, level + 1, groupIds);
        }
    }

    @Override
    public int getNumKeys() {
        return this._groupKeyMap.size();
    }

    private Object[] buildKeysFromIds(FixedIntArray keyList) {
        Object[] keys = new Object[this._numGroupByExpressions];
        int[] dictIds = keyList.elements();
        for (int i = 0; i < this._numGroupByExpressions; ++i) {
            keys[i] = this._dictionaries[i] != null ? this._dictionaries[i].getInternal(dictIds[i]) : this._onTheFlyDictionaries[i].get(dictIds[i]);
        }
        return keys;
    }

    private String buildStringKeyFromIds(FixedIntArray keyList) {
        StringBuilder builder = new StringBuilder();
        int[] keys = keyList.elements();
        for (int i = 0; i < this._numGroupByExpressions; ++i) {
            if (i > 0) {
                builder.append('\u0000');
            }
            if (this._dictionaries[i] != null) {
                builder.append(this._dictionaries[i].getStringValue(keys[i]));
                continue;
            }
            builder.append(this._onTheFlyDictionaries[i].getString(keys[i]));
        }
        return builder.toString();
    }

    private class StringGroupKeyIterator
    implements Iterator<GroupKeyGenerator.StringGroupKey> {
        private final ObjectIterator<Object2IntMap.Entry<FixedIntArray>> _iterator;
        private final GroupKeyGenerator.StringGroupKey _groupKey;

        public StringGroupKeyIterator() {
            this._iterator = NoDictionaryMultiColumnGroupKeyGenerator.this._groupKeyMap.object2IntEntrySet().fastIterator();
            this._groupKey = new GroupKeyGenerator.StringGroupKey();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public GroupKeyGenerator.StringGroupKey next() {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)this._iterator.next();
            this._groupKey._groupId = entry.getIntValue();
            this._groupKey._stringKey = NoDictionaryMultiColumnGroupKeyGenerator.this.buildStringKeyFromIds((FixedIntArray)entry.getKey());
            return this._groupKey;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class GroupKeyIterator
    implements Iterator<GroupKeyGenerator.GroupKey> {
        private final ObjectIterator<Object2IntMap.Entry<FixedIntArray>> _iterator;
        private final GroupKeyGenerator.GroupKey _groupKey;

        public GroupKeyIterator() {
            this._iterator = NoDictionaryMultiColumnGroupKeyGenerator.this._groupKeyMap.object2IntEntrySet().fastIterator();
            this._groupKey = new GroupKeyGenerator.GroupKey();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public GroupKeyGenerator.GroupKey next() {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)this._iterator.next();
            this._groupKey._groupId = entry.getIntValue();
            this._groupKey._keys = NoDictionaryMultiColumnGroupKeyGenerator.this.buildKeysFromIds((FixedIntArray)entry.getKey());
            return this._groupKey;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

