/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.groupby.utils;

import it.unimi.dsi.fastutil.doubles.Double2IntMap;
import it.unimi.dsi.fastutil.doubles.Double2IntOpenHashMap;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import org.apache.pinot.core.query.aggregation.groupby.utils.BaseValueToIdMap;

public class DoubleToIdMap
extends BaseValueToIdMap {
    Double2IntMap _valueToIdMap = new Double2IntOpenHashMap();
    DoubleList _idToValueMap;

    public DoubleToIdMap() {
        this._valueToIdMap.defaultReturnValue(-1);
        this._idToValueMap = new DoubleArrayList();
    }

    @Override
    public int put(double value) {
        int id = this._valueToIdMap.get(value);
        if (id == -1) {
            id = this._idToValueMap.size();
            this._valueToIdMap.put(value, id);
            this._idToValueMap.add(value);
        }
        return id;
    }

    @Override
    public double getDouble(int id) {
        assert (id < this._idToValueMap.size());
        return this._idToValueMap.getDouble(id);
    }

    @Override
    public String getString(int id) {
        return Double.toString(this.getDouble(id));
    }

    @Override
    public Object get(int id) {
        return this.getDouble(id);
    }
}

