/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.groupby.utils;

import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import org.apache.pinot.core.query.aggregation.groupby.utils.BaseValueToIdMap;

public class LongToIdMap
extends BaseValueToIdMap {
    Long2IntMap _valueToIdMap = new Long2IntOpenHashMap();
    LongList _idToValueMap;

    public LongToIdMap() {
        this._valueToIdMap.defaultReturnValue(-1);
        this._idToValueMap = new LongArrayList();
    }

    @Override
    public int put(long value) {
        int id = this._valueToIdMap.get(value);
        if (id == -1) {
            id = this._idToValueMap.size();
            this._valueToIdMap.put(value, id);
            this._idToValueMap.add(value);
        }
        return id;
    }

    @Override
    public long getLong(int id) {
        assert (id < this._idToValueMap.size());
        return this._idToValueMap.getLong(id);
    }

    @Override
    public String getString(int id) {
        return Long.toString(this.getLong(id));
    }

    @Override
    public Object get(int id) {
        return this.getLong(id);
    }
}

