/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct;

import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.query.aggregation.function.DistinctAggregationFunction;
import org.apache.pinot.core.query.distinct.DistinctExecutor;
import org.apache.pinot.core.query.distinct.dictionary.DictionaryBasedMultiColumnDistinctOnlyExecutor;
import org.apache.pinot.core.query.distinct.dictionary.DictionaryBasedMultiColumnDistinctOrderByExecutor;
import org.apache.pinot.core.query.distinct.dictionary.DictionaryBasedSingleColumnDistinctOnlyExecutor;
import org.apache.pinot.core.query.distinct.dictionary.DictionaryBasedSingleColumnDistinctOrderByExecutor;
import org.apache.pinot.core.query.distinct.raw.RawBytesSingleColumnDistinctOnlyExecutor;
import org.apache.pinot.core.query.distinct.raw.RawBytesSingleColumnDistinctOrderByExecutor;
import org.apache.pinot.core.query.distinct.raw.RawDoubleSingleColumnDistinctOnlyExecutor;
import org.apache.pinot.core.query.distinct.raw.RawDoubleSingleColumnDistinctOrderByExecutor;
import org.apache.pinot.core.query.distinct.raw.RawFloatSingleColumnDistinctOnlyExecutor;
import org.apache.pinot.core.query.distinct.raw.RawFloatSingleColumnDistinctOrderByExecutor;
import org.apache.pinot.core.query.distinct.raw.RawIntSingleColumnDistinctOnlyExecutor;
import org.apache.pinot.core.query.distinct.raw.RawIntSingleColumnDistinctOrderByExecutor;
import org.apache.pinot.core.query.distinct.raw.RawLongSingleColumnDistinctOnlyExecutor;
import org.apache.pinot.core.query.distinct.raw.RawLongSingleColumnDistinctOrderByExecutor;
import org.apache.pinot.core.query.distinct.raw.RawMultiColumnDistinctExecutor;
import org.apache.pinot.core.query.distinct.raw.RawStringSingleColumnDistinctOnlyExecutor;
import org.apache.pinot.core.query.distinct.raw.RawStringSingleColumnDistinctOrderByExecutor;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;

public class DistinctExecutorFactory {
    private DistinctExecutorFactory() {
    }

    public static DistinctExecutor getDistinctExecutor(DistinctAggregationFunction distinctAggregationFunction, TransformOperator transformOperator) {
        List<ExpressionContext> expressions = distinctAggregationFunction.getInputExpressions();
        List<OrderByExpressionContext> orderByExpressions = distinctAggregationFunction.getOrderByExpressions();
        int limit = distinctAggregationFunction.getLimit();
        if (orderByExpressions == null) {
            return DistinctExecutorFactory.getDistinctOnlyExecutor(expressions, limit, transformOperator);
        }
        return DistinctExecutorFactory.getDistinctOrderByExecutor(expressions, orderByExpressions, limit, transformOperator);
    }

    private static DistinctExecutor getDistinctOnlyExecutor(List<ExpressionContext> expressions, int limit, TransformOperator transformOperator) {
        if (expressions.size() == 1) {
            ExpressionContext expression = expressions.get(0);
            FieldSpec.DataType dataType = transformOperator.getResultMetadata(expression).getDataType();
            Dictionary dictionary = transformOperator.getDictionary(expression);
            if (dictionary != null) {
                return new DictionaryBasedSingleColumnDistinctOnlyExecutor(expression, dictionary, dataType, limit);
            }
            switch (dataType.getStoredType()) {
                case INT: {
                    return new RawIntSingleColumnDistinctOnlyExecutor(expression, dataType, limit);
                }
                case LONG: {
                    return new RawLongSingleColumnDistinctOnlyExecutor(expression, dataType, limit);
                }
                case FLOAT: {
                    return new RawFloatSingleColumnDistinctOnlyExecutor(expression, dataType, limit);
                }
                case DOUBLE: {
                    return new RawDoubleSingleColumnDistinctOnlyExecutor(expression, dataType, limit);
                }
                case STRING: {
                    return new RawStringSingleColumnDistinctOnlyExecutor(expression, dataType, limit);
                }
                case BYTES: {
                    return new RawBytesSingleColumnDistinctOnlyExecutor(expression, dataType, limit);
                }
            }
            throw new IllegalStateException();
        }
        int numExpressions = expressions.size();
        ArrayList<FieldSpec.DataType> dataTypes = new ArrayList<FieldSpec.DataType>(numExpressions);
        for (ExpressionContext expression : expressions) {
            dataTypes.add(transformOperator.getResultMetadata(expression).getDataType());
        }
        ArrayList<Dictionary> dictionaries = new ArrayList<Dictionary>(numExpressions);
        boolean dictionaryBased = true;
        for (ExpressionContext expression : expressions) {
            Dictionary dictionary = transformOperator.getDictionary(expression);
            if (dictionary != null) {
                dictionaries.add(dictionary);
                continue;
            }
            dictionaryBased = false;
            break;
        }
        if (dictionaryBased) {
            return new DictionaryBasedMultiColumnDistinctOnlyExecutor(expressions, dictionaries, dataTypes, limit);
        }
        return new RawMultiColumnDistinctExecutor(expressions, dataTypes, null, limit);
    }

    private static DistinctExecutor getDistinctOrderByExecutor(List<ExpressionContext> expressions, List<OrderByExpressionContext> orderByExpressions, int limit, TransformOperator transformOperator) {
        if (expressions.size() == 1) {
            ExpressionContext expression = expressions.get(0);
            FieldSpec.DataType dataType = transformOperator.getResultMetadata(expression).getDataType();
            assert (orderByExpressions.size() == 1);
            OrderByExpressionContext orderByExpression = orderByExpressions.get(0);
            Dictionary dictionary = transformOperator.getDictionary(expression);
            if (dictionary != null && dictionary.isSorted()) {
                return new DictionaryBasedSingleColumnDistinctOrderByExecutor(expression, dictionary, dataType, orderByExpressions.get(0), limit);
            }
            switch (dataType.getStoredType()) {
                case INT: {
                    return new RawIntSingleColumnDistinctOrderByExecutor(expression, dataType, orderByExpression, limit);
                }
                case LONG: {
                    return new RawLongSingleColumnDistinctOrderByExecutor(expression, dataType, orderByExpression, limit);
                }
                case FLOAT: {
                    return new RawFloatSingleColumnDistinctOrderByExecutor(expression, dataType, orderByExpression, limit);
                }
                case DOUBLE: {
                    return new RawDoubleSingleColumnDistinctOrderByExecutor(expression, dataType, orderByExpression, limit);
                }
                case STRING: {
                    return new RawStringSingleColumnDistinctOrderByExecutor(expression, dataType, orderByExpression, limit);
                }
                case BYTES: {
                    return new RawBytesSingleColumnDistinctOrderByExecutor(expression, dataType, orderByExpression, limit);
                }
            }
            throw new IllegalStateException();
        }
        int numExpressions = expressions.size();
        ArrayList<FieldSpec.DataType> dataTypes = new ArrayList<FieldSpec.DataType>(numExpressions);
        for (ExpressionContext expression : expressions) {
            dataTypes.add(transformOperator.getResultMetadata(expression).getDataType());
        }
        ArrayList<Dictionary> dictionaries = new ArrayList<Dictionary>(numExpressions);
        boolean dictionaryBased = true;
        for (ExpressionContext expression : expressions) {
            Dictionary dictionary = transformOperator.getDictionary(expression);
            if (dictionary != null && dictionary.isSorted()) {
                dictionaries.add(dictionary);
                continue;
            }
            dictionaryBased = false;
            break;
        }
        if (dictionaryBased) {
            return new DictionaryBasedMultiColumnDistinctOrderByExecutor(expressions, dictionaries, dataTypes, orderByExpressions, limit);
        }
        return new RawMultiColumnDistinctExecutor(expressions, dataTypes, orderByExpressions, limit);
    }
}

