/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct;

import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.common.datatable.DataTableBuilder;
import org.apache.pinot.core.common.datatable.DataTableFactory;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.spi.utils.ByteArray;

public class DistinctTable {
    private final DataSchema _dataSchema;
    private final Collection<Record> _records;
    private final boolean _isMainTable;
    private final int _limit;
    private final ObjectSet<Record> _recordSet;
    private final PriorityQueue<Record> _priorityQueue;

    public DistinctTable(DataSchema dataSchema, @Nullable List<OrderByExpressionContext> orderByExpressions, int limit) {
        this._dataSchema = dataSchema;
        this._isMainTable = true;
        this._limit = limit;
        int initialCapacity = Math.min(limit, 10000);
        this._recordSet = new ObjectOpenHashSet(initialCapacity);
        this._records = this._recordSet;
        if (orderByExpressions != null) {
            List<String> columnNames = Arrays.asList(dataSchema.getColumnNames());
            int numOrderByExpressions = orderByExpressions.size();
            int[] orderByExpressionIndices = new int[numOrderByExpressions];
            int[] comparisonFactors = new int[numOrderByExpressions];
            for (int i = 0; i < numOrderByExpressions; ++i) {
                OrderByExpressionContext orderByExpression = orderByExpressions.get(i);
                orderByExpressionIndices[i] = columnNames.indexOf(orderByExpression.getExpression().toString());
                comparisonFactors[i] = orderByExpression.isAsc() ? -1 : 1;
            }
            this._priorityQueue = new ObjectHeapPriorityQueue(initialCapacity, (r1, r2) -> {
                Object[] values1 = r1.getValues();
                Object[] values2 = r2.getValues();
                for (int i = 0; i < numOrderByExpressions; ++i) {
                    int index = orderByExpressionIndices[i];
                    Comparable value1 = (Comparable)values1[index];
                    Comparable value2 = (Comparable)values2[index];
                    int result = value1.compareTo(value2) * comparisonFactors[i];
                    if (result == 0) continue;
                    return result;
                }
                return 0;
            });
        } else {
            this._priorityQueue = null;
        }
    }

    public DistinctTable(DataSchema dataSchema, Collection<Record> records) {
        this._dataSchema = dataSchema;
        this._records = records;
        this._isMainTable = false;
        this._limit = Integer.MIN_VALUE;
        this._recordSet = null;
        this._priorityQueue = null;
    }

    public DataSchema getDataSchema() {
        return this._dataSchema;
    }

    public boolean isMainTable() {
        return this._isMainTable;
    }

    public int size() {
        return this._records.size();
    }

    @VisibleForTesting
    public Collection<Record> getRecords() {
        return this._records;
    }

    public boolean hasOrderBy() {
        assert (this._isMainTable);
        return this._priorityQueue != null;
    }

    public boolean addWithoutOrderBy(Record record) {
        assert (this._isMainTable && this._priorityQueue == null);
        this._recordSet.add((Object)record);
        return this._recordSet.size() >= this._limit;
    }

    public void addWithOrderBy(Record record) {
        assert (this._isMainTable && this._priorityQueue != null);
        if (!this._recordSet.contains((Object)record)) {
            if (this._priorityQueue.size() < this._limit) {
                this._recordSet.add((Object)record);
                this._priorityQueue.enqueue((Object)record);
            } else {
                Record firstRecord = (Record)this._priorityQueue.first();
                if (this._priorityQueue.comparator().compare(record, firstRecord) > 0) {
                    this._recordSet.remove((Object)firstRecord);
                    this._recordSet.add((Object)record);
                    this._priorityQueue.dequeue();
                    this._priorityQueue.enqueue((Object)record);
                }
            }
        }
    }

    public void mergeTable(DistinctTable distinctTable) {
        block4: {
            block3: {
                assert (this._isMainTable);
                if (!this.hasOrderBy()) break block3;
                for (Record record : distinctTable._records) {
                    this.addWithOrderBy(record);
                }
                break block4;
            }
            if (this._recordSet.size() >= this._limit) break block4;
            for (Record record : distinctTable._records) {
                if (!this.addWithoutOrderBy(record)) continue;
                return;
            }
        }
    }

    public Iterator<Record> getFinalResult() {
        assert (this._isMainTable);
        if (this._priorityQueue != null) {
            int numRecords = this._priorityQueue.size();
            Record[] sortedRecords = new Record[numRecords];
            for (int i = numRecords - 1; i >= 0; --i) {
                sortedRecords[i] = (Record)this._priorityQueue.dequeue();
            }
            return Arrays.asList(sortedRecords).iterator();
        }
        return this._recordSet.iterator();
    }

    public byte[] toBytes() throws IOException {
        DataTableBuilder dataTableBuilder = new DataTableBuilder(this._dataSchema);
        DataSchema.ColumnDataType[] storedColumnDataTypes = this._dataSchema.getStoredColumnDataTypes();
        int numColumns = storedColumnDataTypes.length;
        for (Record record : this._records) {
            dataTableBuilder.startRow();
            Object[] values = record.getValues();
            block9: for (int i = 0; i < numColumns; ++i) {
                switch (storedColumnDataTypes[i]) {
                    case INT: {
                        dataTableBuilder.setColumn(i, (Integer)values[i]);
                        continue block9;
                    }
                    case LONG: {
                        dataTableBuilder.setColumn(i, (Long)values[i]);
                        continue block9;
                    }
                    case FLOAT: {
                        dataTableBuilder.setColumn(i, ((Float)values[i]).floatValue());
                        continue block9;
                    }
                    case DOUBLE: {
                        dataTableBuilder.setColumn(i, (Double)values[i]);
                        continue block9;
                    }
                    case STRING: {
                        dataTableBuilder.setColumn(i, (String)values[i]);
                        continue block9;
                    }
                    case BYTES: {
                        dataTableBuilder.setColumn(i, (ByteArray)values[i]);
                        continue block9;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            dataTableBuilder.finishRow();
        }
        return dataTableBuilder.build().toBytes();
    }

    public static DistinctTable fromByteBuffer(ByteBuffer byteBuffer) throws IOException {
        DataTable dataTable = DataTableFactory.getDataTable(byteBuffer);
        DataSchema dataSchema = dataTable.getDataSchema();
        int numRecords = dataTable.getNumberOfRows();
        DataSchema.ColumnDataType[] storedColumnDataTypes = dataSchema.getStoredColumnDataTypes();
        int numColumns = storedColumnDataTypes.length;
        ArrayList<Record> records = new ArrayList<Record>(numRecords);
        for (int i = 0; i < numRecords; ++i) {
            Object[] values = new Object[numColumns];
            block9: for (int j = 0; j < numColumns; ++j) {
                switch (storedColumnDataTypes[j]) {
                    case INT: {
                        values[j] = dataTable.getInt(i, j);
                        continue block9;
                    }
                    case LONG: {
                        values[j] = dataTable.getLong(i, j);
                        continue block9;
                    }
                    case FLOAT: {
                        values[j] = Float.valueOf(dataTable.getFloat(i, j));
                        continue block9;
                    }
                    case DOUBLE: {
                        values[j] = dataTable.getDouble(i, j);
                        continue block9;
                    }
                    case STRING: {
                        values[j] = dataTable.getString(i, j);
                        continue block9;
                    }
                    case BYTES: {
                        values[j] = dataTable.getBytes(i, j);
                        continue block9;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            records.add(new Record(values));
        }
        return new DistinctTable(dataSchema, records);
    }
}

