/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.dictionary;

import java.util.List;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.query.distinct.dictionary.BaseDictionaryBasedMultiColumnDistinctExecutor;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;

public class DictionaryBasedMultiColumnDistinctOnlyExecutor
extends BaseDictionaryBasedMultiColumnDistinctExecutor {
    public DictionaryBasedMultiColumnDistinctOnlyExecutor(List<ExpressionContext> expressions, List<Dictionary> dictionaries, List<FieldSpec.DataType> dataTypes, int limit) {
        super(expressions, dictionaries, dataTypes, limit);
    }

    @Override
    public boolean process(TransformBlock transformBlock) {
        int i;
        int numDocs = transformBlock.getNumDocs();
        int numExpressions = this._expressions.size();
        int[][] dictIdsArray = new int[numDocs][numExpressions];
        for (i = 0; i < numExpressions; ++i) {
            BlockValSet blockValueSet = transformBlock.getBlockValueSet((ExpressionContext)this._expressions.get(i));
            int[] dictIdsForExpression = blockValueSet.getDictionaryIdsSV();
            for (int j = 0; j < numDocs; ++j) {
                dictIdsArray[j][i] = dictIdsForExpression[j];
            }
        }
        for (i = 0; i < numDocs; ++i) {
            this._dictIdsSet.add((Object)new BaseDictionaryBasedMultiColumnDistinctExecutor.DictIds(dictIdsArray[i]));
            if (this._dictIdsSet.size() < this._limit) continue;
            return true;
        }
        return false;
    }
}

