/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.raw;

import it.unimi.dsi.fastutil.doubles.DoubleHeapPriorityQueue;
import it.unimi.dsi.fastutil.doubles.DoublePriorityQueue;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.query.distinct.raw.BaseRawDoubleSingleColumnDistinctExecutor;
import org.apache.pinot.spi.data.FieldSpec;

public class RawDoubleSingleColumnDistinctOrderByExecutor
extends BaseRawDoubleSingleColumnDistinctExecutor {
    private final DoublePriorityQueue _priorityQueue;

    public RawDoubleSingleColumnDistinctOrderByExecutor(ExpressionContext expression, FieldSpec.DataType dataType, OrderByExpressionContext orderByExpression, int limit) {
        super(expression, dataType, limit);
        assert (orderByExpression.getExpression().equals((Object)expression));
        int comparisonFactor = orderByExpression.isAsc() ? -1 : 1;
        this._priorityQueue = new DoubleHeapPriorityQueue(Math.min(limit, 10000), (d1, d2) -> Double.compare(d1, d2) * comparisonFactor);
    }

    @Override
    public boolean process(TransformBlock transformBlock) {
        BlockValSet blockValueSet = transformBlock.getBlockValueSet(this._expression);
        double[] values = blockValueSet.getDoubleValuesSV();
        int numDocs = transformBlock.getNumDocs();
        for (int i = 0; i < numDocs; ++i) {
            double value = values[i];
            if (this._valueSet.contains(value)) continue;
            if (this._valueSet.size() < this._limit) {
                this._valueSet.add(value);
                this._priorityQueue.enqueue(value);
                continue;
            }
            double firstValue = this._priorityQueue.firstDouble();
            if (this._priorityQueue.comparator().compare(value, firstValue) <= 0) continue;
            this._valueSet.remove(firstValue);
            this._valueSet.add(value);
            this._priorityQueue.dequeueDouble();
            this._priorityQueue.enqueue(value);
        }
        return false;
    }
}

