/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.raw;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.RowBasedBlockValueFetcher;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.query.distinct.DistinctExecutor;
import org.apache.pinot.core.query.distinct.DistinctTable;
import org.apache.pinot.spi.data.FieldSpec;

public class RawMultiColumnDistinctExecutor
implements DistinctExecutor {
    private final List<ExpressionContext> _expressions;
    private final DistinctTable _distinctTable;

    public RawMultiColumnDistinctExecutor(List<ExpressionContext> expressions, List<FieldSpec.DataType> dataTypes, @Nullable List<OrderByExpressionContext> orderByExpressions, int limit) {
        this._expressions = expressions;
        int numExpressions = expressions.size();
        String[] columnNames = new String[numExpressions];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numExpressions];
        for (int i = 0; i < numExpressions; ++i) {
            columnNames[i] = expressions.get(i).toString();
            columnDataTypes[i] = DataSchema.ColumnDataType.fromDataTypeSV((FieldSpec.DataType)dataTypes.get(i));
        }
        DataSchema dataSchema = new DataSchema(columnNames, columnDataTypes);
        this._distinctTable = new DistinctTable(dataSchema, orderByExpressions, limit);
    }

    @Override
    public boolean process(TransformBlock transformBlock) {
        int numExpressions = this._expressions.size();
        BlockValSet[] blockValSets = new BlockValSet[numExpressions];
        for (int i = 0; i < numExpressions; ++i) {
            blockValSets[i] = transformBlock.getBlockValueSet(this._expressions.get(i));
        }
        RowBasedBlockValueFetcher valueFetcher = new RowBasedBlockValueFetcher(blockValSets);
        int numDocs = transformBlock.getNumDocs();
        if (this._distinctTable.hasOrderBy()) {
            for (int i = 0; i < numDocs; ++i) {
                Record record = new Record(valueFetcher.getRow(i));
                this._distinctTable.addWithOrderBy(record);
            }
        } else {
            for (int i = 0; i < numDocs; ++i) {
                Record record = new Record(valueFetcher.getRow(i));
                if (!this._distinctTable.addWithoutOrderBy(record)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public DistinctTable getResult() {
        return this._distinctTable;
    }
}

