/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.executor;

import com.google.common.base.Preconditions;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.function.TransformFunctionType;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.metrics.ServerQueryPhase;
import org.apache.pinot.common.proto.Server;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.common.datatable.DataTableBuilder;
import org.apache.pinot.core.common.datatable.DataTableUtils;
import org.apache.pinot.core.data.manager.InstanceDataManager;
import org.apache.pinot.core.plan.Plan;
import org.apache.pinot.core.plan.maker.InstancePlanMakerImplV2;
import org.apache.pinot.core.plan.maker.PlanMaker;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.config.QueryExecutorConfig;
import org.apache.pinot.core.query.executor.QueryExecutor;
import org.apache.pinot.core.query.pruner.SegmentPrunerService;
import org.apache.pinot.core.query.request.ServerQueryRequest;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.TimerContext;
import org.apache.pinot.core.query.request.context.utils.QueryContextConverterUtils;
import org.apache.pinot.core.query.utils.idset.IdSet;
import org.apache.pinot.core.util.QueryOptions;
import org.apache.pinot.core.util.trace.TraceContext;
import org.apache.pinot.segment.local.data.manager.SegmentDataManager;
import org.apache.pinot.segment.local.data.manager.TableDataManager;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.MutableSegment;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.exception.BadQueryRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ServerQueryExecutorV1Impl
implements QueryExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerQueryExecutorV1Impl.class);
    private static final String IN_PARTITIONED_SUBQUERY = "inPartitionedSubquery";
    private InstanceDataManager _instanceDataManager;
    private SegmentPrunerService _segmentPrunerService;
    private PlanMaker _planMaker;
    private long _defaultTimeOutMs = 15000L;
    private ServerMetrics _serverMetrics;

    @Override
    public synchronized void init(PinotConfiguration config, InstanceDataManager instanceDataManager, ServerMetrics serverMetrics) throws ConfigurationException {
        this._instanceDataManager = instanceDataManager;
        this._serverMetrics = serverMetrics;
        QueryExecutorConfig queryExecutorConfig = new QueryExecutorConfig(config);
        if (queryExecutorConfig.getTimeOut() > 0L) {
            this._defaultTimeOutMs = queryExecutorConfig.getTimeOut();
        }
        LOGGER.info("Default timeout for query executor : {}", (Object)this._defaultTimeOutMs);
        LOGGER.info("Trying to build SegmentPrunerService");
        this._segmentPrunerService = new SegmentPrunerService(queryExecutorConfig.getPrunerConfig());
        LOGGER.info("Trying to build QueryPlanMaker");
        this._planMaker = new InstancePlanMakerImplV2(queryExecutorConfig);
        LOGGER.info("Trying to build QueryExecutorTimer");
    }

    @Override
    public synchronized void start() {
        LOGGER.info("Query executor started");
    }

    @Override
    public synchronized void shutDown() {
        LOGGER.info("Query executor shut down");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTable processQuery(ServerQueryRequest queryRequest, ExecutorService executorService, @Nullable StreamObserver<Server.ServerResponse> responseObserver) {
        boolean enableTrace;
        int numSegmentsAcquired;
        Long timeoutFromQueryOptions;
        TimerContext timerContext = queryRequest.getTimerContext();
        TimerContext.Timer schedulerWaitTimer = timerContext.getPhaseTimer(ServerQueryPhase.SCHEDULER_WAIT);
        if (schedulerWaitTimer != null) {
            schedulerWaitTimer.stopAndRecord();
        }
        long queryArrivalTimeMs = timerContext.getQueryArrivalTimeMs();
        long querySchedulingTimeMs = System.currentTimeMillis() - queryArrivalTimeMs;
        TimerContext.Timer queryProcessingTimer = timerContext.startNewPhaseTimer(ServerQueryPhase.QUERY_PROCESSING);
        long requestId = queryRequest.getRequestId();
        String tableNameWithType = queryRequest.getTableNameWithType();
        QueryContext queryContext = queryRequest.getQueryContext();
        LOGGER.debug("Incoming request Id: {}, query: {}", (Object)requestId, (Object)queryContext);
        long queryTimeoutMs = this._defaultTimeOutMs;
        Map<String, String> queryOptions = queryContext.getQueryOptions();
        if (queryOptions != null && (timeoutFromQueryOptions = QueryOptions.getTimeoutMs(queryOptions)) != null) {
            queryTimeoutMs = timeoutFromQueryOptions;
        }
        if (querySchedulingTimeMs >= queryTimeoutMs) {
            this._serverMetrics.addMeteredTableValue(tableNameWithType, (AbstractMetrics.Meter)ServerMeter.SCHEDULING_TIMEOUT_EXCEPTIONS, 1L);
            String errorMessage = String.format("Query scheduling took %dms (longer than query timeout of %dms)", querySchedulingTimeMs, queryTimeoutMs);
            DataTable dataTable = DataTableBuilder.getEmptyDataTable();
            dataTable.addException(QueryException.getException((ProcessingException)QueryException.QUERY_SCHEDULING_TIMEOUT_ERROR, (String)errorMessage));
            LOGGER.error("{} while processing requestId: {}", (Object)errorMessage, (Object)requestId);
            return dataTable;
        }
        TableDataManager tableDataManager = this._instanceDataManager.getTableDataManager(tableNameWithType);
        if (tableDataManager == null) {
            String errorMessage = "Failed to find table: " + tableNameWithType;
            DataTable dataTable = DataTableBuilder.getEmptyDataTable();
            dataTable.addException(QueryException.getException((ProcessingException)QueryException.SERVER_TABLE_MISSING_ERROR, (String)errorMessage));
            LOGGER.error("{} while processing requestId: {}", (Object)errorMessage, (Object)requestId);
            return dataTable;
        }
        List<String> segmentsToQuery = queryRequest.getSegmentsToQuery();
        List segmentDataManagers = tableDataManager.acquireSegments(segmentsToQuery);
        int numSegmentsQueried = segmentsToQuery.size();
        if (numSegmentsQueried > (numSegmentsAcquired = segmentDataManagers.size())) {
            this._serverMetrics.addMeteredTableValue(tableNameWithType, (AbstractMetrics.Meter)ServerMeter.NUM_MISSING_SEGMENTS, (long)(numSegmentsQueried - numSegmentsAcquired));
        }
        ArrayList<IndexSegment> indexSegments = new ArrayList<IndexSegment>(numSegmentsAcquired);
        for (SegmentDataManager segmentDataManager : segmentDataManagers) {
            indexSegments.add(segmentDataManager.getSegment());
        }
        int numConsumingSegmentsProcessed = 0;
        long minIndexTimeMs = Long.MAX_VALUE;
        long minIngestionTimeMs = Long.MAX_VALUE;
        for (IndexSegment indexSegment : indexSegments) {
            long ingestionTimeMs;
            if (!(indexSegment instanceof MutableSegment)) continue;
            ++numConsumingSegmentsProcessed;
            SegmentMetadata segmentMetadata = indexSegment.getSegmentMetadata();
            long indexTimeMs = segmentMetadata.getLastIndexedTimestamp();
            if (indexTimeMs != Long.MIN_VALUE && indexTimeMs < minIndexTimeMs) {
                minIndexTimeMs = indexTimeMs;
            }
            if ((ingestionTimeMs = segmentMetadata.getLatestIngestionTimestamp()) == Long.MIN_VALUE || ingestionTimeMs >= minIngestionTimeMs) continue;
            minIngestionTimeMs = ingestionTimeMs;
        }
        long minConsumingFreshnessTimeMs = minIngestionTimeMs;
        if (numConsumingSegmentsProcessed > 0) {
            if (minIngestionTimeMs == Long.MAX_VALUE) {
                LOGGER.debug("Did not find valid ingestionTimestamp across consuming segments! Using indexTime instead");
                minConsumingFreshnessTimeMs = minIndexTimeMs;
            }
            LOGGER.debug("Querying: {} consuming segments with minConsumingFreshnessTimeMs: {}", (Object)numConsumingSegmentsProcessed, (Object)minConsumingFreshnessTimeMs);
        }
        if (enableTrace = queryRequest.isEnableTrace()) {
            TraceContext.register(requestId);
        }
        DataTable dataTable = null;
        try {
            dataTable = this.processQuery(indexSegments, queryContext, timerContext, executorService, responseObserver, queryArrivalTimeMs + queryTimeoutMs, queryRequest.isEnableStreaming());
        }
        catch (Exception e) {
            this._serverMetrics.addMeteredTableValue(tableNameWithType, (AbstractMetrics.Meter)ServerMeter.QUERY_EXECUTION_EXCEPTIONS, 1L);
            if (e instanceof BadQueryRequestException) {
                LOGGER.info("Caught BadQueryRequestException while processing requestId: {}, {}", (Object)requestId, (Object)e.getMessage());
            } else {
                LOGGER.error("Exception processing requestId {}", (Object)requestId, (Object)e);
            }
            dataTable = DataTableBuilder.getEmptyDataTable();
            dataTable.addException(QueryException.getException((ProcessingException)QueryException.QUERY_EXECUTION_ERROR, (Exception)e));
        }
        finally {
            for (SegmentDataManager segmentDataManager : segmentDataManagers) {
                tableDataManager.releaseSegment(segmentDataManager);
            }
            if (enableTrace) {
                if (dataTable != null) {
                    dataTable.getMetadata().put(DataTable.MetadataKey.TRACE_INFO.getName(), TraceContext.getTraceInfo());
                }
                TraceContext.unregister();
            }
        }
        queryProcessingTimer.stopAndRecord();
        long queryProcessingTime = queryProcessingTimer.getDurationMs();
        dataTable.getMetadata().put(DataTable.MetadataKey.NUM_SEGMENTS_QUERIED.getName(), Integer.toString(numSegmentsQueried));
        dataTable.getMetadata().put(DataTable.MetadataKey.TIME_USED_MS.getName(), Long.toString(queryProcessingTime));
        if (numConsumingSegmentsProcessed > 0) {
            dataTable.getMetadata().put(DataTable.MetadataKey.NUM_CONSUMING_SEGMENTS_PROCESSED.getName(), Integer.toString(numConsumingSegmentsProcessed));
            dataTable.getMetadata().put(DataTable.MetadataKey.MIN_CONSUMING_FRESHNESS_TIME_MS.getName(), Long.toString(minConsumingFreshnessTimeMs));
        }
        LOGGER.debug("Query processing time for request Id - {}: {}", (Object)requestId, (Object)queryProcessingTime);
        LOGGER.debug("InstanceResponse for request Id - {}: {}", (Object)requestId, (Object)dataTable);
        return dataTable;
    }

    private DataTable processQuery(List<IndexSegment> indexSegments, QueryContext queryContext, TimerContext timerContext, ExecutorService executorService, @Nullable StreamObserver<Server.ServerResponse> responseObserver, long endTimeMs, boolean enableStreaming) throws Exception {
        this.handleSubquery(queryContext, indexSegments, timerContext, executorService, endTimeMs);
        long numTotalDocs = 0L;
        for (IndexSegment indexSegment : indexSegments) {
            numTotalDocs += (long)indexSegment.getSegmentMetadata().getTotalDocs();
        }
        TimerContext.Timer segmentPruneTimer = timerContext.startNewPhaseTimer(ServerQueryPhase.SEGMENT_PRUNING);
        List<IndexSegment> selectedSegments = this._segmentPrunerService.prune(indexSegments, queryContext);
        segmentPruneTimer.stopAndRecord();
        int numSelectedSegments = selectedSegments.size();
        LOGGER.debug("Matched {} segments after pruning", (Object)numSelectedSegments);
        if (numSelectedSegments == 0) {
            DataTable dataTable = enableStreaming ? DataTableBuilder.getEmptyDataTable() : DataTableUtils.buildEmptyDataTable(queryContext);
            Map metadata = dataTable.getMetadata();
            metadata.put(DataTable.MetadataKey.TOTAL_DOCS.getName(), String.valueOf(numTotalDocs));
            metadata.put(DataTable.MetadataKey.NUM_DOCS_SCANNED.getName(), "0");
            metadata.put(DataTable.MetadataKey.NUM_ENTRIES_SCANNED_IN_FILTER.getName(), "0");
            metadata.put(DataTable.MetadataKey.NUM_ENTRIES_SCANNED_POST_FILTER.getName(), "0");
            metadata.put(DataTable.MetadataKey.NUM_SEGMENTS_PROCESSED.getName(), "0");
            metadata.put(DataTable.MetadataKey.NUM_SEGMENTS_MATCHED.getName(), "0");
            return dataTable;
        }
        TimerContext.Timer planBuildTimer = timerContext.startNewPhaseTimer(ServerQueryPhase.BUILD_QUERY_PLAN);
        Plan queryPlan = enableStreaming ? this._planMaker.makeStreamingInstancePlan(selectedSegments, queryContext, executorService, responseObserver, endTimeMs) : this._planMaker.makeInstancePlan(selectedSegments, queryContext, executorService, endTimeMs);
        planBuildTimer.stopAndRecord();
        TimerContext.Timer planExecTimer = timerContext.startNewPhaseTimer(ServerQueryPhase.QUERY_PLAN_EXECUTION);
        DataTable dataTable = queryPlan.execute();
        planExecTimer.stopAndRecord();
        dataTable.getMetadata().put(DataTable.MetadataKey.TOTAL_DOCS.getName(), Long.toString(numTotalDocs));
        return dataTable;
    }

    private void handleSubquery(QueryContext queryContext, List<IndexSegment> indexSegments, TimerContext timerContext, ExecutorService executorService, long endTimeMs) throws Exception {
        FilterContext filter = queryContext.getFilter();
        if (filter != null) {
            this.handleSubquery(filter, indexSegments, timerContext, executorService, endTimeMs);
        }
    }

    private void handleSubquery(FilterContext filter, List<IndexSegment> indexSegments, TimerContext timerContext, ExecutorService executorService, long endTimeMs) throws Exception {
        List children = filter.getChildren();
        if (children != null) {
            for (FilterContext child : children) {
                this.handleSubquery(child, indexSegments, timerContext, executorService, endTimeMs);
            }
        } else {
            this.handleSubquery(filter.getPredicate().getLhs(), indexSegments, timerContext, executorService, endTimeMs);
        }
    }

    private void handleSubquery(ExpressionContext expression, List<IndexSegment> indexSegments, TimerContext timerContext, ExecutorService executorService, long endTimeMs) throws Exception {
        FunctionContext function = expression.getFunction();
        if (function == null) {
            return;
        }
        List arguments = function.getArguments();
        if (StringUtils.remove((String)function.getFunctionName(), (char)'_').equalsIgnoreCase(IN_PARTITIONED_SUBQUERY)) {
            Preconditions.checkState((arguments.size() == 2 ? 1 : 0) != 0, (Object)"IN_PARTITIONED_SUBQUERY requires 2 arguments: expression, subquery");
            ExpressionContext subqueryExpression = (ExpressionContext)arguments.get(1);
            Preconditions.checkState((subqueryExpression.getType() == ExpressionContext.Type.LITERAL ? 1 : 0) != 0, (Object)"Second argument of IN_PARTITIONED_SUBQUERY must be a literal (subquery)");
            QueryContext subquery = QueryContextConverterUtils.getQueryContextFromSQL(subqueryExpression.getLiteral());
            AggregationFunction[] aggregationFunctions = subquery.getAggregationFunctions();
            Preconditions.checkState((aggregationFunctions != null && aggregationFunctions.length == 1 && aggregationFunctions[0].getType() == AggregationFunctionType.IDSET && subquery.getGroupByExpressions() == null ? 1 : 0) != 0, (String)"Subquery in IN_PARTITIONED_SUBQUERY should be an ID_SET aggregation only query, found: %s", (Object)subqueryExpression.getLiteral());
            DataTable dataTable = this.processQuery(indexSegments, subquery, timerContext, executorService, null, endTimeMs, false);
            IdSet idSet = (IdSet)dataTable.getObject(0, 0);
            String serializedIdSet = idSet.toBase64String();
            function.setFunctionName(TransformFunctionType.INIDSET.name());
            arguments.set(1, ExpressionContext.forLiteral((String)serializedIdSet));
        } else {
            for (ExpressionContext argument : arguments) {
                this.handleSubquery(argument, indexSegments, timerContext, executorService, endTimeMs);
            }
        }
    }
}

