/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.optimizer;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.FilterQuery;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.common.utils.request.FilterQueryTree;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.core.query.optimizer.filter.FilterOptimizer;
import org.apache.pinot.core.query.optimizer.filter.FlattenAndOrFilterOptimizer;
import org.apache.pinot.core.query.optimizer.filter.MergeEqInFilterOptimizer;
import org.apache.pinot.core.query.optimizer.filter.MergeRangeFilterOptimizer;
import org.apache.pinot.core.query.optimizer.filter.NumericalFilterOptimizer;
import org.apache.pinot.core.query.optimizer.filter.TimePredicateFilterOptimizer;
import org.apache.pinot.core.query.optimizer.statement.JsonStatementOptimizer;
import org.apache.pinot.core.query.optimizer.statement.StatementOptimizer;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;

public class QueryOptimizer {
    private static final List<FilterOptimizer> FILTER_OPTIMIZERS = Arrays.asList(new FlattenAndOrFilterOptimizer(), new MergeEqInFilterOptimizer(), new NumericalFilterOptimizer(), new TimePredicateFilterOptimizer(), new MergeRangeFilterOptimizer());
    private static final List<StatementOptimizer> STATEMENT_OPTIMIZERS = Arrays.asList(new JsonStatementOptimizer());

    public void optimize(BrokerRequest brokerRequest, @Nullable Schema schema) {
        FilterQuery filterQuery = brokerRequest.getFilterQuery();
        if (filterQuery != null) {
            FilterQueryTree filterQueryTree = RequestUtils.buildFilterQuery((Integer)filterQuery.getId(), (Map)brokerRequest.getFilterSubQueryMap().getFilterQueryMap());
            for (FilterOptimizer filterOptimizer : FILTER_OPTIMIZERS) {
                filterQueryTree = filterOptimizer.optimize(filterQueryTree, schema);
            }
            RequestUtils.generateFilterFromTree((FilterQueryTree)filterQueryTree, (BrokerRequest)brokerRequest);
        }
    }

    public void optimize(PinotQuery pinotQuery, @Nullable Schema schema) {
        this.optimize(pinotQuery, null, schema);
    }

    public void optimize(PinotQuery pinotQuery, @Nullable TableConfig tableConfig, @Nullable Schema schema) {
        Expression filterExpression = pinotQuery.getFilterExpression();
        if (filterExpression != null) {
            for (FilterOptimizer filterOptimizer : FILTER_OPTIMIZERS) {
                filterExpression = filterOptimizer.optimize(filterExpression, schema);
            }
            pinotQuery.setFilterExpression(filterExpression);
        }
        for (StatementOptimizer statementOptimizer : STATEMENT_OPTIMIZERS) {
            statementOptimizer.optimize(pinotQuery, tableConfig, schema);
        }
    }
}

