/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.optimizer.filter;

import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.ExpressionType;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.Literal;
import org.apache.pinot.common.utils.request.FilterQueryTree;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.core.query.optimizer.filter.FilterOptimizer;
import org.apache.pinot.pql.parsers.pql2.ast.FilterKind;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;

public class NumericalFilterOptimizer
implements FilterOptimizer {
    private static final Expression TRUE = RequestUtils.getLiteralExpression((boolean)true);
    private static final Expression FALSE = RequestUtils.getLiteralExpression((boolean)false);

    @Override
    public FilterQueryTree optimize(FilterQueryTree filterQueryTree, @Nullable Schema schema) {
        return filterQueryTree;
    }

    @Override
    public Expression optimize(Expression expression, @Nullable Schema schema) {
        ExpressionType type = expression.getType();
        if (type != ExpressionType.FUNCTION || schema == null) {
            return expression;
        }
        Function function = expression.getFunctionCall();
        List operands = function.getOperands();
        FilterKind kind = FilterKind.valueOf((String)function.getOperator());
        switch (kind) {
            case AND: 
            case OR: {
                operands.forEach(operand -> this.optimize((Expression)operand, schema));
                return NumericalFilterOptimizer.optimizeCurrent(expression);
            }
            case IS_NULL: 
            case IS_NOT_NULL: {
                break;
            }
            default: {
                Expression lhs = (Expression)operands.get(0);
                Expression rhs = (Expression)operands.get(1);
                if (!NumericalFilterOptimizer.isNumericColumn(lhs, schema) || !NumericalFilterOptimizer.isNumericLiteral(rhs)) break;
                switch (kind) {
                    case EQUALS: 
                    case NOT_EQUALS: {
                        return NumericalFilterOptimizer.rewriteEqualsExpression(expression, kind, lhs, rhs, schema);
                    }
                    case GREATER_THAN: 
                    case GREATER_THAN_OR_EQUAL: 
                    case LESS_THAN: 
                    case LESS_THAN_OR_EQUAL: {
                        return NumericalFilterOptimizer.rewriteRangeExpression(expression, kind, lhs, rhs, schema);
                    }
                }
            }
        }
        return expression;
    }

    private static Expression optimizeCurrent(Expression expression) {
        Function function = expression.getFunctionCall();
        List operands = function.getOperands();
        if (function.getOperator().equals(FilterKind.AND.name())) {
            for (Expression operand : operands) {
                if (!operand.equals(FALSE)) continue;
                return NumericalFilterOptimizer.setExpressionToBoolean(expression, false);
            }
            operands.removeIf(x -> x.equals(TRUE));
            if (operands.size() == 0) {
                return NumericalFilterOptimizer.setExpressionToBoolean(expression, true);
            }
        } else if (function.getOperator().equals(FilterKind.OR.name())) {
            for (Expression operand : operands) {
                if (!operand.equals(TRUE)) continue;
                return NumericalFilterOptimizer.setExpressionToBoolean(expression, true);
            }
            operands.removeIf(x -> x.equals(FALSE));
            if (operands.size() == 0) {
                return NumericalFilterOptimizer.setExpressionToBoolean(expression, false);
            }
        }
        return expression;
    }

    private static Expression rewriteEqualsExpression(Expression equals, FilterKind kind, Expression lhs, Expression rhs, Schema schema) {
        boolean result = kind == FilterKind.NOT_EQUALS;
        FieldSpec.DataType dataType = schema.getFieldSpecFor(lhs.getIdentifier().getName()).getDataType();
        block0 : switch ((Literal._Fields)rhs.getLiteral().getSetField()) {
            case SHORT_VALUE: 
            case INT_VALUE: {
                break;
            }
            case LONG_VALUE: {
                long actual = rhs.getLiteral().getLongValue();
                switch (dataType) {
                    case INT: {
                        int converted = (int)actual;
                        if ((long)converted != actual) {
                            NumericalFilterOptimizer.setExpressionToBoolean(equals, result);
                            break block0;
                        }
                        rhs.getLiteral().setLongValue((long)converted);
                        break block0;
                    }
                    case FLOAT: {
                        float converted = actual;
                        if (BigDecimal.valueOf(actual).compareTo(BigDecimal.valueOf(converted)) != 0) {
                            NumericalFilterOptimizer.setExpressionToBoolean(equals, result);
                            break block0;
                        }
                        rhs.getLiteral().setDoubleValue((double)converted);
                        break block0;
                    }
                    case DOUBLE: {
                        double converted = actual;
                        if (BigDecimal.valueOf(actual).compareTo(BigDecimal.valueOf(converted)) != 0) {
                            NumericalFilterOptimizer.setExpressionToBoolean(equals, result);
                            break block0;
                        }
                        rhs.getLiteral().setDoubleValue(converted);
                        break block0;
                    }
                }
                break;
            }
            case DOUBLE_VALUE: {
                double actual = rhs.getLiteral().getDoubleValue();
                switch (dataType) {
                    case INT: {
                        int converted = (int)actual;
                        if ((double)converted != actual) {
                            NumericalFilterOptimizer.setExpressionToBoolean(equals, result);
                            break block0;
                        }
                        rhs.getLiteral().setLongValue((long)converted);
                        break block0;
                    }
                    case LONG: {
                        long converted = (long)actual;
                        if (BigDecimal.valueOf(actual).compareTo(BigDecimal.valueOf(converted)) != 0) {
                            NumericalFilterOptimizer.setExpressionToBoolean(equals, result);
                            break block0;
                        }
                        rhs.getLiteral().setLongValue(converted);
                        break block0;
                    }
                    case FLOAT: {
                        float converted = (float)actual;
                        if ((double)converted != actual) {
                            NumericalFilterOptimizer.setExpressionToBoolean(equals, result);
                            break block0;
                        }
                        rhs.getLiteral().setDoubleValue((double)converted);
                        break block0;
                    }
                }
            }
        }
        return equals;
    }

    private static Expression rewriteRangeExpression(Expression range, FilterKind kind, Expression lhs, Expression rhs, Schema schema) {
        FieldSpec.DataType dataType = schema.getFieldSpecFor(lhs.getIdentifier().getName()).getDataType();
        block0 : switch ((Literal._Fields)rhs.getLiteral().getSetField()) {
            case SHORT_VALUE: 
            case INT_VALUE: {
                break;
            }
            case LONG_VALUE: {
                long actual = rhs.getLiteral().getLongValue();
                switch (dataType) {
                    case INT: {
                        int converted = (int)actual;
                        int comparison = Long.compare(actual, converted);
                        if (comparison > 0) {
                            NumericalFilterOptimizer.setExpressionToBoolean(range, kind == FilterKind.LESS_THAN || kind == FilterKind.LESS_THAN_OR_EQUAL);
                            break;
                        }
                        if (comparison >= 0) break;
                        NumericalFilterOptimizer.setExpressionToBoolean(range, kind == FilterKind.GREATER_THAN || kind == FilterKind.GREATER_THAN_OR_EQUAL);
                        break;
                    }
                    case FLOAT: {
                        float converted = actual;
                        int comparison = BigDecimal.valueOf(actual).compareTo(BigDecimal.valueOf(converted));
                        NumericalFilterOptimizer.rewriteRangeOperator(range, kind, comparison);
                        rhs.getLiteral().setDoubleValue((double)converted);
                        break;
                    }
                    case DOUBLE: {
                        double converted = actual;
                        int comparison = BigDecimal.valueOf(actual).compareTo(BigDecimal.valueOf(converted));
                        NumericalFilterOptimizer.rewriteRangeOperator(range, kind, comparison);
                        rhs.getLiteral().setDoubleValue(converted);
                        break;
                    }
                }
                break;
            }
            case DOUBLE_VALUE: {
                double actual = rhs.getLiteral().getDoubleValue();
                switch (dataType) {
                    case INT: {
                        int converted = (int)actual;
                        int comparison = Double.compare(actual, converted);
                        if (comparison > 0 && converted == Integer.MAX_VALUE) {
                            NumericalFilterOptimizer.setExpressionToBoolean(range, kind == FilterKind.LESS_THAN || kind == FilterKind.LESS_THAN_OR_EQUAL);
                            break block0;
                        }
                        if (comparison < 0 && converted == Integer.MIN_VALUE) {
                            NumericalFilterOptimizer.setExpressionToBoolean(range, kind == FilterKind.GREATER_THAN || kind == FilterKind.GREATER_THAN_OR_EQUAL);
                            break block0;
                        }
                        NumericalFilterOptimizer.rewriteRangeOperator(range, kind, comparison);
                        rhs.getLiteral().setLongValue((long)converted);
                        break block0;
                    }
                    case LONG: {
                        long converted = (long)actual;
                        int comparison = BigDecimal.valueOf(actual).compareTo(BigDecimal.valueOf(converted));
                        if (comparison > 0 && converted == Long.MAX_VALUE) {
                            NumericalFilterOptimizer.setExpressionToBoolean(range, kind == FilterKind.LESS_THAN || kind == FilterKind.LESS_THAN_OR_EQUAL);
                            break block0;
                        }
                        if (comparison < 0 && converted == Long.MIN_VALUE) {
                            NumericalFilterOptimizer.setExpressionToBoolean(range, kind == FilterKind.GREATER_THAN || kind == FilterKind.GREATER_THAN_OR_EQUAL);
                            break block0;
                        }
                        NumericalFilterOptimizer.rewriteRangeOperator(range, kind, comparison);
                        rhs.getLiteral().setLongValue(converted);
                        break block0;
                    }
                    case FLOAT: {
                        float converted = (float)actual;
                        if (converted == Float.POSITIVE_INFINITY) {
                            NumericalFilterOptimizer.setExpressionToBoolean(range, kind == FilterKind.LESS_THAN || kind == FilterKind.LESS_THAN_OR_EQUAL);
                            break block0;
                        }
                        if (converted == Float.NEGATIVE_INFINITY) {
                            NumericalFilterOptimizer.setExpressionToBoolean(range, kind == FilterKind.GREATER_THAN || kind == FilterKind.GREATER_THAN_OR_EQUAL);
                            break block0;
                        }
                        int comparison = Double.compare(actual, converted);
                        NumericalFilterOptimizer.rewriteRangeOperator(range, kind, comparison);
                        rhs.getLiteral().setDoubleValue((double)converted);
                        break block0;
                    }
                }
            }
        }
        return range;
    }

    private static void rewriteRangeOperator(Expression range, FilterKind kind, int comparison) {
        if (comparison > 0) {
            if (kind == FilterKind.GREATER_THAN || kind == FilterKind.GREATER_THAN_OR_EQUAL) {
                range.getFunctionCall().setOperator(FilterKind.GREATER_THAN.name());
            } else if (kind == FilterKind.LESS_THAN || kind == FilterKind.LESS_THAN_OR_EQUAL) {
                range.getFunctionCall().setOperator(FilterKind.LESS_THAN_OR_EQUAL.name());
            }
        } else if (comparison < 0) {
            if (kind == FilterKind.GREATER_THAN || kind == FilterKind.GREATER_THAN_OR_EQUAL) {
                range.getFunctionCall().setOperator(FilterKind.GREATER_THAN_OR_EQUAL.name());
            } else if (kind == FilterKind.LESS_THAN || kind == FilterKind.LESS_THAN_OR_EQUAL) {
                range.getFunctionCall().setOperator(FilterKind.LESS_THAN.name());
            }
        }
    }

    private static boolean isNumericColumn(Expression expression, Schema schema) {
        if (expression.getType() != ExpressionType.IDENTIFIER) {
            return false;
        }
        String column = expression.getIdentifier().getName();
        FieldSpec fieldSpec = schema.getFieldSpecFor(column);
        if (fieldSpec == null || !fieldSpec.isSingleValueField()) {
            return false;
        }
        return schema.getFieldSpecFor(column).getDataType().isNumeric();
    }

    private static boolean isNumericLiteral(Expression expression) {
        if (expression.getType() == ExpressionType.LITERAL) {
            Literal._Fields type = (Literal._Fields)expression.getLiteral().getSetField();
            switch (type) {
                case SHORT_VALUE: 
                case INT_VALUE: 
                case LONG_VALUE: 
                case DOUBLE_VALUE: {
                    return true;
                }
            }
        }
        return false;
    }

    private static Expression setExpressionToBoolean(Expression expression, boolean value) {
        expression.unsetFunctionCall();
        expression.setType(ExpressionType.LITERAL);
        expression.setLiteral(Literal.boolValue((boolean)value));
        return expression;
    }
}

