/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.postaggregation;

import com.google.common.base.Preconditions;
import org.apache.pinot.common.function.FunctionInfo;
import org.apache.pinot.common.function.FunctionInvoker;
import org.apache.pinot.common.function.FunctionRegistry;
import org.apache.pinot.common.function.FunctionUtils;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.PinotDataType;

public class PostAggregationFunction {
    private final FunctionInvoker _functionInvoker;
    private final PinotDataType[] _argumentTypes;
    private final DataSchema.ColumnDataType _resultType;

    public PostAggregationFunction(String functionName, DataSchema.ColumnDataType[] argumentTypes) {
        int i;
        int numArguments = argumentTypes.length;
        FunctionInfo functionInfo = FunctionRegistry.getFunctionInfo((String)functionName, (int)numArguments);
        Preconditions.checkArgument((functionInfo != null ? 1 : 0) != 0, (String)"Unsupported function: %s with %s parameters", (Object)functionName, (int)numArguments);
        this._functionInvoker = new FunctionInvoker(functionInfo);
        Class[] parameterClasses = this._functionInvoker.getParameterClasses();
        PinotDataType[] parameterTypes = this._functionInvoker.getParameterTypes();
        int numParameters = parameterClasses.length;
        Preconditions.checkArgument((numArguments == numParameters ? 1 : 0) != 0, (String)"Wrong number of arguments for method: %s, expected: %s, actual: %s", (Object)functionInfo.getMethod(), (Object)numParameters, (Object)numArguments);
        for (i = 0; i < numParameters; ++i) {
            Preconditions.checkArgument((parameterTypes[i] != null ? 1 : 0) != 0, (String)"Unsupported parameter class: %s for method: %s", (Object)parameterClasses[i], (Object)functionInfo.getMethod());
        }
        this._argumentTypes = new PinotDataType[numArguments];
        for (i = 0; i < numArguments; ++i) {
            this._argumentTypes[i] = PinotDataType.getPinotDataTypeForExecution((DataSchema.ColumnDataType)argumentTypes[i]);
        }
        DataSchema.ColumnDataType resultType = FunctionUtils.getColumnDataType((Class)this._functionInvoker.getResultClass());
        this._resultType = resultType != null ? resultType : DataSchema.ColumnDataType.STRING;
    }

    public DataSchema.ColumnDataType getResultType() {
        return this._resultType;
    }

    public Object invoke(Object[] arguments) {
        int numArguments = arguments.length;
        PinotDataType[] parameterTypes = this._functionInvoker.getParameterTypes();
        for (int i = 0; i < numArguments; ++i) {
            PinotDataType parameterType = parameterTypes[i];
            PinotDataType argumentType = this._argumentTypes[i];
            if (parameterType == argumentType) continue;
            arguments[i] = parameterType.convert(arguments[i], argumentType);
        }
        Object result = this._functionInvoker.invoke(arguments);
        return this._resultType == DataSchema.ColumnDataType.STRING ? result.toString() : result;
    }
}

