/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.pruner;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.predicate.EqPredicate;
import org.apache.pinot.common.request.context.predicate.InPredicate;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.common.request.context.predicate.RangePredicate;
import org.apache.pinot.core.query.pruner.SegmentPruner;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.datasource.DataSourceMetadata;
import org.apache.pinot.segment.spi.index.reader.BloomFilterReader;
import org.apache.pinot.segment.spi.partition.PartitionFunction;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.exception.BadQueryRequestException;

public class ColumnValueSegmentPruner
implements SegmentPruner {
    public static final String IN_PREDICATE_THRESHOLD = "inpredicate.threshold";
    private int _inPredicateThreshold;

    @Override
    public void init(PinotConfiguration config) {
        this._inPredicateThreshold = config.getProperty(IN_PREDICATE_THRESHOLD, 10);
    }

    @Override
    public boolean prune(IndexSegment segment, QueryContext query) {
        FilterContext filter = query.getFilter();
        if (filter == null) {
            return false;
        }
        HashMap<String, DataSource> dataSourceCache = new HashMap<String, DataSource>();
        return this.pruneSegment(segment, filter, dataSourceCache);
    }

    private boolean pruneSegment(IndexSegment segment, FilterContext filter, Map<String, DataSource> dataSourceCache) {
        switch (filter.getType()) {
            case AND: {
                for (FilterContext child : filter.getChildren()) {
                    if (!this.pruneSegment(segment, child, dataSourceCache)) continue;
                    return true;
                }
                return false;
            }
            case OR: {
                for (FilterContext child : filter.getChildren()) {
                    if (this.pruneSegment(segment, child, dataSourceCache)) continue;
                    return false;
                }
                return true;
            }
            case PREDICATE: {
                Predicate predicate = filter.getPredicate();
                if (predicate.getLhs().getType() != ExpressionContext.Type.IDENTIFIER) {
                    return false;
                }
                Predicate.Type predicateType = predicate.getType();
                if (predicateType == Predicate.Type.EQ) {
                    return this.pruneEqPredicate(segment, (EqPredicate)predicate, dataSourceCache);
                }
                if (predicateType == Predicate.Type.RANGE) {
                    return this.pruneRangePredicate(segment, (RangePredicate)predicate, dataSourceCache);
                }
                if (predicateType == Predicate.Type.IN) {
                    return this.pruneInPredicate(segment, (InPredicate)predicate, dataSourceCache);
                }
                return false;
            }
        }
        throw new IllegalStateException();
    }

    private boolean pruneEqPredicate(IndexSegment segment, EqPredicate eqPredicate, Map<String, DataSource> dataSourceCache) {
        BloomFilterReader bloomFilter;
        Comparable value;
        String column = eqPredicate.getLhs().getIdentifier();
        DataSource dataSource = dataSourceCache.computeIfAbsent(column, arg_0 -> ((IndexSegment)segment).getDataSource(arg_0));
        assert (dataSource != null);
        DataSourceMetadata dataSourceMetadata = dataSource.getDataSourceMetadata();
        if (!this.checkMinMaxRange(dataSourceMetadata, value = ColumnValueSegmentPruner.convertValue(eqPredicate.getValue(), dataSourceMetadata.getDataType()))) {
            return true;
        }
        PartitionFunction partitionFunction = dataSourceMetadata.getPartitionFunction();
        if (partitionFunction != null) {
            Set partitions = dataSourceMetadata.getPartitions();
            assert (partitions != null);
            if (!partitions.contains(partitionFunction.getPartition((Object)value))) {
                return true;
            }
        }
        return (bloomFilter = dataSource.getBloomFilter()) != null && !bloomFilter.mightContain(value.toString());
    }

    private boolean pruneRangePredicate(IndexSegment segment, RangePredicate rangePredicate, Map<String, DataSource> dataSourceCache) {
        String column = rangePredicate.getLhs().getIdentifier();
        DataSource dataSource = dataSourceCache.computeIfAbsent(column, arg_0 -> ((IndexSegment)segment).getDataSource(arg_0));
        assert (dataSource != null);
        DataSourceMetadata dataSourceMetadata = dataSource.getDataSourceMetadata();
        FieldSpec.DataType dataType = dataSourceMetadata.getDataType();
        String lowerBound = rangePredicate.getLowerBound();
        Comparable lowerBoundValue = null;
        if (!lowerBound.equals("*")) {
            lowerBoundValue = ColumnValueSegmentPruner.convertValue(lowerBound, dataType);
        }
        boolean lowerInclusive = rangePredicate.isLowerInclusive();
        String upperBound = rangePredicate.getUpperBound();
        Comparable upperBoundValue = null;
        if (!upperBound.equals("*")) {
            upperBoundValue = ColumnValueSegmentPruner.convertValue(upperBound, dataType);
        }
        boolean upperInclusive = rangePredicate.isUpperInclusive();
        if (lowerBoundValue != null && upperBoundValue != null && (lowerInclusive && upperInclusive ? lowerBoundValue.compareTo(upperBoundValue) > 0 : lowerBoundValue.compareTo(upperBoundValue) >= 0)) {
            return true;
        }
        Comparable minValue = dataSourceMetadata.getMinValue();
        if (minValue != null && upperBoundValue != null && (upperInclusive ? upperBoundValue.compareTo(minValue) < 0 : upperBoundValue.compareTo(minValue) <= 0)) {
            return true;
        }
        Comparable maxValue = dataSourceMetadata.getMaxValue();
        return maxValue != null && lowerBoundValue != null && (lowerInclusive ? lowerBoundValue.compareTo(maxValue) > 0 : lowerBoundValue.compareTo(maxValue) >= 0);
    }

    private boolean pruneInPredicate(IndexSegment segment, InPredicate inPredicate, Map<String, DataSource> dataSourceCache) {
        String column = inPredicate.getLhs().getIdentifier();
        DataSource dataSource = dataSourceCache.computeIfAbsent(column, arg_0 -> ((IndexSegment)segment).getDataSource(arg_0));
        assert (dataSource != null);
        DataSourceMetadata dataSourceMetadata = dataSource.getDataSourceMetadata();
        List values = inPredicate.getValues();
        if (values.size() > this._inPredicateThreshold) {
            return false;
        }
        for (String value : values) {
            Comparable inValue = ColumnValueSegmentPruner.convertValue(value, dataSourceMetadata.getDataType());
            if (!this.checkMinMaxRange(dataSourceMetadata, inValue)) continue;
            return false;
        }
        BloomFilterReader bloomFilter = dataSource.getBloomFilter();
        if (bloomFilter != null) {
            for (String value : values) {
                if (!bloomFilter.mightContain(value)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkMinMaxRange(DataSourceMetadata dataSourceMetadata, Comparable value) {
        Comparable minValue = dataSourceMetadata.getMinValue();
        if (minValue != null && value.compareTo(minValue) < 0) {
            return false;
        }
        Comparable maxValue = dataSourceMetadata.getMaxValue();
        return maxValue == null || value.compareTo(maxValue) <= 0;
    }

    private static Comparable convertValue(String stringValue, FieldSpec.DataType dataType) {
        try {
            return dataType.convertInternal(stringValue);
        }
        catch (Exception e) {
            throw new BadQueryRequestException((Throwable)e);
        }
    }
}

