/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.pruner;

import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.core.query.config.SegmentPrunerConfig;
import org.apache.pinot.core.query.pruner.SegmentPruner;
import org.apache.pinot.core.query.pruner.SegmentPrunerProvider;
import org.apache.pinot.core.query.pruner.ValidSegmentPruner;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentPrunerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentPrunerService.class);
    private final List<SegmentPruner> _segmentPruners;

    public SegmentPrunerService(SegmentPrunerConfig config) {
        int numPruners = config.numSegmentPruners();
        this._segmentPruners = new ArrayList<SegmentPruner>(numPruners + 1);
        String validSegmentPrunerName = ValidSegmentPruner.class.getSimpleName();
        this._segmentPruners.add(SegmentPrunerProvider.getSegmentPruner(validSegmentPrunerName, new PinotConfiguration()));
        for (int i = 0; i < numPruners; ++i) {
            String segmentPrunerName = config.getSegmentPrunerName(i);
            if (validSegmentPrunerName.equalsIgnoreCase(segmentPrunerName)) continue;
            LOGGER.info("Adding segment pruner: " + segmentPrunerName);
            this._segmentPruners.add(SegmentPrunerProvider.getSegmentPruner(segmentPrunerName, config.getSegmentPrunerConfig(i)));
        }
    }

    public List<IndexSegment> prune(List<IndexSegment> segments, QueryContext query) {
        for (SegmentPruner segmentPruner : this._segmentPruners) {
            segments = segmentPruner.prune(segments, query);
        }
        return segments;
    }
}

