/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.BrokerMeter;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.metrics.BrokerTimer;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.response.broker.BrokerResponseNative;
import org.apache.pinot.common.response.broker.QueryProcessingException;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.query.reduce.DataTableReducer;
import org.apache.pinot.core.query.reduce.DataTableReducerContext;
import org.apache.pinot.core.query.reduce.ResultReducerFactory;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.utils.BrokerRequestToQueryContextConverter;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.utils.CommonConstants;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class BrokerReduceService {
    protected static final int QUERY_RUNNER_THREAD_PRIORITY = 7;
    private static final Logger LOGGER = LoggerFactory.getLogger(BrokerReduceService.class);
    private static final String REDUCE_THREAD_NAME_FORMAT = "brw-%d";
    private final ExecutorService _reduceExecutorService;
    private final int _maxReduceThreadsPerQuery;
    private final int _groupByTrimThreshold;

    public BrokerReduceService(PinotConfiguration config) {
        this._maxReduceThreadsPerQuery = config.getProperty("pinot.broker.max.reduce.threads.per.query", CommonConstants.Broker.DEFAULT_MAX_REDUCE_THREADS_PER_QUERY);
        this._groupByTrimThreshold = config.getProperty("pinot.broker.groupby.trim.threshold", 1000000);
        int numThreadsInExecutorService = Runtime.getRuntime().availableProcessors();
        LOGGER.info("Initializing BrokerReduceService with {} threads, and {} max reduce threads.", (Object)numThreadsInExecutorService, (Object)this._maxReduceThreadsPerQuery);
        ThreadFactory reduceThreadFactory = new ThreadFactoryBuilder().setDaemon(false).setPriority(7).setNameFormat(REDUCE_THREAD_NAME_FORMAT).build();
        this._reduceExecutorService = Executors.newFixedThreadPool(numThreadsInExecutorService, reduceThreadFactory);
    }

    private static void updateAlias(QueryContext queryContext, BrokerResponseNative brokerResponseNative) {
        List<ExpressionContext> selectExpressions;
        int numSelectExpressions;
        ResultTable resultTable = brokerResponseNative.getResultTable();
        if (resultTable == null) {
            return;
        }
        List<String> aliasList = queryContext.getAliasList();
        if (aliasList.isEmpty()) {
            return;
        }
        String[] columnNames = resultTable.getDataSchema().getColumnNames();
        if (columnNames.length != (numSelectExpressions = (selectExpressions = queryContext.getSelectExpressions()).size())) {
            return;
        }
        for (int i = 0; i < numSelectExpressions; ++i) {
            String alias = aliasList.get(i);
            if (alias == null) continue;
            columnNames[i] = alias;
        }
    }

    public BrokerResponseNative reduceOnDataTable(BrokerRequest brokerRequest, Map<ServerRoutingInstance, DataTable> dataTableMap, long reduceTimeOutMs, @Nullable BrokerMetrics brokerMetrics) {
        if (dataTableMap.size() == 0) {
            return BrokerResponseNative.empty();
        }
        BrokerResponseNative brokerResponseNative = new BrokerResponseNative();
        List processingExceptions = brokerResponseNative.getProcessingExceptions();
        long numDocsScanned = 0L;
        long numEntriesScannedInFilter = 0L;
        long numEntriesScannedPostFilter = 0L;
        long numSegmentsQueried = 0L;
        long numSegmentsProcessed = 0L;
        long numSegmentsMatched = 0L;
        long numConsumingSegmentsProcessed = 0L;
        long minConsumingFreshnessTimeMs = Long.MAX_VALUE;
        long numTotalDocs = 0L;
        long offlineThreadCpuTimeNs = 0L;
        long realtimeThreadCpuTimeNs = 0L;
        boolean numGroupsLimitReached = false;
        PinotQuery pinotQuery = brokerRequest.getPinotQuery();
        Map queryOptions = pinotQuery != null ? pinotQuery.getQueryOptions() : brokerRequest.getQueryOptions();
        boolean enableTrace = queryOptions != null && Boolean.parseBoolean((String)queryOptions.get("trace"));
        DataSchema cachedDataSchema = null;
        Iterator<Map.Entry<ServerRoutingInstance, DataTable>> iterator = dataTableMap.entrySet().iterator();
        while (iterator.hasNext()) {
            String numTotalDocsString;
            String threadCpuTimeNsString;
            String minConsumingFreshnessTimeMsString;
            String numConsumingString;
            String numSegmentsMatchedString;
            String numSegmentsProcessedString;
            String numSegmentsQueriedString;
            String numEntriesScannedPostFilterString;
            String numEntriesScannedInFilterString;
            Map.Entry<ServerRoutingInstance, DataTable> entry = iterator.next();
            DataTable dataTable = entry.getValue();
            Map metadata = dataTable.getMetadata();
            if (enableTrace) {
                brokerResponseNative.getTraceInfo().put(entry.getKey().getHostname(), (String)metadata.get(DataTable.MetadataKey.TRACE_INFO.getName()));
            }
            Map exceptions = dataTable.getExceptions();
            Iterator iterator2 = exceptions.keySet().iterator();
            while (iterator2.hasNext()) {
                int key = (Integer)iterator2.next();
                processingExceptions.add(new QueryProcessingException(key, (String)exceptions.get(key)));
            }
            String numDocsScannedString = (String)metadata.get(DataTable.MetadataKey.NUM_DOCS_SCANNED.getName());
            if (numDocsScannedString != null) {
                numDocsScanned += Long.parseLong(numDocsScannedString);
            }
            if ((numEntriesScannedInFilterString = (String)metadata.get(DataTable.MetadataKey.NUM_ENTRIES_SCANNED_IN_FILTER.getName())) != null) {
                numEntriesScannedInFilter += Long.parseLong(numEntriesScannedInFilterString);
            }
            if ((numEntriesScannedPostFilterString = (String)metadata.get(DataTable.MetadataKey.NUM_ENTRIES_SCANNED_POST_FILTER.getName())) != null) {
                numEntriesScannedPostFilter += Long.parseLong(numEntriesScannedPostFilterString);
            }
            if ((numSegmentsQueriedString = (String)metadata.get(DataTable.MetadataKey.NUM_SEGMENTS_QUERIED.getName())) != null) {
                numSegmentsQueried += Long.parseLong(numSegmentsQueriedString);
            }
            if ((numSegmentsProcessedString = (String)metadata.get(DataTable.MetadataKey.NUM_SEGMENTS_PROCESSED.getName())) != null) {
                numSegmentsProcessed += Long.parseLong(numSegmentsProcessedString);
            }
            if ((numSegmentsMatchedString = (String)metadata.get(DataTable.MetadataKey.NUM_SEGMENTS_MATCHED.getName())) != null) {
                numSegmentsMatched += Long.parseLong(numSegmentsMatchedString);
            }
            if ((numConsumingString = (String)metadata.get(DataTable.MetadataKey.NUM_CONSUMING_SEGMENTS_PROCESSED.getName())) != null) {
                numConsumingSegmentsProcessed += Long.parseLong(numConsumingString);
            }
            if ((minConsumingFreshnessTimeMsString = (String)metadata.get(DataTable.MetadataKey.MIN_CONSUMING_FRESHNESS_TIME_MS.getName())) != null) {
                minConsumingFreshnessTimeMs = Math.min(Long.parseLong(minConsumingFreshnessTimeMsString), minConsumingFreshnessTimeMs);
            }
            if ((threadCpuTimeNsString = (String)metadata.get(DataTable.MetadataKey.THREAD_CPU_TIME_NS.getName())) != null) {
                if (entry.getKey().getTableType() == TableType.OFFLINE) {
                    offlineThreadCpuTimeNs += Long.parseLong(threadCpuTimeNsString);
                } else {
                    realtimeThreadCpuTimeNs += Long.parseLong(threadCpuTimeNsString);
                }
            }
            if ((numTotalDocsString = (String)metadata.get(DataTable.MetadataKey.TOTAL_DOCS.getName())) != null) {
                numTotalDocs += Long.parseLong(numTotalDocsString);
            }
            numGroupsLimitReached |= Boolean.parseBoolean((String)metadata.get(DataTable.MetadataKey.NUM_GROUPS_LIMIT_REACHED.getName()));
            DataSchema dataSchema = dataTable.getDataSchema();
            if (dataSchema == null) {
                iterator.remove();
                continue;
            }
            if (dataTable.getNumberOfRows() == 0) {
                if (cachedDataSchema == null) {
                    cachedDataSchema = dataSchema;
                }
                iterator.remove();
                continue;
            }
            cachedDataSchema = dataSchema;
        }
        brokerResponseNative.setNumDocsScanned(numDocsScanned);
        brokerResponseNative.setNumEntriesScannedInFilter(numEntriesScannedInFilter);
        brokerResponseNative.setNumEntriesScannedPostFilter(numEntriesScannedPostFilter);
        brokerResponseNative.setNumSegmentsQueried(numSegmentsQueried);
        brokerResponseNative.setNumSegmentsProcessed(numSegmentsProcessed);
        brokerResponseNative.setNumSegmentsMatched(numSegmentsMatched);
        brokerResponseNative.setTotalDocs(numTotalDocs);
        brokerResponseNative.setNumGroupsLimitReached(numGroupsLimitReached);
        brokerResponseNative.setOfflineThreadCpuTimeNs(offlineThreadCpuTimeNs);
        brokerResponseNative.setRealtimeThreadCpuTimeNs(realtimeThreadCpuTimeNs);
        if (numConsumingSegmentsProcessed > 0L) {
            brokerResponseNative.setNumConsumingSegmentsQueried(numConsumingSegmentsProcessed);
            brokerResponseNative.setMinConsumingFreshnessTimeMs(minConsumingFreshnessTimeMs);
        }
        String tableName = brokerRequest.getQuerySource().getTableName();
        String rawTableName = TableNameBuilder.extractRawTableName((String)tableName);
        if (brokerMetrics != null) {
            brokerMetrics.addMeteredTableValue(rawTableName, (AbstractMetrics.Meter)BrokerMeter.DOCUMENTS_SCANNED, numDocsScanned);
            brokerMetrics.addMeteredTableValue(rawTableName, (AbstractMetrics.Meter)BrokerMeter.ENTRIES_SCANNED_IN_FILTER, numEntriesScannedInFilter);
            brokerMetrics.addMeteredTableValue(rawTableName, (AbstractMetrics.Meter)BrokerMeter.ENTRIES_SCANNED_POST_FILTER, numEntriesScannedPostFilter);
            brokerMetrics.addTimedTableValue(rawTableName, (AbstractMetrics.Timer)BrokerTimer.OFFLINE_THREAD_CPU_TIME_NS, offlineThreadCpuTimeNs, TimeUnit.NANOSECONDS);
            brokerMetrics.addTimedTableValue(rawTableName, (AbstractMetrics.Timer)BrokerTimer.REALTIME_THREAD_CPU_TIME_NS, realtimeThreadCpuTimeNs, TimeUnit.NANOSECONDS);
            if (numConsumingSegmentsProcessed > 0L && minConsumingFreshnessTimeMs > 0L) {
                brokerMetrics.addTimedTableValue(rawTableName, (AbstractMetrics.Timer)BrokerTimer.FRESHNESS_LAG_MS, System.currentTimeMillis() - minConsumingFreshnessTimeMs, TimeUnit.MILLISECONDS);
            }
        }
        if (cachedDataSchema == null) {
            return brokerResponseNative;
        }
        QueryContext queryContext = BrokerRequestToQueryContextConverter.convert(brokerRequest);
        DataTableReducer dataTableReducer = ResultReducerFactory.getResultReducer(queryContext);
        dataTableReducer.reduceAndSetResults(rawTableName, cachedDataSchema, dataTableMap, brokerResponseNative, new DataTableReducerContext(this._reduceExecutorService, this._maxReduceThreadsPerQuery, reduceTimeOutMs, this._groupByTrimThreshold), brokerMetrics);
        BrokerReduceService.updateAlias(queryContext, brokerResponseNative);
        return brokerResponseNative;
    }

    public void shutDown() {
        this._reduceExecutorService.shutdownNow();
    }
}

