/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import java.sql.Timestamp;
import java.util.List;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluatorProvider;
import org.apache.pinot.core.query.reduce.PostAggregationHandler;
import org.apache.pinot.spi.data.FieldSpec;

public class HavingFilterHandler {
    private final PostAggregationHandler _postAggregationHandler;
    private final RowMatcher _rowMatcher;

    public HavingFilterHandler(FilterContext havingFilter, PostAggregationHandler postAggregationHandler) {
        this._postAggregationHandler = postAggregationHandler;
        this._rowMatcher = this.getRowMatcher(havingFilter);
    }

    public boolean isMatch(Object[] row) {
        return this._rowMatcher.isMatch(row);
    }

    private RowMatcher getRowMatcher(FilterContext filter) {
        switch (filter.getType()) {
            case AND: {
                return new AndRowMatcher(filter.getChildren());
            }
            case OR: {
                return new OrRowMatcher(filter.getChildren());
            }
            case PREDICATE: {
                return new PredicateRowMatcher(filter.getPredicate());
            }
        }
        throw new IllegalStateException();
    }

    private class PredicateRowMatcher
    implements RowMatcher {
        PostAggregationHandler.ValueExtractor _valueExtractor;
        FieldSpec.DataType _valueType;
        PredicateEvaluator _predicateEvaluator;

        PredicateRowMatcher(Predicate predicate) {
            this._valueExtractor = HavingFilterHandler.this._postAggregationHandler.getValueExtractor(predicate.getLhs());
            this._valueType = this._valueExtractor.getColumnDataType().toDataType();
            this._predicateEvaluator = PredicateEvaluatorProvider.getPredicateEvaluator(predicate, null, this._valueType);
        }

        @Override
        public boolean isMatch(Object[] row) {
            Object value = this._valueExtractor.extract(row);
            switch (this._valueType) {
                case INT: {
                    return this._predicateEvaluator.applySV((Integer)value);
                }
                case LONG: {
                    return this._predicateEvaluator.applySV((Long)value);
                }
                case FLOAT: {
                    return this._predicateEvaluator.applySV(((Float)value).floatValue());
                }
                case DOUBLE: {
                    return this._predicateEvaluator.applySV((Double)value);
                }
                case BOOLEAN: {
                    return this._predicateEvaluator.applySV((Boolean)value != false ? 1 : 0);
                }
                case TIMESTAMP: {
                    return this._predicateEvaluator.applySV(((Timestamp)value).getTime());
                }
                case STRING: {
                    return this._predicateEvaluator.applySV((String)value);
                }
                case BYTES: {
                    return this._predicateEvaluator.applySV((byte[])value);
                }
            }
            throw new IllegalStateException();
        }
    }

    private class OrRowMatcher
    implements RowMatcher {
        RowMatcher[] _childMatchers;

        OrRowMatcher(List<FilterContext> childFilters) {
            int numChildren = childFilters.size();
            this._childMatchers = new RowMatcher[numChildren];
            for (int i = 0; i < numChildren; ++i) {
                this._childMatchers[i] = HavingFilterHandler.this.getRowMatcher(childFilters.get(i));
            }
        }

        @Override
        public boolean isMatch(Object[] row) {
            for (RowMatcher childMatcher : this._childMatchers) {
                if (!childMatcher.isMatch(row)) continue;
                return true;
            }
            return false;
        }
    }

    private class AndRowMatcher
    implements RowMatcher {
        RowMatcher[] _childMatchers;

        AndRowMatcher(List<FilterContext> childFilters) {
            int numChildren = childFilters.size();
            this._childMatchers = new RowMatcher[numChildren];
            for (int i = 0; i < numChildren; ++i) {
                this._childMatchers[i] = HavingFilterHandler.this.getRowMatcher(childFilters.get(i));
            }
        }

        @Override
        public boolean isMatch(Object[] row) {
            for (RowMatcher childMatcher : this._childMatchers) {
                if (childMatcher.isMatch(row)) continue;
                return false;
            }
            return true;
        }
    }

    private static interface RowMatcher {
        public boolean isMatch(Object[] var1);
    }
}

