/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.BrokerMeter;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.response.broker.BrokerResponseNative;
import org.apache.pinot.common.response.broker.QueryProcessingException;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.response.broker.SelectionResults;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.query.reduce.DataTableReducer;
import org.apache.pinot.core.query.reduce.DataTableReducerContext;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.selection.SelectionOperatorService;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.apache.pinot.core.util.QueryOptions;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectionDataTableReducer
implements DataTableReducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectionDataTableReducer.class);
    private final QueryContext _queryContext;
    private final boolean _preserveType;
    private final boolean _responseFormatSql;

    SelectionDataTableReducer(QueryContext queryContext) {
        this._queryContext = queryContext;
        QueryOptions queryOptions = new QueryOptions(queryContext.getQueryOptions());
        this._preserveType = queryOptions.isPreserveType();
        this._responseFormatSql = queryOptions.isResponseFormatSQL();
    }

    @Override
    public void reduceAndSetResults(String tableName, DataSchema dataSchema, Map<ServerRoutingInstance, DataTable> dataTableMap, BrokerResponseNative brokerResponseNative, DataTableReducerContext reducerContext, BrokerMetrics brokerMetrics) {
        if (dataTableMap.isEmpty()) {
            List<String> selectionColumns = SelectionOperatorUtils.getSelectionColumns(this._queryContext, dataSchema);
            if (this._responseFormatSql) {
                DataSchema selectionDataSchema = SelectionOperatorUtils.getResultTableDataSchema(dataSchema, selectionColumns);
                brokerResponseNative.setResultTable(new ResultTable(selectionDataSchema, Collections.emptyList()));
            } else {
                brokerResponseNative.setSelectionResults(new SelectionResults(selectionColumns, Collections.emptyList()));
            }
        } else {
            int limit;
            List<ServerRoutingInstance> droppedServers;
            if (dataTableMap.size() > 1 && !(droppedServers = this.removeConflictingResponses(dataSchema, dataTableMap)).isEmpty()) {
                String errorMessage = QueryException.MERGE_RESPONSE_ERROR.getMessage() + ": responses for table: " + tableName + " from servers: " + droppedServers + " got dropped due to data schema inconsistency.";
                LOGGER.warn(errorMessage);
                if (brokerMetrics != null) {
                    brokerMetrics.addMeteredTableValue(TableNameBuilder.extractRawTableName((String)tableName), (AbstractMetrics.Meter)BrokerMeter.RESPONSE_MERGE_EXCEPTIONS, 1L);
                }
                brokerResponseNative.addToExceptions(new QueryProcessingException(500, errorMessage));
            }
            if ((limit = this._queryContext.getLimit()) > 0 && this._queryContext.getOrderByExpressions() != null) {
                SelectionOperatorService selectionService = new SelectionOperatorService(this._queryContext, dataSchema);
                selectionService.reduceWithOrdering(dataTableMap.values());
                if (this._responseFormatSql) {
                    brokerResponseNative.setResultTable(selectionService.renderResultTableWithOrdering());
                } else {
                    brokerResponseNative.setSelectionResults(selectionService.renderSelectionResultsWithOrdering(this._preserveType));
                }
            } else {
                List<String> selectionColumns = SelectionOperatorUtils.getSelectionColumns(this._queryContext, dataSchema);
                List<Object[]> reducedRows = SelectionOperatorUtils.reduceWithoutOrdering(dataTableMap.values(), limit);
                if (this._responseFormatSql) {
                    brokerResponseNative.setResultTable(SelectionOperatorUtils.renderResultTableWithoutOrdering(reducedRows, dataSchema, selectionColumns));
                } else {
                    brokerResponseNative.setSelectionResults(SelectionOperatorUtils.renderSelectionResultsWithoutOrdering(reducedRows, dataSchema, selectionColumns, this._preserveType));
                }
            }
        }
    }

    private List<ServerRoutingInstance> removeConflictingResponses(DataSchema dataSchema, Map<ServerRoutingInstance, DataTable> dataTableMap) {
        ArrayList<ServerRoutingInstance> droppedServers = new ArrayList<ServerRoutingInstance>();
        Iterator<Map.Entry<ServerRoutingInstance, DataTable>> iterator = dataTableMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ServerRoutingInstance, DataTable> entry = iterator.next();
            DataSchema dataSchemaToCompare = entry.getValue().getDataSchema();
            assert (dataSchemaToCompare != null);
            if (!dataSchema.isTypeCompatibleWith(dataSchemaToCompare)) {
                droppedServers.add(entry.getKey());
                iterator.remove();
                continue;
            }
            dataSchema.upgradeToCover(dataSchemaToCompare);
        }
        return droppedServers;
    }
}

