/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.request.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionFactory;

public class QueryContext {
    private final String _tableName;
    private final List<ExpressionContext> _selectExpressions;
    private final List<String> _aliasList;
    private final FilterContext _filter;
    private final List<ExpressionContext> _groupByExpressions;
    private final FilterContext _havingFilter;
    private final List<OrderByExpressionContext> _orderByExpressions;
    private final int _limit;
    private final int _offset;
    private final Map<String, String> _queryOptions;
    private final Map<String, String> _debugOptions;
    private final BrokerRequest _brokerRequest;
    private AggregationFunction[] _aggregationFunctions;
    private Map<FunctionContext, Integer> _aggregationFunctionIndexMap;
    private Set<String> _columns;

    private QueryContext(String tableName, List<ExpressionContext> selectExpressions, List<String> aliasList, @Nullable FilterContext filter, @Nullable List<ExpressionContext> groupByExpressions, @Nullable FilterContext havingFilter, @Nullable List<OrderByExpressionContext> orderByExpressions, int limit, int offset, @Nullable Map<String, String> queryOptions, @Nullable Map<String, String> debugOptions, BrokerRequest brokerRequest) {
        this._tableName = tableName;
        this._selectExpressions = selectExpressions;
        this._aliasList = Collections.unmodifiableList(aliasList);
        this._filter = filter;
        this._groupByExpressions = groupByExpressions;
        this._havingFilter = havingFilter;
        this._orderByExpressions = orderByExpressions;
        this._limit = limit;
        this._offset = offset;
        this._queryOptions = queryOptions;
        this._debugOptions = debugOptions;
        this._brokerRequest = brokerRequest;
    }

    public String getTableName() {
        return this._tableName;
    }

    public List<ExpressionContext> getSelectExpressions() {
        return this._selectExpressions;
    }

    public List<String> getAliasList() {
        return this._aliasList;
    }

    @Nullable
    public FilterContext getFilter() {
        return this._filter;
    }

    @Nullable
    public List<ExpressionContext> getGroupByExpressions() {
        return this._groupByExpressions;
    }

    @Nullable
    public FilterContext getHavingFilter() {
        return this._havingFilter;
    }

    @Nullable
    public List<OrderByExpressionContext> getOrderByExpressions() {
        return this._orderByExpressions;
    }

    public int getLimit() {
        return this._limit;
    }

    public int getOffset() {
        return this._offset;
    }

    @Nullable
    public Map<String, String> getQueryOptions() {
        return this._queryOptions;
    }

    @Nullable
    public Map<String, String> getDebugOptions() {
        return this._debugOptions;
    }

    public BrokerRequest getBrokerRequest() {
        return this._brokerRequest;
    }

    @Nullable
    public AggregationFunction[] getAggregationFunctions() {
        return this._aggregationFunctions;
    }

    @Nullable
    public Map<FunctionContext, Integer> getAggregationFunctionIndexMap() {
        return this._aggregationFunctionIndexMap;
    }

    public Set<String> getColumns() {
        return this._columns;
    }

    public String toString() {
        return "QueryContext{_tableName='" + this._tableName + "', _selectExpressions=" + this._selectExpressions + ", _aliasList=" + this._aliasList + ", _filter=" + this._filter + ", _groupByExpressions=" + this._groupByExpressions + ", _havingFilter=" + this._havingFilter + ", _orderByExpressions=" + this._orderByExpressions + ", _limit=" + this._limit + ", _offset=" + this._offset + ", _queryOptions=" + this._queryOptions + ", _debugOptions=" + this._debugOptions + ", _brokerRequest=" + this._brokerRequest + "}";
    }

    public static class Builder {
        private String _tableName;
        private List<ExpressionContext> _selectExpressions;
        private List<String> _aliasList;
        private FilterContext _filter;
        private List<ExpressionContext> _groupByExpressions;
        private FilterContext _havingFilter;
        private List<OrderByExpressionContext> _orderByExpressions;
        private int _limit;
        private int _offset;
        private Map<String, String> _queryOptions;
        private Map<String, String> _debugOptions;
        private BrokerRequest _brokerRequest;

        public Builder setTableName(String tableName) {
            this._tableName = tableName;
            return this;
        }

        public Builder setSelectExpressions(List<ExpressionContext> selectExpressions) {
            this._selectExpressions = selectExpressions;
            return this;
        }

        public Builder setAliasList(List<String> aliasList) {
            this._aliasList = aliasList;
            return this;
        }

        public Builder setFilter(@Nullable FilterContext filter) {
            this._filter = filter;
            return this;
        }

        public Builder setGroupByExpressions(@Nullable List<ExpressionContext> groupByExpressions) {
            this._groupByExpressions = groupByExpressions;
            return this;
        }

        public Builder setHavingFilter(@Nullable FilterContext havingFilter) {
            this._havingFilter = havingFilter;
            return this;
        }

        public Builder setOrderByExpressions(@Nullable List<OrderByExpressionContext> orderByExpressions) {
            this._orderByExpressions = orderByExpressions;
            return this;
        }

        public Builder setLimit(int limit) {
            this._limit = limit;
            return this;
        }

        public Builder setOffset(int offset) {
            this._offset = offset;
            return this;
        }

        public Builder setQueryOptions(@Nullable Map<String, String> queryOptions) {
            this._queryOptions = queryOptions;
            return this;
        }

        public Builder setDebugOptions(@Nullable Map<String, String> debugOptions) {
            this._debugOptions = debugOptions;
            return this;
        }

        public Builder setBrokerRequest(BrokerRequest brokerRequest) {
            this._brokerRequest = brokerRequest;
            return this;
        }

        public QueryContext build() {
            QueryContext queryContext = new QueryContext(this._tableName, this._selectExpressions, this._aliasList, this._filter, this._groupByExpressions, this._havingFilter, this._orderByExpressions, this._limit, this._offset, this._queryOptions, this._debugOptions, this._brokerRequest);
            this.generateAggregationFunctions(queryContext);
            this.extractColumns(queryContext);
            return queryContext;
        }

        private void generateAggregationFunctions(QueryContext queryContext) {
            int functionIndex;
            ArrayList<AggregationFunction> aggregationFunctions = new ArrayList<AggregationFunction>();
            HashMap<FunctionContext, Integer> aggregationFunctionIndexMap = new HashMap<FunctionContext, Integer>();
            ArrayList<FunctionContext> aggregationsInSelect = new ArrayList<FunctionContext>();
            for (ExpressionContext selectExpression : queryContext._selectExpressions) {
                Builder.getAggregations(selectExpression, aggregationsInSelect);
            }
            for (FunctionContext function : aggregationsInSelect) {
                int functionIndex2 = aggregationFunctions.size();
                aggregationFunctions.add(AggregationFunctionFactory.getAggregationFunction(function, queryContext));
                aggregationFunctionIndexMap.put(function, functionIndex2);
            }
            if (queryContext._havingFilter != null) {
                ArrayList<FunctionContext> aggregationsInHaving = new ArrayList<FunctionContext>();
                Builder.getAggregations(queryContext._havingFilter, aggregationsInHaving);
                for (FunctionContext function : aggregationsInHaving) {
                    if (aggregationFunctionIndexMap.containsKey(function)) continue;
                    functionIndex = aggregationFunctions.size();
                    aggregationFunctions.add(AggregationFunctionFactory.getAggregationFunction(function, queryContext));
                    aggregationFunctionIndexMap.put(function, functionIndex);
                }
            }
            if (queryContext._orderByExpressions != null) {
                ArrayList<FunctionContext> aggregationsInOrderBy = new ArrayList<FunctionContext>();
                for (OrderByExpressionContext orderByExpression : queryContext._orderByExpressions) {
                    Builder.getAggregations(orderByExpression.getExpression(), aggregationsInOrderBy);
                }
                for (FunctionContext function : aggregationsInOrderBy) {
                    if (aggregationFunctionIndexMap.containsKey(function)) continue;
                    functionIndex = aggregationFunctions.size();
                    aggregationFunctions.add(AggregationFunctionFactory.getAggregationFunction(function, queryContext));
                    aggregationFunctionIndexMap.put(function, functionIndex);
                }
            }
            if (!aggregationFunctions.isEmpty()) {
                queryContext._aggregationFunctions = aggregationFunctions.toArray(new AggregationFunction[0]);
                queryContext._aggregationFunctionIndexMap = aggregationFunctionIndexMap;
            }
        }

        private static void getAggregations(ExpressionContext expression, List<FunctionContext> aggregations) {
            FunctionContext function = expression.getFunction();
            if (function == null) {
                return;
            }
            if (function.getType() == FunctionContext.Type.AGGREGATION) {
                aggregations.add(function);
            } else {
                for (ExpressionContext argument : function.getArguments()) {
                    Builder.getAggregations(argument, aggregations);
                }
            }
        }

        private static void getAggregations(FilterContext filter, List<FunctionContext> aggregations) {
            List children = filter.getChildren();
            if (children != null) {
                for (FilterContext child : children) {
                    Builder.getAggregations(child, aggregations);
                }
            } else {
                Builder.getAggregations(filter.getPredicate().getLhs(), aggregations);
            }
        }

        private void extractColumns(QueryContext query) {
            HashSet<String> columns = new HashSet<String>();
            for (ExpressionContext expression : query._selectExpressions) {
                expression.getColumns(columns);
            }
            if (query._filter != null) {
                query._filter.getColumns(columns);
            }
            if (query._groupByExpressions != null) {
                for (ExpressionContext expression : query._groupByExpressions) {
                    expression.getColumns(columns);
                }
            }
            if (query._havingFilter != null) {
                query._havingFilter.getColumns(columns);
            }
            if (query._orderByExpressions != null) {
                for (OrderByExpressionContext orderByExpression : query._orderByExpressions) {
                    orderByExpression.getColumns(columns);
                }
            }
            if (query._aggregationFunctions != null) {
                for (AggregationFunction aggregationFunction : query._aggregationFunctions) {
                    List<ExpressionContext> inputExpressions = aggregationFunction.getInputExpressions();
                    for (ExpressionContext expression : inputExpressions) {
                        expression.getColumns(columns);
                    }
                }
            }
            query._columns = columns;
        }
    }
}

